/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.classpath;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.classpath.AcceleoClasspathContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class AcceleoClasspathContainerWizard
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IJavaProject javaProject;
    private IClasspathEntry classpathEntry;
    private Button engineButton;
    private Button parserButton;

    public AcceleoClasspathContainerWizard(String pageName) {
        super(pageName);
        this.classpathEntry = JavaCore.newContainerEntry((IPath)AcceleoClasspathContainer.ACCELEO_CLASSPATH_CONTAINER_PATH_RUNTIME);
    }

    public AcceleoClasspathContainerWizard() {
        super(AcceleoUIMessages.getString("AcceleoClasspathContainerWizard.PageName"));
        this.setTitle(AcceleoUIMessages.getString("AcceleoClasspathContainerWizard.PageTitle"));
        this.setDescription(AcceleoUIMessages.getString("AcceleoClasspathContainerWizard.PageDescription"));
        this.setImageDescriptor(AcceleoUIActivator.getImageDescriptor("icons/AcceleoWizard.gif"));
        this.classpathEntry = JavaCore.newContainerEntry((IPath)AcceleoClasspathContainer.ACCELEO_CLASSPATH_CONTAINER_PATH_RUNTIME);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        this.engineButton = new Button(composite, 32);
        this.engineButton.setLayoutData((Object)gridData);
        this.engineButton.setText(AcceleoUIMessages.getString("AcceleoClasspathContainerWizard.AcceleoEngine"));
        Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        ToolBar result = new ToolBar(composite, 0x880000);
        result.setLayoutData((Object)new GridData(128));
        ToolItem item = new ToolItem(result, 0);
        item.setImage(image);
        item.setToolTipText(AcceleoUIMessages.getString("AcceleoClasspathContainerWizard.AcceleoEngineDescription"));
        this.parserButton = new Button(composite, 32);
        this.parserButton.setLayoutData((Object)gridData);
        this.parserButton.setText(AcceleoUIMessages.getString("AcceleoClasspathContainerWizard.AcceleoParser"));
        image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        result = new ToolBar(composite, 0x880000);
        result.setLayoutData((Object)new GridData(128));
        item = new ToolItem(result, 0);
        item.setImage(image);
        item.setToolTipText(AcceleoUIMessages.getString("AcceleoClasspathContainerWizard.AcceleoParserDescription"));
        this.setControl((Control)composite);
    }

    public boolean finish() {
        try {
            IJavaProject[] javaProjects = new IJavaProject[]{AcceleoClasspathContainerWizard.getPlaceholderProject()};
            IClasspathContainer[] containers = new IClasspathContainer[1];
            if (this.engineButton.getSelection() && !this.parserButton.getSelection()) {
                this.classpathEntry = JavaCore.newContainerEntry((IPath)AcceleoClasspathContainer.ACCELEO_CLASSPATH_CONTAINER_PATH_ENGINE);
            } else if (!this.engineButton.getSelection() && this.parserButton.getSelection()) {
                this.classpathEntry = JavaCore.newContainerEntry((IPath)AcceleoClasspathContainer.ACCELEO_CLASSPATH_CONTAINER_PATH_PARSER);
            }
            JavaCore.setClasspathContainer((IPath)this.classpathEntry.getPath(), (IJavaProject[])javaProjects, (IClasspathContainer[])containers, null);
        }
        catch (JavaModelException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
            return false;
        }
        return true;
    }

    private static IJavaProject getPlaceholderProject() {
        String name = "####internal";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project;
        while ((project = root.getProject(name)).exists()) {
            name = String.valueOf(name) + '1';
        }
        return JavaCore.create((IProject)project);
    }

    public IClasspathEntry getSelection() {
        return this.classpathEntry;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        if (containerEntry != null) {
            this.classpathEntry = containerEntry;
        }
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.javaProject = project;
    }
}

