/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.PortConfig;

final class ImmutablePortConfig
implements PortConfig {
    @Nullable
    private final String name;
    @Nullable
    private final String protocol;
    @Nullable
    private final Integer targetPort;
    @Nullable
    private final Integer publishedPort;
    @Nullable
    private final PortConfig.PortConfigPublishMode publishMode;

    private ImmutablePortConfig(@Nullable String name, @Nullable String protocol, @Nullable Integer targetPort, @Nullable Integer publishedPort, @Nullable PortConfig.PortConfigPublishMode publishMode) {
        this.name = name;
        this.protocol = protocol;
        this.targetPort = targetPort;
        this.publishedPort = publishedPort;
        this.publishMode = publishMode;
    }

    @Override
    @JsonProperty(value="Name")
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Protocol")
    @Nullable
    public String protocol() {
        return this.protocol;
    }

    @Override
    @JsonProperty(value="TargetPort")
    @Nullable
    public Integer targetPort() {
        return this.targetPort;
    }

    @Override
    @JsonProperty(value="PublishedPort")
    @Nullable
    public Integer publishedPort() {
        return this.publishedPort;
    }

    @Override
    @JsonProperty(value="PublishMode")
    @Nullable
    public PortConfig.PortConfigPublishMode publishMode() {
        return this.publishMode;
    }

    public final ImmutablePortConfig withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutablePortConfig(value, this.protocol, this.targetPort, this.publishedPort, this.publishMode);
    }

    public final ImmutablePortConfig withProtocol(@Nullable String value) {
        if (Objects.equals(this.protocol, value)) {
            return this;
        }
        return new ImmutablePortConfig(this.name, value, this.targetPort, this.publishedPort, this.publishMode);
    }

    public final ImmutablePortConfig withTargetPort(@Nullable Integer value) {
        if (Objects.equals(this.targetPort, value)) {
            return this;
        }
        return new ImmutablePortConfig(this.name, this.protocol, value, this.publishedPort, this.publishMode);
    }

    public final ImmutablePortConfig withPublishedPort(@Nullable Integer value) {
        if (Objects.equals(this.publishedPort, value)) {
            return this;
        }
        return new ImmutablePortConfig(this.name, this.protocol, this.targetPort, value, this.publishMode);
    }

    public final ImmutablePortConfig withPublishMode(@Nullable PortConfig.PortConfigPublishMode value) {
        if (this.publishMode == value) {
            return this;
        }
        return new ImmutablePortConfig(this.name, this.protocol, this.targetPort, this.publishedPort, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePortConfig && this.equalsByValue((ImmutablePortConfig)another);
    }

    private boolean equalsByValue(ImmutablePortConfig another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.protocol, another.protocol) && Objects.equals(this.targetPort, another.targetPort) && Objects.equals(this.publishedPort, another.publishedPort) && Objects.equals((Object)this.publishMode, (Object)another.publishMode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.protocol);
        h += (h << 5) + Objects.hashCode(this.targetPort);
        h += (h << 5) + Objects.hashCode(this.publishedPort);
        h += (h << 5) + Objects.hashCode((Object)this.publishMode);
        return h;
    }

    public String toString() {
        return "PortConfig{name=" + this.name + ", protocol=" + this.protocol + ", targetPort=" + this.targetPort + ", publishedPort=" + this.publishedPort + ", publishMode=" + String.valueOf((Object)this.publishMode) + "}";
    }

    public static ImmutablePortConfig copyOf(PortConfig instance) {
        if (instance instanceof ImmutablePortConfig) {
            return (ImmutablePortConfig)instance;
        }
        return ImmutablePortConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements PortConfig.Builder {
        private String name;
        private String protocol;
        private Integer targetPort;
        private Integer publishedPort;
        private PortConfig.PortConfigPublishMode publishMode;

        private Builder() {
        }

        public final Builder from(PortConfig instance) {
            PortConfig.PortConfigPublishMode publishModeValue;
            Integer publishedPortValue;
            Integer targetPortValue;
            String protocolValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((protocolValue = instance.protocol()) != null) {
                this.protocol(protocolValue);
            }
            if ((targetPortValue = instance.targetPort()) != null) {
                this.targetPort(targetPortValue);
            }
            if ((publishedPortValue = instance.publishedPort()) != null) {
                this.publishedPort(publishedPortValue);
            }
            if ((publishModeValue = instance.publishMode()) != null) {
                this.publishMode(publishModeValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonProperty(value="Protocol")
        public final Builder protocol(@Nullable String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        @JsonProperty(value="TargetPort")
        public final Builder targetPort(@Nullable Integer targetPort) {
            this.targetPort = targetPort;
            return this;
        }

        @Override
        @JsonProperty(value="PublishedPort")
        public final Builder publishedPort(@Nullable Integer publishedPort) {
            this.publishedPort = publishedPort;
            return this;
        }

        @Override
        @JsonProperty(value="PublishMode")
        public final Builder publishMode(@Nullable PortConfig.PortConfigPublishMode publishMode) {
            this.publishMode = publishMode;
            return this;
        }

        @Override
        public ImmutablePortConfig build() {
            return new ImmutablePortConfig(this.name, this.protocol, this.targetPort, this.publishedPort, this.publishMode);
        }
    }
}

