/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.usage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfiguration;
import org.eclipse.qvtd.compiler.internal.usage.AbstractBaseDomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.DirectedDomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.DomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.OperationUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public abstract class RootDomainUsageAnalysis
extends AbstractBaseDomainUsageAnalysis
implements DomainUsageAnalysis.Root {
    protected static final @NonNull Integer NONE_USAGE_BIT_MASK = 0;
    protected static final @NonNull Integer PRIMITIVE_USAGE_BIT_MASK = 1;
    protected static final @NonNull Integer THIS_USAGE_BIT_MASK = 2;
    protected final @NonNull Transformation transformation;
    protected final @NonNull StandardLibrary standardLibrary;
    protected final @NonNull Map<@Nullable String, @NonNull Integer> name2bit = new HashMap<String, Integer>();
    protected final @NonNull List<@NonNull TypedModel> bit2typedModel = new ArrayList<TypedModel>();
    private final @NonNull Map<@NonNull Integer, @NonNull DomainUsageConstant> constantUsages = new HashMap<Integer, DomainUsageConstant>();
    private final @NonNull Map<@NonNull Integer, @NonNull DomainUsageConstant> validUsages = new HashMap<Integer, DomainUsageConstant>();
    private DomainUsageConstant middleUsage = null;
    private final @NonNull Map<@NonNull Type, @NonNull DomainUsageConstant> type2usage = new HashMap<Type, DomainUsageConstant>();
    protected final @NonNull Map<@NonNull Property, DomainUsage> property2containingClassUsage = new HashMap<Property, DomainUsage>();
    protected final @NonNull Map<@NonNull Operation, @NonNull DomainUsageAnalysis.Internal> operation2analysis = new HashMap<Operation, DomainUsageAnalysis.Internal>();
    private final @NonNull TypedModel primitiveTypedModel;
    private final @NonNull TypedModel thisTypedModel;
    private @Nullable TypedModel traceTypedModel = null;
    private OperationId oclAnyEqualsOperationId;
    private OperationId oclAnyNotEqualsOperationId;
    private OperationId oclElementOclContainerId;
    private OperationId oclElementOclContentsId;
    private Property oclElementOclContainerProperty;
    private Property oclElementOclContentsProperty;

    protected RootDomainUsageAnalysis(@NonNull EnvironmentFactory environmentFactory, @NonNull ProblemHandler problemHandler, @NonNull Transformation transformation) {
        super(environmentFactory, problemHandler);
        this.transformation = transformation;
        this.standardLibrary = ((EnvironmentFactory)this.context).getStandardLibrary();
        this.addValidUsage(NONE_USAGE_BIT_MASK, this.getConstantUsage(NONE_USAGE_BIT_MASK));
        TypedModel primitiveTypedModel = QVTbaseUtil.basicGetPrimitiveTypedModel((Transformation)transformation);
        if (primitiveTypedModel == null) {
            primitiveTypedModel = new QVTimperativeHelper(environmentFactory).createPrimitiveTypedModel();
            transformation.getModelParameter().add(0, (Object)primitiveTypedModel);
            QVTruntimeUtil.errPrintln((String)("Missing primitive TypedModel fixed up for " + transformation));
        }
        this.primitiveTypedModel = primitiveTypedModel;
        this.add(primitiveTypedModel);
        this.addValidUsage(PRIMITIVE_USAGE_BIT_MASK, this.getConstantUsage(PRIMITIVE_USAGE_BIT_MASK));
        this.setUsage((Element)primitiveTypedModel, (DomainUsage)this.getPrimitiveUsage());
        TypedModel thisTypedModel = QVTbaseUtil.basicGetThisTypedModel((Transformation)transformation);
        if (thisTypedModel == null) {
            thisTypedModel = new QVTimperativeHelper(environmentFactory).createThisTypedModel();
            transformation.getModelParameter().add(1, (Object)thisTypedModel);
        }
        this.thisTypedModel = thisTypedModel;
        this.add(thisTypedModel);
        this.addValidUsage(THIS_USAGE_BIT_MASK, this.getConstantUsage(THIS_USAGE_BIT_MASK));
        this.setUsage((Element)thisTypedModel, (DomainUsage)this.getThisUsage());
    }

    protected int add(@NonNull TypedModel typedModel) {
        int nextBit = this.bit2typedModel.size();
        this.bit2typedModel.add(typedModel);
        Integer oldBit = this.name2bit.put(typedModel.getName(), nextBit);
        assert (oldBit == null);
        return nextBit;
    }

    protected void addValidUsage(int bitMask, @NonNull DomainUsageConstant typedModelUsage) {
        this.validUsages.put(bitMask, typedModelUsage);
    }

    public @NonNull DomainUsageAnalysis analyzeOperation(@NonNull Operation object) {
        DomainUsageAnalysis.Internal analysis = this.operation2analysis.get(object);
        if (analysis == null) {
            analysis = this.createOperationUsageAnalysis();
            this.operation2analysis.put(object, analysis);
            DomainUsage usage = analysis.visit((Element)object);
            this.setUsage((Element)object, usage);
        }
        return analysis;
    }

    protected void analyzeProperties() {
        for (Type asType : this.type2usage.keySet()) {
            if (!(asType instanceof Class)) continue;
            Class asClass = (Class)asType;
            DomainUsage newUsage = (DomainUsage)this.type2usage.get(asClass);
            assert (newUsage != null);
            for (Property property : PivotUtil.getOwnedProperties((Class)asClass)) {
                this.property2containingClassUsage.put(property, newUsage);
                DomainUsage referredTypeUsage = this.getAnnotatedUsage(property);
                if (referredTypeUsage != null) continue;
                referredTypeUsage = this.visit((Element)property.getType());
            }
        }
    }

    private void analyzeTemplateSignature(@NonNull TemplateableElement asTemplateableElement, @NonNull DomainUsageConstant newUsage) {
        TemplateSignature asSignature = asTemplateableElement.getOwnedSignature();
        if (asSignature != null) {
            for (TemplateParameter asTemplateParameter : PivotUtil.getOwnedParameters((TemplateSignature)asSignature)) {
                this.type2usage.put((Type)asTemplateParameter, newUsage);
            }
        }
    }

    public void analyzeTracePackage(@NonNull TypedModel typedModel, @NonNull Package tracePackage) {
    }

    public @NonNull Map<Element, DomainUsage> analyzeTransformation() {
        for (TypedModel typedModel : QVTbaseUtil.getModelParameters((Transformation)this.transformation)) {
            if (typedModel.isIsPrimitive() || typedModel.isIsThis()) continue;
            int nextBit = this.add(typedModel);
            int bitMask = 1 << nextBit;
            @NonNull DomainUsageConstant typedModelUsage = this.getConstantUsage(bitMask);
            this.addValidUsage(bitMask, typedModelUsage);
            this.setUsage((Element)typedModel, (DomainUsage)typedModelUsage);
            Parameter ownedContext = typedModel.getOwnedContext();
            if (ownedContext != null) {
                this.setUsage((Element)ownedContext, (DomainUsage)typedModelUsage);
            }
            this.analyzeTypedModelTypes(typedModel, typedModelUsage);
            if (!typedModel.isIsTrace()) continue;
            this.setTraceTypedModel(typedModel);
            DomainUsage middleUsage2 = this.setMiddleUsage(bitMask);
            this.setUsage((Element)typedModel, middleUsage2);
        }
        if (this.middleUsage == null) {
            this.setMiddleUsage(0);
        }
        this.analyzeProperties();
        this.type2usage.put((Type)((StandardLibraryInternal)this.standardLibrary).getOclTypeType(), this.getAnyUsage());
        Parameter ownedContext = this.transformation.getOwnedContext();
        if (ownedContext != null) {
            this.setUsage((Element)ownedContext, (DomainUsage)this.getThisUsage());
        }
        this.visit((Element)this.transformation);
        return this.element2usage;
    }

    protected void analyzeTypedModelTypes(@NonNull TypedModel typedModel, @NonNull DomainUsageConstant typedModelUsage) {
        CompleteModel completeModel = ((EnvironmentFactory)this.context).getCompleteModel();
        HashSet<@NonNull CompleteClass> completeClasses = new HashSet<CompleteClass>();
        for (Package asPackage : QVTbaseUtil.getAllUsedPackages((TypedModel)typedModel)) {
            CompletePackage completePackage = completeModel.getCompletePackage(asPackage);
            for (CompleteClass completeClass : ClassUtil.nullFree((List)completePackage.getOwnedCompleteClasses())) {
                for (CompleteClass superCompleteClass : completeClass.getSuperCompleteClasses()) {
                    completeClasses.add(superCompleteClass);
                }
            }
        }
        for (CompleteClass completeClass : completeClasses) {
            for (Class asClass : ClassUtil.nullFree((List)completeClass.getPartialClasses())) {
                DomainUsageConstant oldUsage = this.type2usage.get(asClass);
                DomainUsageConstant classUsage = typedModelUsage;
                if (asClass instanceof DataType && !(asClass instanceof CollectionType)) {
                    classUsage = this.getPrimitiveUsage();
                }
                DomainUsageConstant newUsage = oldUsage != null ? classUsage.union(oldUsage) : classUsage;
                this.type2usage.put((Type)asClass, newUsage);
                this.analyzeTemplateSignature((TemplateableElement)asClass, newUsage);
                for (Operation asOperation : PivotUtil.getOwnedOperations((Class)asClass)) {
                    this.analyzeTemplateSignature((TemplateableElement)asOperation, newUsage);
                }
            }
        }
    }

    protected @Nullable TypedModel basicGetTraceTypedModel() {
        return this.traceTypedModel;
    }

    protected @Nullable DomainUsage basicGetTypeUsage(@NonNull Type type) {
        return (DomainUsage)this.type2usage.get(type);
    }

    @Override
    public @Nullable DomainUsage basicGetUsage(@Nullable Element element) {
        DomainUsage usage = super.basicGetUsage(element);
        if (usage != null) {
            return usage;
        }
        Operation operation = PivotUtil.getContainingOperation((EObject)element);
        if (operation == null) {
            return null;
        }
        DomainUsageAnalysis analyzeOperation = this.analyzeOperation(operation);
        usage = analyzeOperation.basicGetUsage(element);
        return usage;
    }

    public abstract @NonNull DirectedDomainUsageAnalysis createDirectedDomainUsageAnalysis(@NonNull TypedModelsConfiguration var1);

    protected @NonNull OperationUsageAnalysis createOperationUsageAnalysis() {
        return new OperationUsageAnalysis(this);
    }

    public @NonNull DomainUsage createVariableUsage(int intersectionMask) {
        return new DomainUsageVariable(this, intersectionMask);
    }

    public @NonNull DomainUsageAnalysis getAnalysis(@NonNull Operation operation) {
        DomainUsageAnalysis analysis = this.operation2analysis.get(operation);
        if (analysis == null) {
            analysis = this.analyzeOperation(operation);
        }
        return analysis;
    }

    protected @Nullable DomainUsage getAnnotatedUsage(@NonNull Property property) {
        DomainUsageConstant referredTypeUsage = null;
        for (Element annotation : property.getOwnedAnnotations()) {
            Annotation annotation2;
            if (!(annotation instanceof Annotation) || !"http://www.eclipse.org/qvt#Domains".equals((annotation2 = (Annotation)annotation).getName())) continue;
            for (Detail detail : annotation2.getOwnedDetails()) {
                if (!"referredDomain".equals(detail.getName())) continue;
                int mask = 0;
                for (String value : detail.getValues()) {
                    Integer bit = this.name2bit.get(value.trim());
                    if (bit == null) continue;
                    mask |= 1 << bit;
                }
                referredTypeUsage = this.getValidUsage(mask);
            }
        }
        return referredTypeUsage;
    }

    protected int getAnyMask() {
        return (1 << this.bit2typedModel.size()) - 1;
    }

    public @NonNull DomainUsageConstant getAnyUsage() {
        return this.getConstantUsage(this.getAnyMask());
    }

    public @NonNull DomainUsageConstant getConstantUsage(int bitMask) {
        DomainUsageConstant usage = this.constantUsages.get(bitMask);
        if (usage == null) {
            usage = new DomainUsageConstant(this, bitMask);
            this.constantUsages.put(bitMask, usage);
        }
        return usage;
    }

    public @NonNull DomainUsage getMiddleUsage() {
        return (DomainUsage)ClassUtil.nonNullState((Object)this.middleUsage);
    }

    public @NonNull DomainUsage getNoneUsage() {
        DomainUsageConstant noneUsage = this.constantUsages.get(NONE_USAGE_BIT_MASK);
        assert (noneUsage != null);
        return noneUsage;
    }

    public @NonNull OperationId getOclContainerId() {
        OperationId oclElementOclContainerId2 = this.oclElementOclContainerId;
        if (oclElementOclContainerId2 == null) {
            Class oclElementType = this.standardLibrary.getOclElementType();
            Operation operation = (Operation)NameUtil.getNameable((Iterable)oclElementType.getOwnedOperations(), (String)"oclContainer");
            assert (operation != null);
            this.oclElementOclContainerId = oclElementOclContainerId2 = operation.getOperationId();
        }
        return oclElementOclContainerId2;
    }

    public @NonNull Property getOclContainerProperty() {
        Property oclElementOclContainerProperty2 = this.oclElementOclContainerProperty;
        if (oclElementOclContainerProperty2 == null) {
            Class oclElementType = this.standardLibrary.getOclElementType();
            oclElementOclContainerProperty2 = (Property)NameUtil.getNameable((Iterable)oclElementType.getOwnedProperties(), (String)"oclContainer");
            assert (oclElementOclContainerProperty2 != null);
            this.oclElementOclContainerProperty = oclElementOclContainerProperty2;
        }
        return oclElementOclContainerProperty2;
    }

    public @NonNull OperationId getOclContentsId() {
        OperationId oclElementOclContentsId2 = this.oclElementOclContentsId;
        if (oclElementOclContentsId2 == null) {
            Class oclElementType = this.standardLibrary.getOclElementType();
            Operation operation = (Operation)NameUtil.getNameable((Iterable)oclElementType.getOwnedOperations(), (String)"oclContents");
            assert (operation != null);
            this.oclElementOclContentsId = oclElementOclContentsId2 = operation.getOperationId();
        }
        return oclElementOclContentsId2;
    }

    public @NonNull Property getOclContentsProperty() {
        Property oclElementOclContentsProperty2 = this.oclElementOclContentsProperty;
        if (oclElementOclContentsProperty2 == null) {
            Class oclElementType = this.standardLibrary.getOclElementType();
            oclElementOclContentsProperty2 = (Property)NameUtil.getNameable((Iterable)oclElementType.getOwnedProperties(), (String)"oclContents");
            assert (oclElementOclContentsProperty2 != null);
            this.oclElementOclContentsProperty = oclElementOclContentsProperty2;
        }
        return oclElementOclContentsProperty2;
    }

    public @NonNull OperationId getOclAnyEqualsOperationId() {
        OperationId oclAnyEqualsOperationId2 = this.oclAnyEqualsOperationId;
        if (oclAnyEqualsOperationId2 == null) {
            Class oclAnyType = this.standardLibrary.getOclAnyType();
            Operation operation = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"=");
            assert (operation != null);
            this.oclAnyEqualsOperationId = oclAnyEqualsOperationId2 = operation.getOperationId();
        }
        return oclAnyEqualsOperationId2;
    }

    public @NonNull OperationId getOclAnyNotEqualsOperationId() {
        OperationId oclAnyNotEqualsOperationId2 = this.oclAnyNotEqualsOperationId;
        if (oclAnyNotEqualsOperationId2 == null) {
            Class oclAnyType = this.standardLibrary.getOclAnyType();
            Operation operation = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"<>");
            assert (operation != null);
            this.oclAnyNotEqualsOperationId = oclAnyNotEqualsOperationId2 = operation.getOperationId();
        }
        return oclAnyNotEqualsOperationId2;
    }

    public @NonNull TypedModel getPrimitiveTypedModel() {
        return this.primitiveTypedModel;
    }

    public @NonNull DomainUsageConstant getPrimitiveUsage() {
        DomainUsageConstant primitiveUsage = this.constantUsages.get(PRIMITIVE_USAGE_BIT_MASK);
        assert (primitiveUsage != null);
        return primitiveUsage;
    }

    @Override
    protected @NonNull RootDomainUsageAnalysis getRootAnalysis() {
        return this;
    }

    public @NonNull TypedModel getThisTypedModel() {
        return this.thisTypedModel;
    }

    public @NonNull DomainUsageConstant getThisUsage() {
        DomainUsageConstant thisUsage = this.constantUsages.get(THIS_USAGE_BIT_MASK);
        assert (thisUsage != null);
        return thisUsage;
    }

    public @NonNull TypedModel getTraceTypedModel() {
        return (TypedModel)ClassUtil.nonNullState((Object)this.traceTypedModel);
    }

    public @NonNull Transformation getTransformation() {
        return this.transformation;
    }

    public @NonNull TypedModel getTypedModel(int i) {
        return this.bit2typedModel.get(i);
    }

    @Override
    public @NonNull DomainUsage getUsage(@NonNull Element element) {
        Operation operation = PivotUtil.getContainingOperation((EObject)element);
        if (operation != null) {
            DomainUsageAnalysis analyzeOperation = this.analyzeOperation(operation);
            return (DomainUsage)ClassUtil.nonNullState((Object)analyzeOperation.getUsage(element));
        }
        return super.getUsage(element);
    }

    public @Nullable DomainUsageConstant getValidUsage(int bitMask) {
        return this.validUsages.get(bitMask);
    }

    public @NonNull DomainUsage getValidOrVariableUsage(@NonNull DomainUsage usage) {
        int bitMask = usage.getMask();
        DomainUsageConstant validUsage = this.getValidUsage(bitMask);
        if (validUsage != null) {
            return validUsage;
        }
        if (!usage.isConstant()) {
            return usage;
        }
        return this.createVariableUsage(bitMask);
    }

    protected @NonNull DomainUsage setMiddleUsage(int middleMask) {
        this.middleUsage = this.getConstantUsage(this.getAnyMask() & middleMask);
        return this.middleUsage;
    }

    protected void setTraceTypedModel(@NonNull TypedModel typedModel) {
        this.traceTypedModel = typedModel;
    }

    protected static abstract class AbstractDomainUsage
    implements DomainUsage.Internal {
        protected final @NonNull RootDomainUsageAnalysis rootDomainUsageAnalysis;
        protected final int bitMask;

        protected AbstractDomainUsage(@NonNull RootDomainUsageAnalysis rootDomainUsageAnalysis, int bitMask) {
            this.rootDomainUsageAnalysis = rootDomainUsageAnalysis;
            this.bitMask = bitMask;
        }

        public int compareTo(@NonNull DomainUsage o) {
            return this.getMask() - o.getMask();
        }

        public int getMask() {
            return this.bitMask;
        }

        public @Nullable TypedModel getTypedModel(@Nullable Element context) throws IllegalStateException {
            int residue = this.bitMask;
            int i = 0;
            while (residue != 0) {
                int bit = 1 << i;
                if ((residue & bit) != 0) {
                    if ((residue &= ~bit) == 0) {
                        return this.rootDomainUsageAnalysis.getTypedModel(i);
                    }
                    if (!(context instanceof NullLiteralExp)) {
                        QVTruntimeUtil.errPrintln((String)("Ambiguous TypedModel: " + this + " for " + LabelUtil.getLabel((Object)context)));
                    }
                    return this.rootDomainUsageAnalysis.getTypedModel(i);
                }
                ++i;
            }
            return null;
        }

        public @NonNull Iterable<@NonNull TypedModel> getTypedModels() {
            ArrayList<@NonNull TypedModel> typedModels = new ArrayList<TypedModel>();
            int residue = this.bitMask;
            int i = 0;
            while (residue != 0) {
                int bit = 1 << i;
                if ((residue & bit) != 0) {
                    residue &= ~bit;
                    typedModels.add(this.rootDomainUsageAnalysis.getTypedModel(i));
                }
                ++i;
            }
            return typedModels;
        }

        public boolean isMiddle() {
            return (this.bitMask & ((RootDomainUsageAnalysis)this.rootDomainUsageAnalysis).middleUsage.bitMask) != 0;
        }

        public boolean isNone() {
            return this.bitMask == 0;
        }

        public boolean isPrimitive() {
            return (this.bitMask & PRIMITIVE_USAGE_BIT_MASK) != 0;
        }

        public boolean isThis() {
            return (this.bitMask & THIS_USAGE_BIT_MASK) != 0;
        }

        protected String toString(@NonNull String prefix) {
            StringBuilder s = new StringBuilder();
            s.append(prefix);
            boolean first = true;
            int i = 0;
            while (i < this.rootDomainUsageAnalysis.bit2typedModel.size()) {
                int iMask = 1 << i;
                if ((this.bitMask & iMask) != 0) {
                    String name;
                    if (!first) {
                        s.append("|");
                    }
                    s.append((name = this.rootDomainUsageAnalysis.bit2typedModel.get(i).getName()) != null ? name : "middle");
                    first = false;
                }
                ++i;
            }
            if (first) {
                s.append("$none$");
            }
            return s.toString();
        }
    }

    protected static class DomainUsageConstant
    extends AbstractDomainUsage {
        protected DomainUsageConstant(@NonNull RootDomainUsageAnalysis rootDomainUsageAnalysis, int bitMask) {
            super(rootDomainUsageAnalysis, bitMask);
        }

        public void addUsedBy(@NonNull Element element) {
        }

        public @NonNull DomainUsage cloneVariable() {
            return this;
        }

        public @Nullable Iterable<Element> getElements() {
            return null;
        }

        public boolean isConstant() {
            return true;
        }

        public String toString() {
            return this.toString("\u00abconstant\u00bb");
        }

        public @NonNull DomainUsageConstant union(@NonNull DomainUsageConstant usage) {
            return this.rootDomainUsageAnalysis.getConstantUsage(this.bitMask | usage.bitMask);
        }
    }

    protected static class DomainUsageVariable
    extends AbstractDomainUsage {
        protected final @NonNull List<Element> usedBy = new ArrayList<Element>();

        protected DomainUsageVariable(@NonNull RootDomainUsageAnalysis rootDomainUsageAnalysis, int bitMask) {
            super(rootDomainUsageAnalysis, bitMask);
            assert (bitMask != 0);
        }

        public void addUsedBy(@NonNull Element element) {
            this.usedBy.add(element);
        }

        public @NonNull DomainUsage cloneVariable() {
            return new DomainUsageVariable(this.rootDomainUsageAnalysis, this.bitMask);
        }

        public @Nullable Iterable<Element> getElements() {
            return this.usedBy;
        }

        public boolean isConstant() {
            return false;
        }

        public String toString() {
            return this.toString("\u00abvariable\u00bb");
        }
    }
}

