/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.wizard.project;

import java.util.Observable;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.composer.api.ComposerConstants;
import org.eclipse.php.composer.ui.editor.composer.LicenseContentAdapter;
import org.eclipse.php.composer.ui.wizard.project.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BasicSettingsGroup
extends Observable
implements IDialogFieldListener {
    protected StringDialogField vendorField;
    protected StringDialogField typeField;
    protected StringDialogField descriptionField;
    protected StringDialogField keywordField;
    protected StringDialogField licenseField;
    protected Shell shell;
    protected Composite nameComposite;

    public BasicSettingsGroup(Composite composite, Shell shell) {
        this.createControl(composite, shell);
    }

    public void createControl(Composite composite, Shell shell) {
        this.shell = shell;
        this.nameComposite = new Composite(composite, 0);
        this.nameComposite.setFont(composite.getFont());
        this.nameComposite.setLayout((Layout)new GridLayout(2, false));
        this.nameComposite.setLayoutData((Object)new GridData(768));
        this.vendorField = new StringDialogField();
        this.vendorField.setLabelText(Messages.BasicSettingsGroup_VendorNameLabel);
        this.vendorField.setDialogFieldListener((IDialogFieldListener)this);
        this.vendorField.doFillIntoGrid(this.nameComposite, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.vendorField.getTextControl(null));
        this.typeField = new StringDialogField();
        this.typeField.setLabelText(Messages.BasicSettingsGroup_TypeLabel);
        this.typeField.setDialogFieldListener((IDialogFieldListener)this);
        this.typeField.doFillIntoGrid(this.nameComposite, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.typeField.getTextControl(null));
        ControlDecoration decoration = new ControlDecoration((Control)this.typeField.getTextControl(), 16512);
        FieldDecoration indicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        decoration.setImage(indicator.getImage());
        decoration.setDescriptionText(NLS.bind((String)Messages.BasicSettingsGroup_ContentAssistDecorationText, (Object)indicator.getDescription()));
        decoration.setShowOnlyOnFocus(true);
        new AutoCompleteField((Control)this.typeField.getTextControl(), (IControlContentAdapter)new TextContentAdapter(), ComposerConstants.TYPES);
        this.descriptionField = new StringDialogField();
        this.descriptionField.setLabelText(Messages.BasicSettingsGroup_DescriptionLabel);
        this.descriptionField.setDialogFieldListener((IDialogFieldListener)this);
        this.descriptionField.doFillIntoGrid(this.nameComposite, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.descriptionField.getTextControl(null));
        this.keywordField = new StringDialogField();
        this.keywordField.setLabelText(Messages.BasicSettingsGroup_KeywordsLabel);
        this.keywordField.setDialogFieldListener((IDialogFieldListener)this);
        this.keywordField.doFillIntoGrid(this.nameComposite, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.keywordField.getTextControl(null));
        this.licenseField = new StringDialogField();
        this.licenseField.setLabelText(Messages.BasicSettingsGroup_LicenseLabel);
        this.licenseField.setDialogFieldListener((IDialogFieldListener)this);
        this.licenseField.doFillIntoGrid(this.nameComposite, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.licenseField.getTextControl(null));
        ControlDecoration licenseDecoration = new ControlDecoration((Control)this.licenseField.getTextControl(), 16512);
        licenseDecoration.setImage(indicator.getImage());
        licenseDecoration.setDescriptionText(NLS.bind((String)Messages.BasicSettingsGroup_ContentAssistDecorationText, (Object)indicator.getDescription()));
        licenseDecoration.setShowOnlyOnFocus(true);
        new AutoCompleteField((Control)this.licenseField.getTextControl(), (IControlContentAdapter)new LicenseContentAdapter(), ComposerConstants.LICENSES);
    }

    protected void fireEvent() {
        this.setChanged();
        this.notifyObservers();
    }

    public String getVendor() {
        return this.vendorField.getText().trim();
    }

    public String getDescription() {
        return this.descriptionField.getText().trim();
    }

    public String getLicense() {
        return this.licenseField.getText().trim();
    }

    public String getType() {
        return this.typeField.getText().trim();
    }

    public String getKeywords() {
        return this.keywordField.getText().trim();
    }

    public void postSetFocus() {
        this.vendorField.postSetFocusOnDialogField(this.shell.getDisplay());
    }

    public void setVendor(String name) {
        this.vendorField.setText(name);
    }

    public void dialogFieldChanged(DialogField field) {
        this.fireEvent();
    }

    public void hide() {
        this.nameComposite.setVisible(false);
    }

    public void show() {
        this.nameComposite.setVisible(true);
    }

    public void setEnabled(boolean enabled) {
        this.vendorField.setEnabled(enabled);
        this.nameComposite.setEnabled(enabled);
        this.typeField.setEnabled(enabled);
        this.descriptionField.setEnabled(enabled);
        this.keywordField.setEnabled(enabled);
        this.licenseField.setEnabled(enabled);
    }
}

