/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.IterationManager;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractIterationManager;
import org.eclipse.ocl.pivot.library.LibraryBinaryOperation;
import org.eclipse.ocl.pivot.library.LibraryTernaryOperation;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IterableValue;
import org.eclipse.ocl.pivot.values.MapValue;

public class ExecutorSingleMapIterationManager
extends AbstractIterationManager {
    protected final @NonNull MapValue mapValue;
    protected final @NonNull TypeId returnTypeId;
    protected final @NonNull LibraryBinaryOperation body;
    private @Nullable Object accumulatorValue;
    protected final @NonNull Iterator<? extends Object> iteratorValue;
    private Object currentKeyValue;
    private Object currentValueValue;

    public ExecutorSingleMapIterationManager(@NonNull Executor executor, @NonNull TypeId returnTypeId, @NonNull LibraryBinaryOperation body, @Nullable MapValue mapValue, @Nullable Object accumulatorValue) {
        super(executor);
        this.mapValue = ValueUtil.asMapValue(mapValue);
        this.returnTypeId = returnTypeId;
        this.body = body;
        this.updateAccumulator(accumulatorValue);
        this.iteratorValue = this.mapValue.iterator();
        this.advanceIterators();
    }

    protected ExecutorSingleMapIterationManager(@NonNull ExecutorSingleMapIterationManager iterationManager, @NonNull MapValue mapValue) {
        super(iterationManager.getExecutor());
        this.mapValue = mapValue;
        this.returnTypeId = iterationManager.returnTypeId;
        this.body = iterationManager.body;
        this.accumulatorValue = iterationManager.accumulatorValue;
        this.iteratorValue = mapValue.iterator();
        this.advanceIterators();
    }

    @Override
    public boolean advanceIterators() {
        this.currentKeyValue = this.iteratorValue.hasNext() ? this.iteratorValue.next() : this.iteratorValue;
        this.currentValueValue = this.mapValue.at(this.currentKeyValue);
        return this.currentKeyValue != this.iteratorValue;
    }

    @Override
    public @NonNull IterationManager createNestedIterationManager(@NonNull IterableValue value) {
        return new Nested(this, (MapValue)value);
    }

    @Override
    public @Nullable Object evaluateBody() {
        return ((LibraryTernaryOperation.LibraryTernaryOperationExtension)((Object)this.body)).evaluate(this.executor, this.returnTypeId, this.accumulatorValue, this.get(), this.getValue());
    }

    @Override
    public @Nullable Object get() {
        return this.currentKeyValue;
    }

    @Override
    public @Nullable Object getAccumulatorValue() {
        return this.accumulatorValue;
    }

    public int getDepth() {
        return 0;
    }

    public @NonNull ExecutorSingleMapIterationManager getRootIterationManager() {
        return this;
    }

    @Override
    public @NonNull IterableValue getSourceIterable() {
        return this.mapValue;
    }

    public @Nullable Object getValue() {
        return this.currentValueValue;
    }

    @Override
    public boolean hasCurrent() {
        return this.currentKeyValue != this.iteratorValue;
    }

    @Override
    public @Nullable Object updateAccumulator(Object newValue) {
        this.accumulatorValue = newValue;
        return null;
    }

    class Nested
    extends ExecutorSingleMapIterationManager {
        protected final @NonNull ExecutorSingleMapIterationManager rootIterationManager;
        protected final int depth;

        protected Nested(@NonNull ExecutorSingleMapIterationManager iterationManager, MapValue mapValue) {
            super(iterationManager, mapValue);
            this.rootIterationManager = iterationManager.getRootIterationManager();
            this.depth = iterationManager.getDepth() + 1;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public @NonNull ExecutorSingleMapIterationManager getRootIterationManager() {
            return this.rootIterationManager;
        }

        @Override
        public @NonNull CollectionValue getSourceCollection() {
            return this.rootIterationManager.getSourceCollection();
        }
    }
}

