/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.profiler;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.profiler.StopWatch;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.VMMonitor;

public class Profiler
implements VMMonitor {
    private static final double DIVISOR = 1.0E9;
    private static final double HUNDRED = 100.0;
    private final StopWatch stopWatch = new StopWatch();
    private final Map<CodeBlock, Pair<Long, StopWatch>> codeBlockTimings = new HashMap<CodeBlock, Pair<Long, StopWatch>>();
    private final Map<Method, Pair<Long, StopWatch>> nativeMethodTimings = new HashMap<Method, Pair<Long, StopWatch>>();
    private final Stack<Pair<Long, StopWatch>> timingStack = new Stack();
    private final List<ProfilingData> results = new ArrayList<ProfilingData>();

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public void enter(StackFrame frame) {
        Pair<Long, StopWatch> timings;
        if (this.timingStack.isEmpty()) {
            this.stopWatch.start();
        }
        if ((timings = this.getTimings(frame)) != null) {
            Pair<Long, StopWatch> currentTimings;
            if (!this.timingStack.isEmpty() && (currentTimings = this.timingStack.peek()) != timings) {
                currentTimings.getValue().stop();
            }
            timings.setKey(timings.getKey() + 1L);
            timings.getValue().start();
            this.timingStack.push(timings);
        }
    }

    @Override
    public void leave(StackFrame frame) {
        if (!this.timingStack.isEmpty()) {
            Pair<Long, StopWatch> timings = this.timingStack.pop();
            assert (timings == this.getTimings(frame));
            if (!this.timingStack.isEmpty()) {
                Pair<Long, StopWatch> parentTimings = this.timingStack.peek();
                if (parentTimings != timings) {
                    timings.getValue().stop();
                    parentTimings.getValue().start();
                }
            } else {
                timings.getValue().stop();
            }
        }
    }

    @Override
    public void step(StackFrame frame) {
    }

    @Override
    public void terminated() {
        while (!this.timingStack.isEmpty()) {
            this.timingStack.pop().getValue().stop();
        }
        this.stopWatch.stop();
        long globalDuration = this.stopWatch.getDuration();
        this.stopWatch.reset();
        ArrayList<Object> sorted = new ArrayList<Object>(this.codeBlockTimings.size() + this.nativeMethodTimings.size());
        sorted.addAll(this.codeBlockTimings.keySet());
        sorted.addAll(this.nativeMethodTimings.keySet());
        Collections.sort(sorted, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return -Long.valueOf(((StopWatch)Profiler.this.getTimings(o1).getValue()).getDuration()).compareTo(((StopWatch)Profiler.this.getTimings(o2).getValue()).getDuration());
            }
        });
        for (Object e : sorted) {
            Pair<Long, StopWatch> timings = this.getTimings(e);
            long duration = timings.getValue().getDuration();
            double ratio = (double)duration / (double)globalDuration;
            ProfilingData profilingData = e instanceof CodeBlock ? new ProfilingData((CodeBlock)e, null, duration, ratio, timings.getKey()) : new ProfilingData(null, (Method)e, duration, ratio, timings.getKey());
            this.results.add(profilingData);
        }
    }

    @Override
    public void error(StackFrame frame, String msg, Exception e) {
    }

    public List<ProfilingData> getResults() {
        return this.results;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Profiling results:\n\tDuration (sec.)\tDuration (%)\tInvocations\tOperation\n");
        for (ProfilingData profilingData : this.getResults()) {
            sb.append(String.format("\t%15.6f\t%12.2f\t%11d\t%s\n", (double)profilingData.getDuration() / 1.0E9, profilingData.getDurationRatio() * 100.0, profilingData.getInvocations(), profilingData.getOperation()));
        }
        return sb.toString();
    }

    private Pair<Long, StopWatch> getTimings(StackFrame frame) {
        CodeBlock cb = frame.getCodeBlock();
        if (cb != null) {
            Pair<Long, StopWatch> timings = this.codeBlockTimings.get(cb);
            if (timings == null) {
                timings = new Pair<Long, StopWatch>(0L, new StopWatch());
                this.codeBlockTimings.put(cb, timings);
            }
            return timings;
        }
        Method m = frame.getNativeMethod();
        if (m != null) {
            Pair<Long, StopWatch> timings = this.nativeMethodTimings.get(m);
            if (timings == null) {
                timings = new Pair<Long, StopWatch>(0L, new StopWatch());
                this.nativeMethodTimings.put(m, timings);
            }
            return timings;
        }
        return null;
    }

    private Pair<Long, StopWatch> getTimings(Object operation) {
        Pair<Long, StopWatch> timings = this.codeBlockTimings.get(operation);
        if (timings == null) {
            timings = this.nativeMethodTimings.get(operation);
        }
        return timings;
    }

    static class Pair<K, V> {
        private K key;
        private V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public String toString() {
            return "Pair [key=" + this.key + ", value=" + this.value + "]";
        }
    }

    public static class ProfilingData {
        private final CodeBlock codeBlock;
        private final Method method;
        private final long duration;
        private final double durationRatio;
        private final long invocations;

        public ProfilingData(CodeBlock codeBlock, Method method, long duration, double durationRatio, long invocations) {
            this.codeBlock = codeBlock;
            this.method = method;
            this.duration = duration;
            this.durationRatio = durationRatio;
            this.invocations = invocations;
        }

        public CodeBlock getCodeBlock() {
            return this.codeBlock;
        }

        public Method getMethod() {
            return this.method;
        }

        public long getDuration() {
            return this.duration;
        }

        public double getDurationRatio() {
            return this.durationRatio;
        }

        public long getInvocations() {
            return this.invocations;
        }

        public Object getOperation() {
            Object operation = this.getCodeBlock();
            if (operation == null) {
                operation = this.getMethod();
            }
            return operation;
        }
    }
}

