/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wsrt;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ClientRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.RuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ServiceRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceClientImpl;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceImpl;

public class WebServiceRuntimeExtensionRegistry2 {
    private static WebServiceRuntimeExtensionRegistry2 instance_;
    Hashtable webServiceImpls_;
    Hashtable webServiceClientImpls_;
    Hashtable runtimes_;
    Hashtable serviceRuntimes_;
    Hashtable clientRuntimes_;
    ArrayList webServiceTypesList_;
    ArrayList webServiceClientTypesList_;

    public static WebServiceRuntimeExtensionRegistry2 getInstance() {
        if (instance_ == null) {
            instance_ = new WebServiceRuntimeExtensionRegistry2();
            instance_.load();
        }
        return instance_;
    }

    private void load() {
        IConfigurationElement[] serviceRuntimeProperties;
        IConfigurationElement[] clientRuntimeProperties;
        IConfigurationElement elem;
        this.webServiceImpls_ = new Hashtable();
        this.webServiceClientImpls_ = new Hashtable();
        this.runtimes_ = new Hashtable();
        this.serviceRuntimes_ = new Hashtable();
        this.clientRuntimes_ = new Hashtable();
        this.webServiceTypesList_ = new ArrayList();
        this.webServiceClientTypesList_ = new ArrayList();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] wsImplExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "wsImpl");
        int idx = 0;
        while (idx < wsImplExts.length) {
            IConfigurationElement elem2 = wsImplExts[idx];
            if (elem2.getName().equals("webServiceImpl")) {
                WebServiceImpl wsimpl = new WebServiceImpl(elem2);
                this.webServiceImpls_.put(elem2.getAttribute("id"), wsimpl);
            }
            ++idx;
        }
        IConfigurationElement[] wsClientImplExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "wsClientImpl");
        int idx2 = 0;
        while (idx2 < wsClientImplExts.length) {
            IConfigurationElement elem3 = wsClientImplExts[idx2];
            if (elem3.getName().equals("webServiceClientImpl")) {
                WebServiceClientImpl wsClientImpl = new WebServiceClientImpl(elem3);
                this.webServiceClientImpls_.put(elem3.getAttribute("id"), wsClientImpl);
            }
            ++idx2;
        }
        IConfigurationElement[] runtimeExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "runtimes");
        int idx3 = 0;
        while (idx3 < runtimeExts.length) {
            IConfigurationElement elem4 = runtimeExts[idx3];
            if (elem4.getName().equals("runtime")) {
                RuntimeDescriptor rd = new RuntimeDescriptor(elem4);
                this.runtimes_.put(elem4.getAttribute("id"), rd);
            }
            ++idx3;
        }
        IConfigurationElement[] serviceRuntimeExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "serviceRuntimes");
        int idx4 = 0;
        while (idx4 < serviceRuntimeExts.length) {
            IConfigurationElement elem5 = serviceRuntimeExts[idx4];
            if (elem5.getName().equals("serviceRuntime")) {
                ServiceRuntimeDescriptor rd = new ServiceRuntimeDescriptor(elem5, this.webServiceImpls_, this.runtimes_);
                this.serviceRuntimes_.put(elem5.getAttribute("id"), rd);
                this.updateWebServiceTypeList(rd);
            }
            ++idx4;
        }
        IConfigurationElement[] clientRuntimeExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "clientRuntimes");
        int idx5 = 0;
        while (idx5 < clientRuntimeExts.length) {
            elem = clientRuntimeExts[idx5];
            if (elem.getName().equals("clientRuntime")) {
                ClientRuntimeDescriptor rd = new ClientRuntimeDescriptor(elem, this.webServiceClientImpls_, this.runtimes_);
                this.clientRuntimes_.put(elem.getAttribute("id"), rd);
                this.updateWebServiceClientTypeList(rd);
            }
            ++idx5;
        }
        IConfigurationElement[] iConfigurationElementArray = clientRuntimeProperties = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "clientRuntimeProperties");
        int n = clientRuntimeProperties.length;
        int rd = 0;
        while (rd < n) {
            ClientRuntimeDescriptor rd2;
            elem = iConfigurationElementArray[rd];
            String clientRuntimeId = elem.getAttribute("clientRuntimeId");
            if (clientRuntimeId != null && (rd2 = (ClientRuntimeDescriptor)this.clientRuntimes_.get(clientRuntimeId)) != null) {
                rd2.processClientRuntimeProperties(elem);
            }
            ++rd;
        }
        IConfigurationElement[] iConfigurationElementArray2 = serviceRuntimeProperties = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "serviceRuntimeProperties");
        int n2 = serviceRuntimeProperties.length;
        n = 0;
        while (n < n2) {
            ServiceRuntimeDescriptor rd3;
            IConfigurationElement elem6 = iConfigurationElementArray2[n];
            String serviceRuntimeId = elem6.getAttribute("serviceRuntimeId");
            if (serviceRuntimeId != null && (rd3 = (ServiceRuntimeDescriptor)this.serviceRuntimes_.get(serviceRuntimeId)) != null) {
                rd3.processServiceRuntimeProperties(elem6);
            }
            ++n;
        }
    }

    private void updateWebServiceTypeList(ServiceRuntimeDescriptor descriptor) {
        String entry;
        StringBuffer entrybuff;
        String serviceImplId = descriptor.getServiceImplementationType().getId();
        boolean bottomUp = descriptor.getBottomUp();
        boolean topDown = descriptor.getTopDown();
        if (bottomUp) {
            entrybuff = new StringBuffer();
            entrybuff.append(String.valueOf(0));
            entrybuff.append("/");
            entrybuff.append(serviceImplId);
            entry = entrybuff.toString();
            if (!this.webServiceTypesList_.contains(entry)) {
                this.webServiceTypesList_.add(entry);
            }
        }
        if (topDown) {
            entrybuff = new StringBuffer();
            entrybuff.append(String.valueOf(1));
            entrybuff.append("/");
            entrybuff.append(serviceImplId);
            entry = entrybuff.toString();
            if (!this.webServiceTypesList_.contains(entry)) {
                this.webServiceTypesList_.add(entry);
            }
        }
    }

    private void updateWebServiceClientTypeList(ClientRuntimeDescriptor descriptor) {
        String clientImplId = descriptor.getClientImplementationType().getId();
        StringBuffer entrybuff = new StringBuffer();
        entrybuff.append(String.valueOf(2));
        entrybuff.append("/");
        entrybuff.append(clientImplId);
        String entry = entrybuff.toString();
        if (!this.webServiceClientTypesList_.contains(entry)) {
            this.webServiceClientTypesList_.add(entry);
        }
    }
}

