/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.ui.internal.hover;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.facelet.core.internal.cm.FaceletDocumentFactory;
import org.eclipse.jst.jsf.ui.internal.jspeditor.JSFELHover;
import org.eclipse.wst.html.ui.internal.taginfo.HTMLTagInfoHoverProcessor;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FaceletHover
implements ITextHover {
    private IProject _project;
    private JSFELHover _elHover = new JSFELHover();
    private HTMLTagInfoHoverProcessor _htmlHoverProcessor = new MyHTMLTagInfoHoverProcessor();

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(textViewer, hoverRegion.getOffset());
        String info = null;
        if (this.isInAttributeValue(context)) {
            info = this._elHover.getHoverInfo(textViewer, hoverRegion);
        }
        if (info == null) {
            if (context != null) {
                this._project = this.getProject(context);
            }
            info = this._htmlHoverProcessor.getHoverInfo(textViewer, hoverRegion);
        }
        return info;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IRegion region = null;
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(textViewer, offset);
        if (context != null && this.isInAttributeValue(context)) {
            region = this._elHover.getHoverRegion(textViewer, offset);
        }
        if (region == null) {
            if (context != null) {
                this._project = this.getProject(context);
            }
            region = this._htmlHoverProcessor.getHoverRegion(textViewer, offset);
        }
        return region;
    }

    private boolean isInAttributeValue(IStructuredDocumentContext context) {
        ITextRegionContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(context);
        String regionType = resolver.getRegionType();
        return regionType != null && (regionType == "XML_TAG_ATTRIBUTE_VALUE" || resolver.matchesRelative(new String[]{"XML_TAG_ATTRIBUTE_VALUE"}));
    }

    private IProject getProject(IStructuredDocumentContext context) {
        IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        if (resolver != null) {
            return resolver.getProject();
        }
        return null;
    }

    private class MyHTMLTagInfoHoverProcessor
    extends HTMLTagInfoHoverProcessor {
        private MyHTMLTagInfoHoverProcessor() {
        }

        protected CMElementDeclaration getCMElementDeclaration(Node node) {
            Element element;
            FaceletDocumentFactory factory;
            CMElementDeclaration elementDecl;
            if (FaceletHover.this._project != null && node.getNodeType() == 1 && node.getPrefix() != null && (elementDecl = (factory = new FaceletDocumentFactory(FaceletHover.this._project)).createCMElementDeclaration(element = (Element)node)) != null) {
                return elementDecl;
            }
            return super.getCMElementDeclaration(node);
        }
    }
}

