/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.core.internal.JSFLibraryClasspathContainer;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;

public class JSFLibrariesContainerInitializer
extends ClasspathContainerInitializer {
    private static final String MISSING_LIBRARY = Messages.JSFLibrariesContainerInitializer_missing_library;

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (this.isJSFLibraryContainer(containerPath)) {
            String libId = containerPath.lastSegment();
            JSFLibrary ref = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getJSFLibraryByID(libId);
            if (ref != null) {
                JSFLibraryClasspathContainer container = new JSFLibraryClasspathContainer(ref);
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
            }
        }
    }

    private boolean isJSFLibraryContainer(IPath path) {
        return path != null && path.segmentCount() == 2 && "org.eclipse.jst.jsf.core.internal.jsflibrarycontainer".equals(path.segment(0));
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return this.isJSFLibraryContainer(containerPath);
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        if (this.isJSFLibraryContainer(containerPath)) {
            String id = containerPath.lastSegment();
            JSFLibrary libref = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getJSFLibraryByID(id);
            Object displayText = id;
            if (libref == null) {
                displayText = (String)displayText + " " + MISSING_LIBRARY;
            }
            return displayText;
        }
        return super.getDescription(containerPath, project);
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return containerPath;
    }
}

