/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.closure.InterruptibleClosure;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class RepeatingInterruptibleClosure<A>
implements InterruptibleClosure<A> {
    private final int count;
    private final InterruptibleClosure<? super A> closure;

    public RepeatingInterruptibleClosure(InterruptibleClosure<? super A> closure, int count) {
        if (closure == null) {
            throw new NullPointerException();
        }
        if (count <= 0) {
            throw new IndexOutOfBoundsException("invalid count: " + count);
        }
        this.closure = closure;
        this.count = count;
    }

    @Override
    public void execute(A argument) throws InterruptedException {
        int i = this.count;
        while (i-- > 0) {
            this.closure.execute(argument);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.closure);
    }
}

