/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramModificationListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DocumentEvent;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDiagramModificationListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileEditorInputProxy;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.EditorIDEPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class FileDiagramDocumentProvider
extends FileDocumentProvider
implements IDiagramDocumentProvider {
    @Override
    protected IDocument createEmptyDocument() {
        return new DiagramDocument();
    }

    public IDiagramDocument getDiagramDocument(Object element) {
        IDocument doc = this.getDocument(element);
        if (doc instanceof IDiagramDocument) {
            return (IDiagramDocument)doc;
        }
        return null;
    }

    @Override
    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        super.disposeElementInfo(element, info);
        Object content = info.fDocument.getContent();
        if (content instanceof Diagram && info.fDocument instanceof IDiagramDocument) {
            DiagramIOUtil.unload((TransactionalEditingDomain)((IDiagramDocument)info.fDocument).getEditingDomain(), (Diagram)((Diagram)content));
            assert (info instanceof DiagramFileInfo);
        }
        if (((DiagramFileInfo)info).fListener != null) {
            ((DiagramFileInfo)info).fListener.stopListening();
        }
    }

    @Override
    protected void setDocumentContentFromStorage(IDocument document, IStorage storage) throws CoreException {
        Resource resource;
        IFile resourceFile;
        Diagram diagram = (Diagram)document.getContent();
        if (diagram != null && (resourceFile = WorkspaceSynchronizer.getFile((Resource)(resource = diagram.eResource()))) != null) {
            if (resourceFile.equals((Object)storage)) {
                document.setContent(null);
            } else {
                throw new CoreException((IStatus)new Status(4, EditorIDEPlugin.getPluginId(), 1, EditorMessages.FileDocumentProvider_handleElementContentChanged, null));
            }
        }
        IDiagramDocument diagramDocument = (IDiagramDocument)document;
        TransactionalEditingDomain domain = diagramDocument.getEditingDomain();
        diagram = DiagramIOUtil.load((TransactionalEditingDomain)domain, (IStorage)storage, (boolean)true, (IProgressMonitor)this.getProgressMonitor());
        document.setContent((Object)diagram);
    }

    @Override
    protected void saveDocumentToFile(IDocument document, IFile file, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        Diagram diagram = (Diagram)document.getContent();
        Resource resource = diagram.eResource();
        IFile resourceFile = WorkspaceSynchronizer.getFile((Resource)resource);
        if (resourceFile != null && !resourceFile.equals((Object)file)) {
            diagram = this.copyDiagramResource(diagram, file);
        }
        IDiagramDocument diagramDocument = (IDiagramDocument)document;
        TransactionalEditingDomain domain = diagramDocument.getEditingDomain();
        this.doSave(domain, file, diagram, null, monitor);
    }

    private Diagram copyDiagramResource(Diagram sourceDiagram, IFile file) {
        Resource sourceRes = sourceDiagram.eResource();
        EList contents = sourceRes.getContents();
        int indexOfDiagram = contents.indexOf((Object)sourceDiagram);
        final Collection copiedContents = EcoreUtil.copyAll((Collection)contents);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)sourceDiagram);
        String fileName = file.getFullPath().toString();
        final Resource newResource = editingDomain.getResourceSet().createResource(URI.createPlatformResourceURI((String)fileName, (boolean)true));
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("unprotected", Boolean.TRUE);
        AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                newResource.getContents().addAll(copiedContents);
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Trace.catching((Plugin)EditorIDEPlugin.getInstance(), (String)EditorDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"createView", (Throwable)e);
            Log.warning((Plugin)EditorIDEPlugin.getInstance(), (int)5, (String)"createView", (Throwable)e);
        }
        return (Diagram)newResource.getContents().get(indexOfDiagram);
    }

    @Override
    protected void handleElementContentChanged(IFileEditorInput fileEditorInput) {
        FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(fileEditorInput);
        if (info == null || !(info.fDocument instanceof IDiagramDocument)) {
            return;
        }
        assert (fileEditorInput instanceof FileEditorInputProxy);
        IDiagramDocument diagramDoc = (IDiagramDocument)info.fDocument;
        Diagram existingContent = diagramDoc.getDiagram();
        if (existingContent != null) {
            DiagramIOUtil.unload((TransactionalEditingDomain)((FileEditorInputProxy)fileEditorInput).getEditingDomain(), (Diagram)existingContent);
        }
        super.handleElementContentChanged(fileEditorInput);
    }

    @Override
    protected FileDocumentProvider.FileInfo createFileInfo(IDocument document, FileDocumentProvider.FileSynchronizer synchronizer, IFileEditorInput input) {
        assert (document instanceof DiagramDocument);
        FileDiagramModificationListener diagramListener = null;
        if (((DiagramDocument)document).getDiagram() != null) {
            diagramListener = new FileDiagramModificationListener(this, (DiagramDocument)document, input);
        }
        DiagramFileInfo info = new DiagramFileInfo(document, synchronizer, diagramListener);
        if (info.fListener != null) {
            info.fListener.startListening();
        }
        return info;
    }

    @Override
    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput) throws CoreException {
        if (editorInput instanceof FileEditorInputProxy) {
            FileEditorInputProxy diagramElement = (FileEditorInputProxy)editorInput;
            ((IDiagramDocument)document).setEditingDomain(diagramElement.getEditingDomain());
            boolean docContentSet = super.setDocumentContent(document, editorInput);
            return docContentSet;
        }
        return super.setDocumentContent(document, editorInput);
    }

    public IEditorInput createInputWithEditingDomain(IEditorInput editorInput, TransactionalEditingDomain domain) {
        if (editorInput instanceof IFileEditorInput) {
            return new FileEditorInputProxy((IFileEditorInput)editorInput, domain);
        }
        return null;
    }

    @Override
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            IFile file = input.getFile();
            file.refreshLocal(0, this.getProgressMonitor());
        }
        super.doSaveDocument(monitor, element, document, overwrite);
    }

    @Override
    protected ISchedulingRule getSaveRule(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return this.computeSaveSchedulingRule((IResource)input.getFile());
        }
        return null;
    }

    private ISchedulingRule computeSaveSchedulingRule(IResource toCreateOrModify) {
        if (toCreateOrModify.exists() && toCreateOrModify.isSynchronized(0)) {
            return this.fResourceRuleFactory.modifyRule(toCreateOrModify);
        }
        IResource parent = toCreateOrModify;
        while ((parent = (toCreateOrModify = parent).getParent()) != null && !parent.exists() && !parent.isSynchronized(0)) {
        }
        return this.fResourceRuleFactory.createRule(toCreateOrModify);
    }

    protected void doSave(TransactionalEditingDomain domain, IFile file, Diagram diagram, Map options, IProgressMonitor monitor) throws CoreException {
        if (options == null) {
            DiagramIOUtil.save((TransactionalEditingDomain)domain, (IFile)file, (Diagram)diagram, (boolean)DiagramIOUtil.hasUnrecognizedData((Resource)diagram.eResource()), (IProgressMonitor)monitor);
        } else {
            DiagramIOUtil.save((TransactionalEditingDomain)domain, (IFile)file, (Diagram)diagram, (IProgressMonitor)monitor, (Map)options);
        }
    }

    @Override
    protected void handleElementMoved(IFileEditorInput fileEditorInput, IPath path) {
        if (path != null) {
            IDiagramDocument diagramDocument = this.getDiagramDocument(fileEditorInput);
            Diagram diagram = null;
            if (diagramDocument != null) {
                diagram = diagramDocument.getDiagram();
            }
            if (diagram != null) {
                diagram.eResource().setURI(URI.createPlatformResourceURI((String)path.toString()));
            }
        }
        super.handleElementMoved(fileEditorInput, path);
    }

    public class DiagramFileInfo
    extends FileDocumentProvider.FileInfo {
        DiagramModificationListener fListener;

        public DiagramFileInfo(IDocument document, FileDocumentProvider.FileSynchronizer fileSynchronizer, DiagramModificationListener listener) {
            super(FileDiagramDocumentProvider.this, document, fileSynchronizer);
            this.fListener = listener;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (event.getEventKind() == 0) {
                Diagram newContent;
                IDiagramDocument diagramDoc = (IDiagramDocument)event.getDocument();
                Diagram existingContent = diagramDoc.getDiagram();
                URI existingURI = null;
                if (existingContent != null) {
                    existingURI = existingContent.eResource().getURI();
                    DiagramIOUtil.unload((TransactionalEditingDomain)diagramDoc.getEditingDomain(), (Diagram)existingContent);
                }
                if ((newContent = (Diagram)event.getEventInfo()) != null && existingURI != null) {
                    newContent.eResource().setURI(existingURI);
                }
            }
            super.documentAboutToBeChanged(event);
        }
    }
}

