/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.db.evolution.phased;

import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.evolution.IModelEvolutionSupport;
import org.eclipse.emf.cdo.server.db.evolution.phased.Context;
import org.eclipse.emf.cdo.server.db.evolution.phased.PhasedModelEvolutionSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.util.StringUtil;

public enum Phase {
    ChangeDetection(IModelEvolutionSupport.Trigger.ActivatingStore){

        @Override
        protected Transition getTransitionTo(Phase nextPhase) {
            switch (nextPhase) {
                case RepositoryExport: {
                    return Transition.NextTrigger;
                }
                case SchemaMigration: {
                    return Transition.SameTrigger;
                }
            }
            return null;
        }
    }
    ,
    RepositoryExport(IModelEvolutionSupport.Trigger.ActivatedRepository){

        @Override
        protected Transition getTransitionTo(Phase nextPhase) {
            switch (nextPhase) {
                case SchemaMigration: {
                    return Transition.RepositoryRestart;
                }
            }
            return null;
        }

        @Override
        public void init(Context context) {
            PhasedModelEvolutionSupport support = context.getSupport();
            InternalRepository repository = (InternalRepository)support.getStore().getRepository();
            InternalCDOPackageRegistry originalPackageRegistry = repository.getPackageRegistry(false);
            context.properties().put((Object)ORIGINAL_PACKAGE_REGISTRY_KEY, (Object)originalPackageRegistry);
            repository.setPackageRegistry(support.getOldPackageRegistry());
        }

        @Override
        public void done(Context context) {
            PhasedModelEvolutionSupport support = context.getSupport();
            InternalRepository repository = (InternalRepository)support.getStore().getRepository();
            InternalCDOPackageRegistry originalPackageRegistry = (InternalCDOPackageRegistry)context.properties().remove((Object)ORIGINAL_PACKAGE_REGISTRY_KEY);
            if (originalPackageRegistry != null) {
                repository.setPackageRegistry(originalPackageRegistry);
            }
        }
    }
    ,
    SchemaMigration(IModelEvolutionSupport.Trigger.ActivatingStore){

        @Override
        protected Transition getTransitionTo(Phase nextPhase) {
            switch (nextPhase) {
                case StoreProcessing: 
                case RepositoryProcessing: {
                    return Transition.StoreRestart;
                }
            }
            return null;
        }

        @Override
        public void done(Context context) {
            PhasedModelEvolutionSupport support = context.getSupport();
            IDBStore store = support.getStore();
            InternalRepository repository = (InternalRepository)store.getRepository();
            repository.setPackageRegistry(support.getNewPackageRegistry());
            IMappingStrategy mappingStrategy = store.getMappingStrategy();
            mappingStrategy.clearClassMappings();
        }
    }
    ,
    StoreProcessing(IModelEvolutionSupport.Trigger.ActivatingStore){

        @Override
        protected Transition getTransitionTo(Phase nextPhase) {
            switch (nextPhase) {
                case RepositoryProcessing: {
                    return Transition.NextTrigger;
                }
            }
            return null;
        }
    }
    ,
    RepositoryProcessing(IModelEvolutionSupport.Trigger.ActivatedRepository){

        @Override
        protected Transition getTransitionTo(Phase nextPhase) {
            return null;
        }
    };

    private static final String ORIGINAL_PACKAGE_REGISTRY_KEY;
    private final IModelEvolutionSupport.Trigger trigger;

    static {
        ORIGINAL_PACKAGE_REGISTRY_KEY = CDOPackageRegistry.class.getName();
    }

    private Phase(IModelEvolutionSupport.Trigger trigger) {
        this.trigger = trigger;
    }

    public boolean initial() {
        return this.ordinal() == 0;
    }

    public Phase next() {
        Phase[] values = Phase.values();
        int nextOrdinal = this.ordinal() + 1;
        if (nextOrdinal < values.length) {
            return values[nextOrdinal];
        }
        return null;
    }

    public IModelEvolutionSupport.Trigger trigger() {
        return this.trigger;
    }

    public Transition transitionTo(Phase nextPhase) {
        return nextPhase == null ? null : this.getTransitionTo(nextPhase);
    }

    protected abstract Transition getTransitionTo(Phase var1);

    public void init(Context context) {
    }

    public void done(Context context) {
    }

    public static Phase parse(String str) {
        return (Phase)StringUtil.parseEnum(Phase.class, (String)str, (boolean)true);
    }

    /* synthetic */ Phase(String string, int n, IModelEvolutionSupport.Trigger trigger, Phase phase) {
        this(trigger);
    }

    public static interface Handler {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.db.evolution.phaseHandlers";

        public Phase getPhase();

        public void setPhase(Phase var1);

        public void execute(Context var1) throws Exception;
    }

    public static enum Transition {
        SameTrigger,
        NextTrigger,
        StoreRestart,
        RepositoryRestart;

    }
}

