/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.SimpleClassDLTKExtensionManager;
import org.eclipse.dltk.core.SimpleDLTKExtensionManager;
import org.eclipse.dltk.ui.IModelCompareProvider;
import org.eclipse.dltk.ui.IModelContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;

public class UIModelProviderManager {
    private static final IModelCompareProvider[] NONE_MODEL_COMPARE_PROVIDERS = new IModelCompareProvider[0];
    private static final ILabelProvider[] NONE_LABEL_PROVIDERS = new ILabelProvider[0];
    private static final IModelContentProvider[] NONE_MODEL_CONTENT_PROVIDERS = new IModelContentProvider[0];
    private static final String REQUIRES = "requires";
    private static final String ID = "id";
    private static final String LANGUAGE = "language";
    private static SimpleClassDLTKExtensionManager contentProviderManager = new SimpleClassDLTKExtensionManager("org.eclipse.dltk.ui.modelContentProvider");
    private static SimpleClassDLTKExtensionManager labelProviderManager = new SimpleClassDLTKExtensionManager("org.eclipse.dltk.ui.modelLabelProvider");
    private static SimpleClassDLTKExtensionManager compareProviderManager = new SimpleClassDLTKExtensionManager("org.eclipse.dltk.ui.modelCompareProvider");
    private static Map<String, List<IModelContentProvider>> contentProviders = null;
    private static Map<String, List<ILabelProvider>> labelProviders = null;
    private static Map<String, List<IModelCompareProvider>> compareProviders = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static IModelContentProvider[] getContentProviders(String lang) {
        if (contentProviders == null) {
            Class<UIModelProviderManager> clazz = UIModelProviderManager.class;
            // MONITORENTER : org.eclipse.dltk.internal.ui.UIModelProviderManager.class
            if (contentProviders == null) {
                contentProviders = UIModelProviderManager.initializeProviders(contentProviderManager);
            }
            // MONITOREXIT : clazz
        }
        if (lang != null) {
            List<IModelContentProvider> result = contentProviders.get(lang);
            if (result == null) return NONE_MODEL_CONTENT_PROVIDERS;
            return result.toArray(new IModelContentProvider[result.size()]);
        }
        ArrayList<IModelContentProvider> providers = new ArrayList<IModelContentProvider>();
        for (List<IModelContentProvider> elements : contentProviders.values()) {
            providers.addAll(elements);
        }
        return providers.toArray(new IModelContentProvider[providers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ILabelProvider[] getLabelProviders(String lang) {
        if (labelProviders == null) {
            Class<UIModelProviderManager> clazz = UIModelProviderManager.class;
            // MONITORENTER : org.eclipse.dltk.internal.ui.UIModelProviderManager.class
            if (labelProviders == null) {
                labelProviders = UIModelProviderManager.initializeProviders(labelProviderManager);
            }
            // MONITOREXIT : clazz
        }
        if (lang != null) {
            List<ILabelProvider> result = labelProviders.get(lang);
            if (result == null) return NONE_LABEL_PROVIDERS;
            return result.toArray(new ILabelProvider[result.size()]);
        }
        ArrayList<ILabelProvider> providers = new ArrayList<ILabelProvider>();
        for (List<ILabelProvider> elements : labelProviders.values()) {
            providers.addAll(elements);
        }
        return providers.toArray(new ILabelProvider[providers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static IModelCompareProvider[] getCompareProviders(String lang) {
        if (compareProviders == null) {
            Class<UIModelProviderManager> clazz = UIModelProviderManager.class;
            // MONITORENTER : org.eclipse.dltk.internal.ui.UIModelProviderManager.class
            if (compareProviders == null) {
                compareProviders = UIModelProviderManager.initializeProviders(compareProviderManager);
            }
            // MONITOREXIT : clazz
        }
        if (lang != null) {
            List<IModelCompareProvider> result = compareProviders.get(lang);
            if (result == null) return NONE_MODEL_COMPARE_PROVIDERS;
            return result.toArray(new IModelCompareProvider[result.size()]);
        }
        ArrayList<IModelCompareProvider> providers = new ArrayList<IModelCompareProvider>();
        for (List<IModelCompareProvider> elements : compareProviders.values()) {
            providers.addAll(elements);
        }
        return providers.toArray(new IModelCompareProvider[providers.size()]);
    }

    private static <T> Map<String, List<T>> initializeProviders(SimpleClassDLTKExtensionManager manager) {
        HashMap<String, List<T>> providers = new HashMap<String, List<T>>();
        SimpleDLTKExtensionManager.ElementInfo[] infos = manager.getElementInfos();
        HashMap<String, ArrayList<SimpleDLTKExtensionManager.ElementInfo>> langToElementList = new HashMap<String, ArrayList<SimpleDLTKExtensionManager.ElementInfo>>();
        int i = 0;
        while (i < infos.length) {
            String langauge = infos[i].getConfig().getAttribute(LANGUAGE);
            ArrayList<SimpleDLTKExtensionManager.ElementInfo> elements = (ArrayList<SimpleDLTKExtensionManager.ElementInfo>)langToElementList.get(langauge);
            if (elements == null) {
                elements = new ArrayList<SimpleDLTKExtensionManager.ElementInfo>();
                langToElementList.put(langauge, elements);
            }
            elements.add(infos[i]);
            ++i;
        }
        for (Map.Entry entry : langToElementList.entrySet()) {
            String language = (String)entry.getKey();
            List elements = (List)entry.getValue();
            HashSet<String> allIds = new HashSet<String>();
            for (SimpleDLTKExtensionManager.ElementInfo info : elements) {
                allIds.add(info.getConfig().getAttribute(ID));
            }
            ArrayList<Object> result = new ArrayList<Object>();
            HashSet<String> added = new HashSet<String>();
            ArrayList<SimpleDLTKExtensionManager.ElementInfo> toProcess = new ArrayList<SimpleDLTKExtensionManager.ElementInfo>(elements);
            while (!toProcess.isEmpty()) {
                Object obj;
                SimpleDLTKExtensionManager.ElementInfo info = (SimpleDLTKExtensionManager.ElementInfo)toProcess.remove(0);
                String requires = info.getConfig().getAttribute(REQUIRES);
                if (requires == null) {
                    obj = manager.getInitObject(info);
                    if (obj == null) continue;
                    result.add(obj);
                    added.add(info.getConfig().getAttribute(ID));
                    continue;
                }
                if (added.contains(requires = requires.trim())) {
                    obj = manager.getInitObject(info);
                    if (obj == null) continue;
                    result.add(obj);
                    added.add(info.getConfig().getAttribute(ID));
                    continue;
                }
                if (allIds.contains(requires)) {
                    toProcess.add(info);
                    continue;
                }
                obj = manager.getInitObject(info);
                if (obj == null) continue;
                result.add(obj);
                added.add(info.getConfig().getAttribute(ID));
            }
            providers.put(language, result);
        }
        return providers;
    }
}

