/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogView;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWDdlParser;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDataPartitionKey;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPartitionKey;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTableSpace;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWMaterializedQueryTableImpl;
import org.eclipse.datatools.enablement.ibm.util.IRowCountCache;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsPackage;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogMaterializedQueryTable
extends LUWMaterializedQueryTableImpl
implements IRowCountCache,
ICatalogObject,
IDatabaseObject {
    private boolean columnsLoaded = false;
    private boolean indexLoaded = false;
    private boolean dependencyLoaded = false;
    private boolean tablespaceLoaded = false;
    private boolean partitionKeyLoaded = false;
    private boolean dataPartitionLoaded = false;
    private boolean loaded = false;
    private boolean privilegeLoaded = false;
    private boolean impactsLoaded = false;
    private boolean statisticsLoaded = false;
    private boolean rowCountLoaded = false;
    private String partitionMode = "";
    private Collection impacts = new ArrayList();
    private Collection statistics = new ArrayList();
    private String rowCount = null;

    public void refresh() {
        this.columnsLoaded = false;
        this.indexLoaded = false;
        if (this.dependencyLoaded) {
            this.dependencies.clear();
            this.dependencyLoaded = false;
        }
        this.partitionKeyLoaded = false;
        if (this.dataPartitionLoaded) {
            this.dataPartitions.clear();
            this.dataPartitionLoaded = false;
        }
        this.tablespaceLoaded = false;
        this.loaded = false;
        this.privilegeLoaded = false;
        this.rowCountLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public void refresh(int refreshType) {
        if (!false) {
            this.impacts.clear();
            this.impactsLoaded = false;
        }
        if ((1 & refreshType) == 1) {
            this.statistics.clear();
            this.statisticsLoaded = false;
            this.rowCountLoaded = false;
        }
    }

    public QueryExpression getQueryExpression() {
        if (!this.loaded) {
            this.load();
        }
        return this.queryExpression;
    }

    public EList getColumns() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getColumns();
        }
        if (!this.columnsLoaded) {
            this.loadColumns();
        }
        return this.columns;
    }

    public EList getIndex() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getIndex();
        }
        if (!this.indexLoaded) {
            this.loadIndexes();
        }
        return this.index;
    }

    public EList getDependencies() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getDependencies();
        }
        if (!this.dependencyLoaded) {
            this.loadDependencies();
        }
        return this.dependencies;
    }

    @Override
    public LUWTableSpace getRegularDataTableSpace() {
        if (!this.tablespaceLoaded) {
            this.loadTablespace();
        }
        return this.regularDataTableSpace;
    }

    @Override
    public LUWTableSpace getIndexDataTableSpace() {
        if (!this.tablespaceLoaded) {
            this.loadTablespace();
        }
        return this.indexDataTableSpace;
    }

    @Override
    public LUWTableSpace getLOBDataTableSpace() {
        if (!this.tablespaceLoaded) {
            this.loadTablespace();
        }
        return this.lobDataTableSpace;
    }

    @Override
    public LUWPartitionKey getPartitionKey() {
        if (!this.partitionKeyLoaded) {
            this.loadPartitionKey();
        }
        return this.partitionKey;
    }

    @Override
    public EList getDataPartitions() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getDataPartitions();
        }
        if (!this.dataPartitionLoaded) {
            this.loadDataPartitions();
        }
        return this.dataPartitions;
    }

    @Override
    public LUWDataPartitionKey getDataPartitionKey() {
        if (!this.dataPartitionLoaded) {
            this.loadDataPartitions();
        }
        return this.dataPartitionKey;
    }

    public EList getPrivileges() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getPrivileges();
        }
        if (!this.privilegeLoaded) {
            this.loadPrivileges();
        }
        return this.privileges;
    }

    public ICatalogObject[] getImpacted() {
        if (!this.impactsLoaded) {
            this.impacts = this.getImpactedObjects();
            this.impactsLoaded = true;
        }
        ICatalogObject[] objs = new ICatalogObject[this.impacts.size()];
        this.impacts.toArray(objs);
        return objs;
    }

    public Collection getStatistics() {
        if (!this.statisticsLoaded) {
            this.statistics = LUWCatalogTable.getStatistics(this.getConnection(), (Table)this);
            this.statisticsLoaded = true;
        }
        return this.statistics;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 8) {
            this.getColumns();
        } else if (id == 14) {
            this.getIndex();
        } else if (id == 2) {
            this.getDependencies();
        } else if (id == 33) {
            this.getRegularDataTableSpace();
        } else if (id == 32) {
            this.getLOBDataTableSpace();
        } else if (id == 31) {
            this.getIndexDataTableSpace();
        } else if (id == 18) {
            this.getQueryExpression();
        } else if (id == 30) {
            this.getPartitionKey();
        } else if (id == 34) {
            this.getDataPartitions();
        } else if (id == 35) {
            this.getDataPartitionKey();
        } else if (id == 7) {
            this.getPrivileges();
        }
        return super.eIsSet(eFeature);
    }

    public void setPartitionMode(String partitionMode) {
        this.partitionMode = partitionMode;
    }

    public String getPartitionMode() {
        return this.partitionMode;
    }

    private synchronized void loadColumns() {
        if (this.columnsLoaded) {
            return;
        }
        this.columnsLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadColumns(this.getConnection(), super.getColumns(), (Table)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadIndexes() {
        if (this.indexLoaded) {
            return;
        }
        this.indexLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadIndexes(this.getConnection(), super.getIndex(), (Table)this, ((LUWCatalogDatabase)this.getCatalogDatabase()).getLoadOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadDependencies() {
        if (this.dependencyLoaded) {
            return;
        }
        this.dependencyLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogView.loadDependencies(this.getConnection(), super.getDependencies(), (Table)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadTablespace() {
        if (this.tablespaceLoaded) {
            return;
        }
        this.tablespaceLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadTablespace(this.getConnection(), (Table)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            Connection connection = this.getConnection();
            DataModelElementFactory factory = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase()).getDataModelElementFactory();
            String query = "SELECT REFRESH,PROPERTY  FROM SYSCAT.TABLES  WHERE TABSCHEMA ='" + LUWUtil.getIdentifier(this.getSchema().getName()) + "'" + " AND TABNAME ='" + LUWUtil.getIdentifier(this.getName()) + "'" + " AND TYPE='S'";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
            }
            r.close();
            String querySQL = "SELECT TEXT  FROM SYSCAT.VIEWS WHERE VIEWSCHEMA='" + this.getSchema().getName() + "'" + " AND VIEWNAME='" + this.getName() + "'";
            r = s.executeQuery(querySQL);
            String text = "";
            while (r.next()) {
                String expression = r.getString("TEXT").trim();
                if (expression == null) continue;
                text = String.valueOf(text) + expression.trim() + " ";
                text = text.replaceAll("[\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f]", " ");
            }
            QueryExpression queryExpression = (QueryExpression)factory.create(SQLExpressionsPackage.eINSTANCE.getQueryExpressionDefault());
            LUWDdlParser ddlParser = new LUWDdlParser(RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase()));
            queryExpression.setSQL(ddlParser.parseMQT(text).getQueryExpression().getSQL());
            this.setQueryExpression(queryExpression);
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadPartitionKey() {
        if (this.partitionKeyLoaded) {
            return;
        }
        this.partitionKeyLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadPartitionKey(this.getConnection(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadDataPartitions() {
        if (this.dataPartitionLoaded) {
            return;
        }
        this.dataPartitionLoaded = true;
        super.getDataPartitions();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadDataPartitions(this.getConnection(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadPrivileges() {
        if (this.privilegeLoaded) {
            return;
        }
        this.privilegeLoaded = true;
        EList privileges = super.getPrivileges();
        for (Privilege privilege : privileges) {
            privilege.setGrantor(null);
            privilege.setGrantee(null);
        }
        privileges.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadPrivileges(this.getConnection(), privileges, (Table)this, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogTable.getImpactedTables(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedRoutines(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedTriggers(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedPackages(connection, (Table)this));
        return impacts;
    }

    protected void getPrivilegesWithFilter(String granteeFilter) throws SQLException {
        if (this.privilegeLoaded) {
            return;
        }
        EList privileges = super.getPrivileges();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadPrivileges(this.getConnection(), privileges, (Table)this, granteeFilter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public String getRowCountString() {
        if (!this.rowCountLoaded) {
            this.rowCount = LUWCatalogTable.loadRowCount(this.getConnection(), (Table)this);
            this.rowCountLoaded = true;
        }
        return this.rowCount;
    }

    public void setRowCountString(String count) {
        this.rowCount = count;
        this.rowCountLoaded = true;
    }
}

