/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.meson.ui.commands;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.meson.core.MesonBuildConfiguration;
import org.eclipse.cdt.internal.meson.core.MesonUtils;
import org.eclipse.cdt.internal.meson.ui.commands.AbstractMesonCommandHandler;
import org.eclipse.cdt.internal.meson.ui.wizards.RunNinja;
import org.eclipse.cdt.meson.ui.Activator;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RunNinjaCommandHandler
extends AbstractMesonCommandHandler {
    public Object execute(ExecutionEvent event) {
        return this.execute1(event);
    }

    @Override
    public void run(Shell shell) {
        final IConsole console = CCorePlugin.getDefault().getConsole();
        IProject project = (IProject)this.getSelectedContainer().getAdapter(IProject.class);
        console.start(project);
        try {
            ICBuildConfiguration buildConfig = (ICBuildConfiguration)project.getActiveBuildConfig().getAdapter(ICBuildConfiguration.class);
            if (buildConfig instanceof MesonBuildConfiguration) {
                final MesonBuildConfiguration config = (MesonBuildConfiguration)buildConfig;
                RunNinja wizard = new RunNinja(buildConfig);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                Display.getDefault().syncExec(() -> {
                    dialog.create();
                    dialog.open();
                });
                if (dialog.getReturnCode() == 0) {
                    Job buildJob = new Job("Running Ninja"){

                        public IStatus run(IProgressMonitor monitor) {
                            String envString = config.getProperty("meson.ninja.environment");
                            String[] ninjaEnv = null;
                            if (envString != null) {
                                ninjaEnv = MesonUtils.stripEnvVars((String)envString).toArray(new String[0]);
                            }
                            String argString = config.getProperty("meson.ninja.arguments");
                            String[] ninjaArgs = null;
                            if (argString != null) {
                                ArrayList<String> ninjaArgList = new ArrayList<String>();
                                Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(argString);
                                while (m.find()) {
                                    ninjaArgList.add(m.group(1));
                                }
                                ninjaArgs = ninjaArgList.toArray(new String[0]);
                            }
                            try {
                                config.build(6, null, ninjaEnv, ninjaArgs, console, monitor);
                                if (monitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                            }
                            catch (CoreException e) {
                                Activator.log((Exception)((Object)e));
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    buildJob.schedule();
                }
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
    }
}

