/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.extension.CDataObject;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescription;
import org.eclipse.cdt.internal.core.settings.model.CDataProxy;
import org.eclipse.cdt.internal.core.settings.model.CDataProxyContainer;
import org.eclipse.cdt.internal.core.settings.model.CLanguageSetting;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ICDataScope;
import org.eclipse.cdt.internal.core.settings.model.IInternalResourceDescription;
import org.eclipse.cdt.internal.core.settings.model.IProxyFactory;
import org.eclipse.cdt.internal.core.settings.model.IProxyProvider;
import org.eclipse.cdt.internal.core.settings.model.MapProxyCache;
import org.eclipse.cdt.internal.core.settings.model.ProxyProvider;
import org.eclipse.cdt.internal.core.settings.model.ResourceDescriptionHolder;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class CFolderDescription
extends CDataProxyContainer
implements ICFolderDescription,
IProxyFactory,
IInternalResourceDescription {
    private ResourceDescriptionHolder fRcHolder;
    private PathSettingsContainer fCache;

    CFolderDescription(CFolderData data, CConfigurationDescription cfg) {
        super(data, cfg, cfg);
    }

    @Override
    public IPath getPath() {
        CResourceData data = (CResourceData)this.getData(false);
        return ResourceDescriptionHolder.normalizePath(data.getPath());
    }

    @Override
    public boolean isExcluded() {
        CConfigurationDescription cfg = (CConfigurationDescription)this.getConfiguration();
        return cfg.isExcluded(this.getPath());
    }

    @Override
    public void setExcluded(boolean excluded) {
        CConfigurationDescription cfg = (CConfigurationDescription)this.getConfiguration();
        cfg.setExcluded(this.getPath(), true, excluded);
    }

    @Override
    public void setPath(IPath path) {
        path = ResourceDescriptionHolder.normalizePath(path);
        if (this.getPath().equals((Object)path)) {
            return;
        }
        CResourceData data = (CResourceData)this.getData(true);
        data.setPath(path);
    }

    protected CFolderData getFolderData(boolean write) {
        return (CFolderData)this.getData(write);
    }

    @Override
    protected IProxyProvider createChildProxyProvider() {
        ICDataScope scope = new ICDataScope(){

            @Override
            public CDataObject[] getChildren() {
                return CFolderDescription.this.getFolderData(false).getLanguageDatas();
            }

            @Override
            public boolean isStatic() {
                return !CFolderDescription.this.containsWritableData();
            }
        };
        MapProxyCache cache = new MapProxyCache();
        return new ProxyProvider(scope, cache, this);
    }

    @Override
    public ICResourceDescription getNestedResourceDescription(IPath relPath, boolean exactPath) {
        return this.getRcHolder().getResourceDescription(relPath, exactPath);
    }

    @Override
    public ICResourceDescription[] getNestedResourceDescriptions(int kind) {
        return this.getRcHolder().getResourceDescriptions(kind);
    }

    @Override
    public ICLanguageSetting getLanguageSettingForFile(String fileName) {
        IProject project = this.getConfiguration().getProjectDescription().getProject();
        return CProjectDescriptionManager.getInstance().findLanguagSettingForFile(fileName, project, this.getLanguageSettings());
    }

    @Override
    public ICLanguageSetting[] getLanguageSettings() {
        IProxyProvider provider = this.getChildrenProxyProvider();
        CFolderData data = (CFolderData)this.getData(false);
        CLanguageData[] lDatas = data.getLanguageDatas();
        ICLanguageSetting[] settings = new ICLanguageSetting[lDatas.length];
        int i = 0;
        while (i < lDatas.length) {
            settings[i] = (ICLanguageSetting)((Object)provider.getProxy(lDatas[i]));
            ++i;
        }
        return settings;
    }

    @Override
    public CDataProxy createProxy(CDataObject data) {
        if (data instanceof CLanguageData) {
            return new CLanguageSetting((CLanguageData)data, this, (CConfigurationDescription)this.getConfiguration());
        }
        return null;
    }

    private ResourceDescriptionHolder getRcHolder() {
        if (this.fRcHolder == null) {
            this.fRcHolder = ((CConfigurationDescription)this.getConfiguration()).createHolder(this);
        }
        return this.fRcHolder;
    }

    @Override
    void setData(CDataObject data) {
        super.setData(data);
        IPath cachedPath = this.getCachedPath();
        IPath newPath = ((CResourceData)data).getPath();
        if (cachedPath != null && !cachedPath.equals((Object)newPath)) {
            this.fCache.setPath(newPath, true);
        }
    }

    @Override
    public IPath getCachedPath() {
        if (this.fCache != null) {
            return this.fCache.getPath();
        }
        return null;
    }

    @Override
    public final int getType() {
        return 4;
    }

    @Override
    public void setPathContainer(PathSettingsContainer cr) {
        this.fCache = cr;
    }

    @Override
    public PathSettingsContainer getPathContainer() {
        return this.fCache;
    }

    @Override
    public ICResourceDescription[] getNestedResourceDescriptions() {
        return this.getNestedResourceDescriptions(12);
    }

    @Override
    public ICFolderDescription getParentFolderDescription() {
        return this.getRcHolder().getParentFolderDescription();
    }

    @Override
    public ICLanguageSetting createLanguageSettingForContentTypes(String languageId, String[] typeIds) throws CoreException {
        CFolderData data = this.getFolderData(true);
        CLanguageData lData = data.createLanguageDataForContentTypes(languageId, typeIds);
        if (lData == null) {
            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CFolderDescription.0"));
        }
        CDataProxy proxy = this.getChildrenProxyProvider().getProxy(lData);
        if (!(proxy instanceof ICLanguageSetting)) {
            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CFolderDescription.1") + proxy.getClass().getName());
        }
        return (ICLanguageSetting)((Object)proxy);
    }

    @Override
    public ICLanguageSetting createLanguageSettingForExtensions(String languageId, String[] extensions) throws CoreException {
        CFolderData data = this.getFolderData(true);
        CLanguageData lData = data.createLanguageDataForExtensions(languageId, extensions);
        if (lData == null) {
            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CFolderDescription.2"));
        }
        CDataProxy proxy = this.getChildrenProxyProvider().getProxy(lData);
        if (!(proxy instanceof ICLanguageSetting)) {
            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CFolderDescription.3") + proxy.getClass().getName());
        }
        return (ICLanguageSetting)((Object)proxy);
    }

    @Override
    public boolean isRoot() {
        return this.getPath().segmentCount() == 0;
    }

    @Override
    public boolean canExclude(boolean exclude) {
        CConfigurationDescription cfg = (CConfigurationDescription)this.getConfiguration();
        return cfg.canExclude(this.getPath(), true, exclude);
    }

    @Override
    public String toString() {
        String str = this.getPath().toString();
        return str.length() == 0 ? "/" : str;
    }
}

