/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IBlock;
import org.eclipse.wst.jsdt.core.ast.IStatement;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;

public class Block
extends Statement
implements IBlock {
    public Statement[] statements;
    public int explicitDeclarations;
    public BlockScope scope;

    public Block(int explicitDeclarations) {
        this.explicitDeclarations = explicitDeclarations;
    }

    @Override
    public IStatement[] getStatements() {
        return this.statements;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.statements == null) {
            return flowInfo;
        }
        boolean didAlreadyComplain = false;
        int i = 0;
        int max = this.statements.length;
        while (i < max) {
            Statement stat = this.statements[i];
            if (!stat.complainIfUnreachable(flowInfo, this.scope, didAlreadyComplain)) {
                flowInfo = stat.analyseCode(this.scope, flowContext, flowInfo);
            } else {
                didAlreadyComplain = true;
            }
            ++i;
        }
        return flowInfo;
    }

    @Override
    public boolean isEmptyBlock() {
        return this.statements == null;
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        if (this.statements == null) {
            return output;
        }
        int i = 0;
        while (i < this.statements.length) {
            this.statements[i].printStatement(indent + 1, output);
            output.append('\n');
            ++i;
        }
        return output;
    }

    @Override
    public StringBuffer printStatement(int indent, StringBuffer output) {
        Block.printIndent(indent, output);
        output.append("{\n");
        this.printBody(indent, output);
        return Block.printIndent(indent, output).append('}');
    }

    @Override
    public void resolve(BlockScope upperScope) {
        if ((this.bits & 8) != 0) {
            upperScope.problemReporter().undocumentedEmptyBlock(this.sourceStart, this.sourceEnd);
        }
        if (this.statements != null) {
            this.scope = upperScope;
            int i = 0;
            int length = this.statements.length;
            while (i < length) {
                this.statements[i].resolve(this.scope);
                ++i;
            }
        }
    }

    public void resolveUsing(BlockScope givenScope) {
        if ((this.bits & 8) != 0) {
            givenScope.problemReporter().undocumentedEmptyBlock(this.sourceStart, this.sourceEnd);
        }
        this.scope = givenScope;
        if (this.statements != null) {
            int i = 0;
            int length = this.statements.length;
            while (i < length) {
                this.statements[i].resolve(this.scope);
                ++i;
            }
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        BlockScope visitScope;
        BlockScope blockScope2 = visitScope = this.scope != null ? this.scope : blockScope;
        if (visitor.visit(this, blockScope) && this.statements != null) {
            int i = 0;
            int length = this.statements.length;
            while (i < length) {
                this.statements[i].traverse(visitor, visitScope);
                ++i;
            }
        }
        visitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 16;
    }
}

