/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.style;

import java.lang.reflect.Field;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.IValueSourcePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.AbstractStylePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.SubStylePropertyImpl;
import org.eclipse.wb.internal.core.model.property.editor.style.impl.BooleanStylePropertyImpl;
import org.eclipse.wb.internal.core.model.property.editor.style.impl.BooleanUsingEqualsStylePropertyImpl;
import org.eclipse.wb.internal.core.model.property.editor.style.impl.EnumerationStylePropertyImpl;
import org.eclipse.wb.internal.core.model.property.editor.style.impl.MacroStylePropertyImpl;
import org.eclipse.wb.internal.core.model.property.editor.style.impl.SelectionStylePropertyImpl;
import org.eclipse.wb.internal.core.model.property.editor.style.impl.SelectionUsingEqualsStylePropertyImpl;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;

public final class StylePropertyEditor
extends AbstractStylePropertyEditor
implements IClipboardSourceProvider,
IConfigurablePropertyObject,
IValueSourcePropertyEditor {
    private static final String STYLE_TITLE = "Style";
    private String m_className;
    private Class<?> m_class;
    private String m_title = "Style";

    protected String getText(Property property) throws Exception {
        return "[" + this.getSource(property, false, ", ") + "]";
    }

    public String getPropertyTitle() {
        return this.m_title;
    }

    @Override
    public String getAsString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.m_className);
        builder.append("\n");
        builder.append(super.getAsString());
        return builder.toString();
    }

    @Override
    public String getClipboardSource(GenericProperty property) throws Exception {
        return this.getSource((Property)property);
    }

    @Override
    public void configure(EditorState state, Map<String, Object> parameters) throws Exception {
        this.m_className = (String)parameters.get("class");
        this.m_class = state.getEditorLoader().loadClass(this.m_className);
        if (parameters.containsKey("title")) {
            this.m_title = (String)parameters.get("title");
        }
        this.configureSet(this.m_properties, state, parameters);
        this.configureSetUsingEquals(this.m_properties, state, parameters);
        this.configureMacro(this.m_properties, state, parameters);
        this.configureSelections(this.m_properties, state, parameters);
        this.configureSelectionUsingEquals(this.m_properties, state, parameters);
        this.configureEnums(this.m_properties, state, parameters);
    }

    private void configureSet(List<SubStylePropertyImpl> properties, EditorState state, Map<String, Object> parameters) throws Exception {
        if (parameters.containsKey("set")) {
            String[] setters = StringUtils.split((String)((String)parameters.get("set")));
            int i = 0;
            while (i < setters.length) {
                String[] names = StringUtils.split((String)setters[i], (char)':');
                String flagName = names[0];
                Field field = StylePropertyEditor.getField(state, this.m_class, flagName);
                if (field != null) {
                    long flag = field.getLong(null);
                    BooleanStylePropertyImpl property = names.length == 2 ? new BooleanStylePropertyImpl(this, names[1], flagName, flag) : new BooleanStylePropertyImpl(this, flagName.toLowerCase(), flagName, flag);
                    properties.add(property);
                    this.m_otherProperties.add(property);
                }
                ++i;
            }
        }
    }

    private void configureSetUsingEquals(List<SubStylePropertyImpl> properties, EditorState state, Map<String, Object> parameters) throws Exception {
        if (parameters.containsKey("setUsingEqual")) {
            String[] setters = StringUtils.split((String)((String)parameters.get("setUsingEqual")));
            int i = 0;
            while (i < setters.length) {
                String[] names = StringUtils.split((String)setters[i], (char)':');
                String flagName = names[0];
                Field field = StylePropertyEditor.getField(state, this.m_class, flagName);
                if (field != null) {
                    long flag = field.getLong(null);
                    BooleanUsingEqualsStylePropertyImpl property = names.length == 2 ? new BooleanUsingEqualsStylePropertyImpl(this, names[1], flagName, flag, this.m_className) : new BooleanUsingEqualsStylePropertyImpl(this, flagName.toLowerCase(), flagName, flag, this.m_className);
                    properties.add(property);
                    this.m_otherProperties.add(property);
                }
                ++i;
            }
        }
    }

    private void configureMacro(List<SubStylePropertyImpl> properties, EditorState state, Map<String, Object> parameters) throws Exception {
        String key;
        int macroIndex = 0;
        while (parameters.containsKey(key = "macro" + Integer.toString(macroIndex++))) {
            String[] values = StringUtils.split((String)((String)parameters.get(key)));
            String title = values[0];
            int flagCount = 0;
            String[] flagValues = new String[values.length - 1];
            int i = 0;
            while (i < flagValues.length) {
                String flag = values[i + 1];
                if (StylePropertyEditor.getField(state, this.m_class, flag) != null) {
                    flagValues[flagCount++] = flag;
                }
                ++i;
            }
            long[] flags = new long[flagCount];
            String[] sFlags = new String[flagCount + 1];
            sFlags[flagCount] = "";
            int i2 = 0;
            while (i2 < flagCount) {
                String flag = flagValues[i2];
                flags[i2] = this.m_class.getField(flag).getLong(null);
                sFlags[i2] = flag;
                ++i2;
            }
            MacroStylePropertyImpl property = new MacroStylePropertyImpl(this, title, flags, sFlags);
            properties.add(property);
            this.m_macroProperties.add(property);
        }
    }

    private void configureSelections(List<SubStylePropertyImpl> properties, EditorState state, Map<String, Object> parameters) throws Exception {
        String key;
        int selectIndex = 0;
        while (parameters.containsKey(key = "select" + Integer.toString(selectIndex++))) {
            String[] values = StringUtils.split((String)((String)parameters.get(key)));
            String title = values[0];
            String defaultString = values[1];
            long defaultFlag = StringUtils.isNumeric((CharSequence)defaultString) ? Long.parseLong(defaultString) : this.m_class.getField(defaultString).getLong(null);
            int flagCount = 0;
            String[] flagValues = new String[values.length - 2];
            int i = 0;
            while (i < flagValues.length) {
                String flag = values[i + 2];
                if (StringUtils.isNumeric((CharSequence)flag) || StylePropertyEditor.getField(state, this.m_class, flag) != null) {
                    flagValues[flagCount++] = flag;
                }
                ++i;
            }
            long[] flags = new long[flagCount];
            String[] sFlags = new String[flagCount];
            int i2 = 0;
            while (i2 < flagCount) {
                String flag = flagValues[i2];
                flags[i2] = StringUtils.isNumeric((CharSequence)flag) ? Long.parseLong(flag) : this.m_class.getField(flag).getLong(null);
                sFlags[i2] = flag;
                ++i2;
            }
            SelectionStylePropertyImpl property = new SelectionStylePropertyImpl(this, title, flags, sFlags, defaultFlag);
            properties.add(property);
            this.m_otherProperties.add(property);
        }
    }

    private void configureSelectionUsingEquals(List<SubStylePropertyImpl> properties, EditorState state, Map<String, Object> parameters) throws Exception {
        String key;
        int selectIndex = 0;
        while (parameters.containsKey(key = "selectUsingEqual" + Integer.toString(selectIndex++))) {
            String[] values = StringUtils.split((String)((String)parameters.get(key)));
            String title = values[0];
            int flagCount = 0;
            String[] flagValues = new String[values.length - 1];
            int i = 0;
            while (i < flagValues.length) {
                String flag = values[i + 1];
                if (StringUtils.isNumeric((CharSequence)flag) || StylePropertyEditor.getField(state, this.m_class, flag) != null) {
                    flagValues[flagCount++] = flag;
                }
                ++i;
            }
            long[] flags = new long[flagCount];
            String[] sFlags = new String[flagCount];
            int i2 = 0;
            while (i2 < flagCount) {
                String flag = flagValues[i2];
                flags[i2] = StringUtils.isNumeric((CharSequence)flag) ? Long.parseLong(flag) : this.m_class.getField(flag).getLong(null);
                sFlags[i2] = flag;
                ++i2;
            }
            SelectionUsingEqualsStylePropertyImpl property = new SelectionUsingEqualsStylePropertyImpl(this, title, flags, sFlags, this.m_className);
            properties.add(property);
            this.m_otherProperties.add(property);
        }
    }

    private void configureEnums(List<SubStylePropertyImpl> properties, EditorState state, Map<String, Object> parameters) throws Exception {
        String key;
        int selectIndex = 0;
        while (parameters.containsKey(key = "enum" + Integer.toString(selectIndex++))) {
            String[] values = StringUtils.split((String)((String)parameters.get(key)));
            String title = values[0];
            String mask16 = values[1];
            int clearMask = Integer.parseInt(mask16.substring(2), 16);
            int flagCount = 0;
            String[] flagValues = new String[values.length - 2];
            int i = 0;
            while (i < flagValues.length) {
                String flag = values[i + 2];
                if (StringUtils.isNumeric((CharSequence)flag) || StylePropertyEditor.getField(state, this.m_class, flag) != null) {
                    flagValues[flagCount++] = flag;
                }
                ++i;
            }
            long[] flags = new long[flagCount];
            String[] sFlags = new String[flagCount];
            int i2 = 0;
            while (i2 < flagCount) {
                String flag = flagValues[i2];
                flags[i2] = StringUtils.isNumeric((CharSequence)flag) ? Long.parseLong(flag) : this.m_class.getField(flag).getLong(null);
                sFlags[i2] = flag;
                ++i2;
            }
            EnumerationStylePropertyImpl property = new EnumerationStylePropertyImpl(this, title, flags, sFlags, clearMask);
            properties.add(property);
            this.m_otherProperties.add(property);
        }
    }

    private static Field getField(EditorState state, Class<?> baseClass, String name) {
        try {
            return baseClass.getField(name);
        }
        catch (NoSuchFieldException e) {
            state.addWarning(new EditorWarning("StylePropertyEditor: can not find field " + baseClass.getName() + "." + name, (Throwable)e));
            return null;
        }
    }

    private String getSource(Property property) throws Exception {
        return this.getSource(property, true, " | ");
    }

    private String getSource(Property mainProperty, boolean addClassAndDefault, String separator) throws Exception {
        String sFlag;
        StringBuffer source = new StringBuffer();
        long macroFlag = 0L;
        for (SubStylePropertyImpl property : this.m_macroProperties) {
            sFlag = property.getFlagValue(mainProperty);
            if (sFlag == null) continue;
            if (addClassAndDefault) {
                source.append(this.m_className);
                source.append('.');
            }
            source.append(sFlag);
            macroFlag = property.getFlag(sFlag);
            break;
        }
        for (SubStylePropertyImpl property : this.m_otherProperties) {
            sFlag = property.getFlagValue(mainProperty);
            if (sFlag == null || macroFlag != 0L && (macroFlag & property.getFlag(sFlag)) != 0L) continue;
            if (source.length() != 0) {
                source.append(separator);
            }
            if (addClassAndDefault) {
                source.append(this.m_className);
                source.append('.');
            }
            source.append(sFlag);
        }
        if (addClassAndDefault && source.length() == 0) {
            return null;
        }
        return source.toString();
    }

    public String getValueSource(Object value) throws Exception {
        Property property = StylePropertyEditor.getPropertyForValue(value);
        return this.getSource(property);
    }

    @Override
    protected void setStyleValue(Property property, long newValue) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        String source = this.getSource(StylePropertyEditor.getPropertyForValue(newValue));
        genericProperty.setExpression(source, Property.UNKNOWN_VALUE);
    }

    private int getPriority() {
        return STYLE_TITLE.equals(this.m_title) ? 1 : 2;
    }

    public static void addStyleProperties(List<Property> properties) throws Exception {
        ListIterator<Property> I = properties.listIterator();
        while (I.hasNext()) {
            Property[] subProperties;
            Property property = I.next();
            if (!(property instanceof ComplexProperty)) continue;
            ComplexProperty complexProperty = (ComplexProperty)property;
            if (!"Constructor".equals(property.getTitle()) && !"Factory".equals(property.getTitle())) continue;
            Property[] propertyArray = subProperties = complexProperty.getProperties();
            int n = subProperties.length;
            int n2 = 0;
            while (n2 < n) {
                Property subProperty = propertyArray[n2];
                PropertyEditor editor = subProperty.getEditor();
                if (editor instanceof StylePropertyEditor) {
                    GenericPropertyImpl constructorStyleProperty = (GenericPropertyImpl)subProperty;
                    StylePropertyEditor styleEditor = (StylePropertyEditor)editor;
                    String propertyTitle = styleEditor.getPropertyTitle();
                    GenericPropertyImpl styleProperty = new GenericPropertyImpl(constructorStyleProperty, propertyTitle);
                    styleProperty.setCategory(PropertyCategory.system((PropertyCategory)complexProperty.getCategory(), (int)styleEditor.getPriority()));
                    I.add((Property)styleProperty);
                }
                ++n2;
            }
        }
    }

    public static void configureContributeActions(final JavaInfo hostInfo) {
        hostInfo.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                Property property;
                if (object == hostInfo && (property = hostInfo.getPropertyByTitle(StylePropertyEditor.STYLE_TITLE)) != null && property.getEditor() instanceof StylePropertyEditor) {
                    IPreferenceStore preferences = hostInfo.getDescription().getToolkit().getPreferences();
                    boolean isCascade = preferences.getBoolean("styleProperty.cascadePopup");
                    StylePropertyEditor editor = (StylePropertyEditor)property.getEditor();
                    editor.contributeActions(property, manager, StylePropertyEditor.STYLE_TITLE, isCascade);
                }
            }
        });
    }
}

