/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.converter;

import org.eclipse.core.resources.IFile;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;

public final class StringConverter
extends ExpressionConverter {
    public static final StringConverter INSTANCE = new StringConverter();

    private StringConverter() {
    }

    @Override
    public String toJavaSource(JavaInfo javaInfo, Object value) {
        if (value == null) {
            return "(String) null";
        }
        String valueString = (String)value;
        String[] result = new String[1];
        if (result[0] == null) {
            result[0] = StringConverter.toJavaSource_UTF(javaInfo, valueString);
        }
        if (result[0] == null) {
            String escaped = StringUtilities.escapeJava((String)valueString);
            result[0] = "\"" + escaped + "\"";
        }
        return result[0];
    }

    private static String toJavaSource_UTF(JavaInfo javaInfo, String valueString) {
        return (String)ExecutionUtils.runObjectIgnore(() -> {
            IFile file;
            String charset;
            if (javaInfo != null && ((charset = (file = (IFile)javaInfo.getEditor().getModelUnit().getUnderlyingResource()).getCharset()).equals("UTF-8") || charset.equals("UTF-16"))) {
                String escaped = StringUtilities.escapeForJavaSource((String)valueString);
                return "\"" + escaped + "\"";
            }
            return null;
        }, null);
    }
}

