/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.common.core.ContentTypeReference;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.JptResourceTypeReference;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaPlatformProvider;
import org.eclipse.jpt.jpa.core.JpaResourceDefinition;
import org.eclipse.jpt.jpa.core.JpaResourceModelProvider;
import org.eclipse.jpt.jpa.core.context.java.DefaultJavaAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaManagedTypeDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaPersistentTypeDefinition;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;

public abstract class AbstractJpaPlatformProvider
implements JpaPlatformProvider {
    protected ArrayList<JptResourceType> mostRecentSupportedResourceTypes;
    protected ArrayList<JpaResourceModelProvider> resourceModelProviders;
    protected ArrayList<JavaManagedTypeDefinition> javaManagedTypeDefinitions;
    protected ArrayList<JavaTypeMappingDefinition> javaTypeMappingDefinitions;
    protected ArrayList<DefaultJavaAttributeMappingDefinition> defaultJavaAttributeMappingDefinitions;
    protected ArrayList<JavaAttributeMappingDefinition> specifiedJavaAttributeMappingDefinitions;
    protected ArrayList<JpaResourceDefinition> resourceDefinitions;
    protected static final JavaManagedTypeDefinition[] JAVA_MANAGED_TYPE_DEFINITIONS = new JavaManagedTypeDefinition[]{JavaPersistentTypeDefinition.instance()};

    protected AbstractJpaPlatformProvider() {
    }

    public synchronized ArrayList<JptResourceType> getMostRecentSupportedResourceTypes() {
        if (this.mostRecentSupportedResourceTypes == null) {
            this.mostRecentSupportedResourceTypes = this.buildMostRecentSupportedResourceTypes();
        }
        return this.mostRecentSupportedResourceTypes;
    }

    protected ArrayList<JptResourceType> buildMostRecentSupportedResourceTypes() {
        ArrayList<JptResourceType> types = new ArrayList<JptResourceType>();
        this.addMostRecentSupportedResourceTypesTo(types);
        this.validateMostRecentSupportedResourceTypes(types);
        return types;
    }

    protected abstract void addMostRecentSupportedResourceTypesTo(ArrayList<JptResourceType> var1);

    protected void validateMostRecentSupportedResourceTypes(ArrayList<JptResourceType> resourceTypes) {
        String message = "Duplicate resource types listed as most recent for content type ''{0}'': {1}";
        this.validate(resourceTypes, ContentTypeReference.TRANSFORMER, message);
    }

    @Override
    public final synchronized Iterable<JpaResourceModelProvider> getResourceModelProviders() {
        if (this.resourceModelProviders == null) {
            this.resourceModelProviders = this.buildResourceModelProviders();
        }
        return this.resourceModelProviders;
    }

    protected ArrayList<JpaResourceModelProvider> buildResourceModelProviders() {
        ArrayList<JpaResourceModelProvider> providers = new ArrayList<JpaResourceModelProvider>();
        this.addResourceModelProvidersTo(providers);
        this.validateResourceModelProviders(providers);
        return providers;
    }

    protected abstract void addResourceModelProvidersTo(ArrayList<JpaResourceModelProvider> var1);

    protected void validateResourceModelProviders(ArrayList<JpaResourceModelProvider> providers) {
        String message = "Duplicate resource model providers listed for content type ''{0}'': {1}";
        this.validate(providers, ContentTypeReference.TRANSFORMER, message);
    }

    @Override
    public final synchronized Iterable<JavaManagedTypeDefinition> getJavaManagedTypeDefinitions() {
        if (this.javaManagedTypeDefinitions == null) {
            this.javaManagedTypeDefinitions = this.buildJavaManagedTypeDefinitions();
        }
        return this.javaManagedTypeDefinitions;
    }

    protected ArrayList<JavaManagedTypeDefinition> buildJavaManagedTypeDefinitions() {
        ArrayList<JavaManagedTypeDefinition> definitions = new ArrayList<JavaManagedTypeDefinition>();
        this.addJavaManagedTypeDefinitionsTo(definitions);
        return definitions;
    }

    protected void addJavaManagedTypeDefinitionsTo(ArrayList<JavaManagedTypeDefinition> definitions) {
        CollectionTools.addAll(definitions, (Object[])JAVA_MANAGED_TYPE_DEFINITIONS);
    }

    @Override
    public final synchronized Iterable<JavaTypeMappingDefinition> getJavaTypeMappingDefinitions() {
        if (this.javaTypeMappingDefinitions == null) {
            this.javaTypeMappingDefinitions = this.buildJavaTypeMappingDefinitions();
        }
        return this.javaTypeMappingDefinitions;
    }

    protected ArrayList<JavaTypeMappingDefinition> buildJavaTypeMappingDefinitions() {
        ArrayList<JavaTypeMappingDefinition> definitions = new ArrayList<JavaTypeMappingDefinition>();
        this.addJavaTypeMappingDefinitionsTo(definitions);
        return definitions;
    }

    protected abstract void addJavaTypeMappingDefinitionsTo(ArrayList<JavaTypeMappingDefinition> var1);

    @Override
    public final synchronized Iterable<DefaultJavaAttributeMappingDefinition> getDefaultJavaAttributeMappingDefinitions() {
        if (this.defaultJavaAttributeMappingDefinitions == null) {
            this.defaultJavaAttributeMappingDefinitions = this.buildDefaultJavaAttributeMappingDefinitions();
        }
        return this.defaultJavaAttributeMappingDefinitions;
    }

    protected ArrayList<DefaultJavaAttributeMappingDefinition> buildDefaultJavaAttributeMappingDefinitions() {
        ArrayList<DefaultJavaAttributeMappingDefinition> definitions = new ArrayList<DefaultJavaAttributeMappingDefinition>();
        this.addDefaultJavaAttributeMappingDefinitionsTo(definitions);
        return definitions;
    }

    protected abstract void addDefaultJavaAttributeMappingDefinitionsTo(ArrayList<DefaultJavaAttributeMappingDefinition> var1);

    @Override
    public final synchronized Iterable<JavaAttributeMappingDefinition> getSpecifiedJavaAttributeMappingDefinitions() {
        if (this.specifiedJavaAttributeMappingDefinitions == null) {
            this.specifiedJavaAttributeMappingDefinitions = this.buildSpecifiedJavaAttributeMappingDefinitions();
        }
        return this.specifiedJavaAttributeMappingDefinitions;
    }

    protected ArrayList<JavaAttributeMappingDefinition> buildSpecifiedJavaAttributeMappingDefinitions() {
        ArrayList<JavaAttributeMappingDefinition> definitions = new ArrayList<JavaAttributeMappingDefinition>();
        this.addSpecifiedJavaAttributeMappingDefinitionsTo(definitions);
        return definitions;
    }

    protected abstract void addSpecifiedJavaAttributeMappingDefinitionsTo(ArrayList<JavaAttributeMappingDefinition> var1);

    @Override
    public final synchronized Iterable<JpaResourceDefinition> getResourceDefinitions() {
        if (this.resourceDefinitions == null) {
            this.resourceDefinitions = this.buildResourceDefinitions();
        }
        return this.resourceDefinitions;
    }

    protected ArrayList<JpaResourceDefinition> buildResourceDefinitions() {
        ArrayList<JpaResourceDefinition> definitions = new ArrayList<JpaResourceDefinition>();
        this.addResourceDefinitionsTo(definitions);
        this.validateResourceDefinitions(definitions);
        return definitions;
    }

    protected abstract void addResourceDefinitionsTo(ArrayList<JpaResourceDefinition> var1);

    protected void validateResourceDefinitions(ArrayList<JpaResourceDefinition> definitions) {
        String message = "Duplicate resource definitions listed for resource type ''{0}'': {1}";
        this.validate(definitions, JptResourceTypeReference.TRANSFORMER, message);
    }

    protected <K, V> void validate(ArrayList<? extends V> values, Transformer<V, K> keyTransformer, String message) {
        HashMap<Object, ArrayList<V>> map = new HashMap<Object, ArrayList<V>>(values.size());
        for (V v : values) {
            Object key = keyTransformer.transform(v);
            ArrayList<V> dupes = (ArrayList<V>)map.get(key);
            if (dupes == null) {
                dupes = new ArrayList<V>();
                map.put(key, dupes);
            }
            dupes.add(v);
        }
        for (Map.Entry entry : map.entrySet()) {
            ArrayList dupes = (ArrayList)entry.getValue();
            if (dupes.size() <= 1) continue;
            JptJpaCorePlugin.instance().logError(message, new Object[]{entry.getKey(), dupes});
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

