/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.protocol;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevisable;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.security.CDOPermissionProvider;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.model.CDOTypeImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionUnchunker;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CDODataOutputImpl
extends ExtendedDataOutput.Delegating
implements CDODataOutput {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CDODataOutputImpl.class);

    public CDODataOutputImpl(ExtendedDataOutput delegate) {
        super(delegate);
    }

    @Override
    public void writeXInt(int v) throws IOException {
        if (this.isXCompression()) {
            this.writeVarInt(v);
        } else {
            this.writeInt(v);
        }
    }

    @Override
    public void writeXLong(long v) throws IOException {
        if (this.isXCompression()) {
            this.writeVarLong(v);
        } else {
            this.writeLong(v);
        }
    }

    @Override
    public void writeCDOPackageUnit(CDOPackageUnit packageUnit, boolean withPackages) throws IOException {
        ((InternalCDOPackageUnit)packageUnit).write(this, withPackages);
    }

    @Override
    public void writeCDOPackageUnits(CDOPackageUnit ... packageUnits) throws IOException {
        int size = packageUnits.length;
        this.writeXInt(size);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} package units", new Object[]{size});
        }
        CDOPackageUnit[] cDOPackageUnitArray = packageUnits;
        int n = packageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPackageUnit packageUnit = cDOPackageUnitArray[n2];
            this.writeCDOPackageUnit(packageUnit, false);
            ++n2;
        }
    }

    @Override
    public void writeCDOPackageUnitType(CDOPackageUnit.Type type) throws IOException {
        this.writeByte(type.ordinal());
    }

    @Override
    public void writeCDOPackageInfo(CDOPackageInfo packageInfo) throws IOException {
        ((InternalCDOPackageInfo)packageInfo).write(this);
    }

    @Override
    public void writeCDOClassifierRef(CDOClassifierRef eClassifierRef) throws IOException {
        eClassifierRef.write(this);
    }

    @Override
    public void writeCDOClassifierRef(EClassifier eClassifier) throws IOException {
        this.writeCDOClassifierRef(new CDOClassifierRef(eClassifier));
    }

    @Override
    public void writeCDOPackageURI(String uri) throws IOException {
        this.getPackageURICompressor().write((ExtendedDataOutput)this, uri);
    }

    @Override
    public void writeCDOType(CDOType cdoType) throws IOException {
        ((CDOTypeImpl)cdoType).write(this);
    }

    @Override
    public void writeCDOBranch(CDOBranch branch) throws IOException {
        this.writeXInt(branch.getID());
    }

    @Override
    public void writeCDOBranchPoint(CDOBranchPoint branchPoint) throws IOException {
        this.writeCDOBranch(branchPoint.getBranch());
        this.writeXLong(branchPoint.getTimeStamp());
    }

    @Override
    public void writeCDOBranchVersion(CDOBranchVersion branchVersion) throws IOException {
        this.writeCDOBranch(branchVersion.getBranch());
        this.writeXInt(branchVersion.getVersion());
    }

    @Override
    public void writeCDOChangeSetData(CDOChangeSetData changeSetData) throws IOException {
        List<CDOIDAndVersion> newObjects = changeSetData.getNewObjects();
        this.writeXInt(newObjects.size());
        for (CDOIDAndVersion data : newObjects) {
            if (data instanceof CDORevision) {
                this.writeBoolean(true);
                this.writeCDORevision((CDORevision)data, -1);
                continue;
            }
            this.writeBoolean(false);
            this.writeCDOIDAndVersion(data);
        }
        List<CDORevisionKey> changedObjects = changeSetData.getChangedObjects();
        this.writeXInt(changedObjects.size());
        for (CDORevisionKey data : changedObjects) {
            if (data instanceof CDORevisionDelta) {
                this.writeBoolean(true);
                this.writeCDORevisionDelta((CDORevisionDelta)data);
                continue;
            }
            this.writeBoolean(false);
            this.writeCDORevisionKey(data);
        }
        List<CDOIDAndVersion> detachedObjects = changeSetData.getDetachedObjects();
        this.writeXInt(detachedObjects.size());
        for (CDOIDAndVersion data : detachedObjects) {
            this.writeCDOID(data.getID());
            boolean isCDORevisionKey = data instanceof CDORevisionKey;
            int version = data.getVersion();
            this.writeXInt(version);
            this.writeBoolean(isCDORevisionKey);
            if (!isCDORevisionKey) continue;
            CDORevisionKey revisionKey = (CDORevisionKey)data;
            this.writeCDOBranch(revisionKey.getBranch());
        }
    }

    @Override
    public void writeCDOCommitData(CDOCommitData commitData) throws IOException {
        List<CDOPackageUnit> newPackageUnits = commitData.getNewPackageUnits();
        this.writeXInt(newPackageUnits.size());
        for (CDOPackageUnit data : newPackageUnits) {
            this.writeCDOPackageUnit(data, false);
        }
        this.writeCDOChangeSetData(commitData);
    }

    @Override
    public void writeCDOCommitInfo(CDOCommitInfo commitInfo) throws IOException {
        this.writeXLong(commitInfo.getTimeStamp());
        this.writeXLong(commitInfo.getPreviousTimeStamp());
        CDOBranch branch = commitInfo.getBranch();
        if (branch != null) {
            this.writeBoolean(true);
            this.writeCDOBranch(branch);
            this.writeString(commitInfo.getUserID());
            this.writeString(commitInfo.getComment());
            CDOBranchUtil.writeBranchPointOrNull(this, commitInfo.getMergeSource());
            this.writeCDOCommitData(commitInfo);
        } else {
            this.writeBoolean(false);
        }
    }

    @Override
    public void writeCDOLockChangeInfo(CDOLockChangeInfo lockChangeInfo) throws IOException {
        this.writeCDOLockChangeInfo(lockChangeInfo, null);
    }

    @Override
    public void writeCDOLockChangeInfo(CDOLockChangeInfo lockChangeInfo, Set<CDOID> filter) throws IOException {
        if (lockChangeInfo.isInvalidateAll()) {
            this.writeBoolean(true);
            return;
        }
        this.writeBoolean(false);
        this.writeCDOBranchPoint(lockChangeInfo);
        this.writeCDOLockOwner(lockChangeInfo.getLockOwner());
        this.writeCDOLockDeltas(Arrays.asList(lockChangeInfo.getLockDeltas()), filter == null ? null : delta -> filter.contains(delta.getID()));
        this.writeCDOLockStates(Arrays.asList(lockChangeInfo.getLockStates()), filter == null ? null : state -> filter.contains(state.getID()));
    }

    @Override
    public void writeCDOLockArea(IDurableLockingManager.LockArea lockArea) throws IOException {
        this.writeString(lockArea.getDurableLockingID());
        this.writeCDOBranch(lockArea.getBranch());
        this.writeXLong(lockArea.getTimeStamp());
        this.writeString(lockArea.getUserID());
        this.writeBoolean(lockArea.isReadOnly());
        Map<CDOID, IDurableLockingManager.LockGrade> locks = lockArea.getLocks();
        this.writeXInt(locks.size());
        for (Map.Entry<CDOID, IDurableLockingManager.LockGrade> entry : locks.entrySet()) {
            this.writeCDOID(entry.getKey());
            this.writeEnum(entry.getValue());
        }
    }

    @Override
    public void writeCDOLockOwner(CDOLockOwner lockOwner) throws IOException {
        if (lockOwner == null) {
            this.writeXInt(-1);
        } else {
            this.writeXInt(lockOwner.getSessionID());
            this.writeXInt(lockOwner.getViewID());
            this.writeString(lockOwner.getDurableLockingID());
        }
    }

    @Override
    public void writeCDOLockDelta(CDOLockDelta lockDelta) throws IOException {
        CDOBranch branch;
        CDOID id;
        if (lockDelta == null) {
            this.writeByte(-1);
            return;
        }
        int opcode = 0;
        Object target = lockDelta.getTarget();
        if (target instanceof CDOIDAndBranch) {
            CDOIDAndBranch idAndBranch = (CDOIDAndBranch)target;
            id = idAndBranch.getID();
            branch = idAndBranch.getBranch();
            opcode = (byte)(opcode + 10);
        } else if (target instanceof CDOID) {
            id = (CDOID)target;
            branch = null;
        } else {
            throw new AssertionError((Object)("Unexpected type: " + target.getClass().getSimpleName()));
        }
        IRWLockManager.LockType type = lockDelta.getType();
        opcode = (byte)(opcode + type.ordinal());
        this.writeByte(opcode);
        this.writeCDOID(id);
        if (opcode >= 10) {
            this.writeCDOBranch(branch);
        }
        this.writeCDOLockOwner(lockDelta.getOldOwner());
        this.writeCDOLockOwner(lockDelta.getNewOwner());
    }

    @Override
    public void writeCDOLockState(CDOLockState lockState) throws IOException {
        if (lockState == null) {
            this.writeByte(0);
            return;
        }
        Object o = lockState.getLockedObject();
        if (o instanceof CDOID) {
            this.writeByte(1);
            this.writeCDOID((CDOID)o);
        } else if (o instanceof CDOIDAndBranch) {
            this.writeByte(2);
            this.writeCDOIDAndBranch((CDOIDAndBranch)o);
        } else {
            throw new AssertionError((Object)("Unexpected type: " + o.getClass().getSimpleName()));
        }
        Set<CDOLockOwner> readLockOwners = lockState.getReadLockOwners();
        this.writeXInt(readLockOwners.size());
        for (CDOLockOwner readLockOwner : readLockOwners) {
            this.writeCDOLockOwner(readLockOwner);
        }
        CDOLockOwner writeLockOwner = lockState.getWriteLockOwner();
        if (writeLockOwner != null) {
            this.writeBoolean(true);
            this.writeCDOLockOwner(writeLockOwner);
        } else {
            this.writeBoolean(false);
        }
        CDOLockOwner writeOptionOwner = lockState.getWriteOptionOwner();
        if (writeOptionOwner != null) {
            this.writeBoolean(true);
            this.writeCDOLockOwner(writeOptionOwner);
        } else {
            this.writeBoolean(false);
        }
    }

    @Override
    public void writeCDOLockType(IRWLockManager.LockType lockType) throws IOException {
        this.writeEnum((Enum)lockType);
    }

    @Override
    public void writeCDOID(CDOID id) throws IOException {
        CDOIDUtil.write(this, id);
    }

    @Override
    public void writeCDOIDReference(CDOIDReference idReference) throws IOException {
        idReference.write(this);
    }

    @Override
    public void writeCDOIDAndVersion(CDOIDAndVersion idAndVersion) throws IOException {
        this.writeCDOID(idAndVersion.getID());
        this.writeXInt(idAndVersion.getVersion());
    }

    @Override
    public void writeCDOIDAndBranch(CDOIDAndBranch idAndBranch) throws IOException {
        this.writeCDOID(idAndBranch.getID());
        this.writeCDOBranch(idAndBranch.getBranch());
    }

    @Override
    public void writeCDORevisionKey(CDORevisionKey revisionKey) throws IOException {
        if (revisionKey == null) {
            this.writeCDOID(CDOID.NULL);
        } else {
            this.writeCDOID(revisionKey.getID());
            this.writeCDOBranch(revisionKey.getBranch());
            this.writeXInt(revisionKey.getVersion());
        }
    }

    @Override
    public void writeCDORevision(CDORevision revision, int referenceChunk) throws IOException {
        this.writeCDORevision(revision, referenceChunk, null);
    }

    @Override
    public void writeCDORevision(CDORevision revision, int referenceChunk, CDOBranchPoint securityContext) throws IOException {
        if (revision != null) {
            this.writeBoolean(true);
            ((InternalCDORevision)revision).write(this, referenceChunk, securityContext);
        } else {
            this.writeBoolean(false);
        }
    }

    @Override
    public void writeCDORevisable(CDORevisable revisable) throws IOException {
        this.writeCDOBranch(revisable.getBranch());
        this.writeXInt(revisable.getVersion());
        this.writeXLong(revisable.getTimeStamp());
        this.writeXLong(revisable.getRevised());
    }

    @Override
    public void writeCDOList(EClass owner, EStructuralFeature feature, CDOList list, int referenceChunk) throws IOException {
        CDODataOutputImpl.writeCDOList(this, owner, feature, list, referenceChunk, null);
    }

    @Override
    public void writeCDOFeatureValue(EStructuralFeature feature, Object value) throws IOException {
        CDOType type = CDOModelUtil.getType(feature);
        type.writeValue(this, value);
    }

    @Override
    public void writeCDORevisionDelta(CDORevisionDelta revisionDelta) throws IOException {
        ((CDORevisionDeltaImpl)revisionDelta).write(this);
    }

    @Override
    public void writeCDOFeatureDelta(EClass owner, CDOFeatureDelta featureDelta) throws IOException {
        ((CDOFeatureDeltaImpl)featureDelta).write(this, owner);
    }

    @Override
    public void writeCDORevisionOrPrimitive(Object value) throws IOException {
        if (value == null) {
            value = CDOID.NULL;
        } else if (value instanceof EObject) {
            value = this.getIDProvider().provideCDOID(value);
        } else if (value instanceof CDORevision) {
            value = ((CDORevision)value).getID();
        }
        CDOType type = null;
        if (value instanceof CDOID) {
            type = CDOType.OBJECT;
        } else if (value instanceof Throwable) {
            type = CDOType.EXCEPTION;
        } else {
            try {
                type = CDOModelUtil.getPrimitiveType(value.getClass());
            }
            catch (IllegalArgumentException ex) {
                CDOType.Handler handler = CDOType.Handler.Registry.INSTANCE.getHandlerByValue(value);
                if (handler == null) {
                    throw ex;
                }
                type = CDOType.HANDLER;
            }
        }
        this.writeCDOType(type);
        type.writeValue(this, value);
    }

    @Override
    public void writeCDORevisionOrPrimitiveOrClassifier(Object value) throws IOException {
        if (value instanceof EClassifier) {
            this.writeBoolean(true);
            this.writeCDOClassifierRef((EClassifier)((EClass)value));
        } else {
            this.writeBoolean(false);
            this.writeCDORevisionOrPrimitive(value);
        }
    }

    @Override
    public CDOCommonSession getSession() {
        return null;
    }

    @Override
    public CDOPackageRegistry getPackageRegistry() {
        return null;
    }

    @Override
    public CDOIDProvider getIDProvider() {
        return null;
    }

    @Override
    public CDOPermissionProvider getPermissionProvider() {
        return CDORevision.PERMISSION_PROVIDER;
    }

    @Override
    public CDORevisionUnchunker getRevisionUnchunker() {
        return null;
    }

    protected boolean isXCompression() {
        return false;
    }

    protected StringIO getPackageURICompressor() {
        return StringIO.DIRECT;
    }

    public static void writeCDOList(CDODataOutput out, EClass owner, EStructuralFeature feature, CDOList list, int referenceChunk, UnaryOperator<CDOID> idConverter) throws IOException {
        int size;
        int n = size = list == null ? 0 : list.size();
        if (size > 0) {
            int sizeToLook = referenceChunk == -1 ? size : Math.min(referenceChunk, size);
            int i = 0;
            while (i < sizeToLook) {
                Object element = list.get(i, false);
                if (element == CDORevisionUtil.UNINITIALIZED) {
                    referenceChunk = i;
                    break;
                }
                ++i;
            }
        }
        if (referenceChunk != -1 && referenceChunk < size) {
            if (TRACER.isEnabled()) {
                TRACER.format("Writing feature {0}: size={1}, referenceChunk={2}", new Object[]{feature.getName(), size, referenceChunk});
            }
            out.writeXInt(-size);
            out.writeXInt(referenceChunk);
            size = referenceChunk;
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Writing feature {0}: size={1}", new Object[]{feature.getName(), size});
            }
            out.writeXInt(size);
        }
        if (feature instanceof EReference) {
            CDOIDProvider idProvider = out.getIDProvider();
            int j = 0;
            while (j < size) {
                Object value = list.get(j, false);
                if (value != null) {
                    if (idProvider != null) {
                        value = idProvider.provideCDOID(value);
                    }
                    if (idConverter != null) {
                        value = idConverter.apply((CDOID)value);
                    }
                }
                if (TRACER.isEnabled()) {
                    TRACER.trace("    " + value);
                }
                out.writeCDOFeatureValue(feature, value);
                ++j;
            }
        } else {
            int j = 0;
            while (j < size) {
                Object value = list.get(j, false);
                if (TRACER.isEnabled()) {
                    TRACER.trace("    " + value);
                }
                out.writeCDOFeatureValue(feature, value);
                ++j;
            }
        }
    }
}

