/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import io.github.toolfactory.jvm.util.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.FieldCriteria;
import org.burningwave.core.classes.Members;
import org.burningwave.core.function.Executor;

public class Fields
extends Members.Handler<Field, FieldCriteria> {
    public static Fields create() {
        return new Fields();
    }

    public <T> T getStatic(Field field) {
        return this.get(null, field);
    }

    public <T> T get(Object target, Field field) {
        try {
            return (T)field.get(target);
        }
        catch (IllegalAccessException exc) {
            this.setAccessible(field, true);
            return (T)Executor.get(() -> field.get(target));
        }
    }

    public <T> T getStatic(Class<?> targetClass, String fieldName) {
        return this.getStatic(this.findFirstAndMakeItAccessible(targetClass, fieldName, null));
    }

    public <T> T get(Object target, String fieldName) {
        return this.get(target, this.findFirstAndMakeItAccessible(StaticComponentContainer.Classes.retrieveFrom(target), fieldName, null));
    }

    public <T> T getStaticDirect(Field field) {
        return this.getDirect(null, field);
    }

    public <T> T getDirect(Object target, Field field) {
        return (T)Executor.get(() -> StaticComponentContainer.Driver.getFieldValue(target, field));
    }

    public <T> T getStaticDirect(Class<?> targetClass, String fieldName) {
        return this.getStaticDirect(this.findFirstAndMakeItAccessible(targetClass, fieldName, null));
    }

    public <T> T getDirect(Object target, String fieldName) {
        return this.getDirect(target, this.findFirstAndMakeItAccessible(StaticComponentContainer.Classes.retrieveFrom(target), fieldName, null));
    }

    private void set(Class<?> targetClass, Object target, String fieldName, Object value) {
        this.set(target, this.findFirstAndMakeItAccessible(targetClass, fieldName, StaticComponentContainer.Classes.retrieveFrom(value)), value);
    }

    public void set(Object target, Field field, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException exc) {
            this.setAccessible(field, true);
            Executor.run(() -> field.set(target, value));
        }
    }

    public void setStatic(Field field, Object value) {
        this.set(null, field, value);
    }

    public void setStatic(Class<?> targetClass, String fieldName, Object value) {
        this.set(targetClass, null, fieldName, value);
    }

    public void set(Object target, String fieldName, Object value) {
        this.set(StaticComponentContainer.Classes.retrieveFrom(target), target, fieldName, value);
    }

    public void setDirect(Object target, Field field, Object value) {
        StaticComponentContainer.Driver.setFieldValue(target, field, value);
    }

    private void setDirect(Class<?> targetClass, Object target, String fieldName, Object value) {
        this.setDirect(target, this.findFirstAndMakeItAccessible(targetClass, fieldName, StaticComponentContainer.Classes.retrieveFrom(value)), value);
    }

    public void setStaticDirect(Class<?> targetClass, String fieldName, Object value) {
        this.setDirect(targetClass, null, fieldName, value);
    }

    public void setStaticDirect(Field field, Object value) {
        this.setDirect(null, field, value);
    }

    public void setDirect(Object target, String fieldName, Object value) {
        this.setDirect(StaticComponentContainer.Classes.retrieveFrom(target), target, fieldName, value);
    }

    public Map<Field, ?> getAllStatic(Class<?> targetClass) {
        return this.getAll(() -> this.findAllAndMakeThemAccessible(targetClass), null);
    }

    public Map<Field, ?> getAll(Object target) {
        return this.getAll(() -> this.findAllAndMakeThemAccessible(StaticComponentContainer.Classes.retrieveFrom(target)), target);
    }

    public Map<Field, ?> getAll(FieldCriteria criteria, Object target) {
        return this.getAll(() -> this.findAllAndMakeThemAccessible(criteria, StaticComponentContainer.Classes.retrieveFrom(target)), target);
    }

    private Map<Field, Object> getAll(Supplier<Collection<Field>> fieldsSupplier, Object target) {
        HashMap<Field, Object> fieldValues = new HashMap<Field, Object>();
        for (Field field : fieldsSupplier.get()) {
            if (target != null) {
                fieldValues.put(field, Executor.get(() -> field.get(Modifier.isStatic(field.getModifiers()) ? null : target)));
                continue;
            }
            if (!Modifier.isStatic(field.getModifiers())) continue;
            fieldValues.put(field, Executor.get(() -> field.get(null)));
        }
        return fieldValues;
    }

    public Map<Field, ?> getAllStaticDirect(Class<?> targetClass) {
        return this.getAllDirect(() -> this.findAllAndMakeThemAccessible(targetClass), null);
    }

    public Map<Field, ?> getAllDirect(Object target) {
        return this.getAllDirect(() -> this.findAllAndMakeThemAccessible(StaticComponentContainer.Classes.retrieveFrom(target)), target);
    }

    public Map<Field, ?> getAllDirect(FieldCriteria criteria, Object target) {
        return this.getAllDirect(() -> this.findAllAndMakeThemAccessible(criteria, StaticComponentContainer.Classes.retrieveFrom(target)), target);
    }

    private Map<Field, ?> getAllDirect(Supplier<Collection<Field>> fieldsSupplier, Object target) {
        HashMap<Field, Object> fieldValues = new HashMap<Field, Object>();
        for (Field field : fieldsSupplier.get()) {
            fieldValues.put(field, Executor.get(() -> StaticComponentContainer.Driver.getFieldValue(target, field)));
        }
        return fieldValues;
    }

    public Field findOneAndMakeItAccessible(Class<?> targetClass, String memberName) {
        Collection<Field> members = this.findAllByExactNameAndMakeThemAccessible(targetClass, memberName, null);
        if (members.size() != 1) {
            StaticComponentContainer.Driver.throwException((Throwable)new NoSuchFieldException(Strings.compile((String)"Field {} not found or found more than one field in {} hierarchy", (Object[])new Object[]{memberName, targetClass.getName()})));
        }
        return members.stream().findFirst().get();
    }

    public Field findFirstAndMakeItAccessible(Class<?> targetClass, String fieldName) {
        return this.findFirstAndMakeItAccessible(targetClass, fieldName, null);
    }

    public Field findFirstAndMakeItAccessible(Class<?> targetClass, String fieldName, Class<?> fieldTypeOrSubType) {
        Collection<Field> members = this.findAllByExactNameAndMakeThemAccessible(targetClass, fieldName, fieldTypeOrSubType);
        if (members.size() < 1) {
            StaticComponentContainer.Driver.throwException((Throwable)new NoSuchFieldException(Strings.compile((String)"Field {} not found in {} hierarchy", (Object[])new Object[]{fieldName, targetClass.getName()})));
        }
        return members.stream().findFirst().get();
    }

    public Collection<Field> findAllByExactNameAndMakeThemAccessible(Class<?> targetClass, String fieldName) {
        return this.findAllByExactNameAndMakeThemAccessible(targetClass, fieldName, null);
    }

    public Collection<Field> findAllByExactNameAndMakeThemAccessible(Class<?> targetClass, String fieldName, Class<?> valueType) {
        String cacheKey = this.getCacheKey(targetClass, "equals " + fieldName, valueType);
        ClassLoader targetClassClassLoader = StaticComponentContainer.Classes.getClassLoader(targetClass);
        return StaticComponentContainer.Cache.uniqueKeyForFields.getOrUploadIfAbsent(targetClassClassLoader, cacheKey, () -> this.findAllAndMakeThemAccessible((FieldCriteria)FieldCriteria.forEntireClassHierarchy().allThoseThatMatch(field -> {
            if (valueType == null) {
                return field.getName().equals(fieldName);
            }
            return field.getName().equals(fieldName) && StaticComponentContainer.Classes.isAssignableFrom(field.getType(), valueType);
        }), targetClass));
    }

    public Collection<Field> findAllAndMakeThemAccessible(Class<?> targetClass) {
        String cacheKey = this.getCacheKey(targetClass, "all fields", null);
        ClassLoader targetClassClassLoader = StaticComponentContainer.Classes.getClassLoader(targetClass);
        return StaticComponentContainer.Cache.uniqueKeyForFields.getOrUploadIfAbsent(targetClassClassLoader, cacheKey, () -> this.findAllAndMakeThemAccessible(FieldCriteria.forEntireClassHierarchy(), targetClass));
    }

    public static class NoSuchFieldException
    extends RuntimeException {
        private static final long serialVersionUID = 3656790511956737635L;

        public NoSuchFieldException(String message) {
            super(message);
        }
    }
}

