/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;

public class InMemoryURIHandler
implements URIHandler {
    public static final String SCHEME = "inmemory";
    private Map<URI, InMemFile> files = new HashMap<URI, InMemFile>();

    public boolean canHandle(URI uri) {
        return SCHEME.equals(uri.scheme());
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        return Collections.emptyMap();
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        return this.getInMemoryFile(uri).createInputStream();
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        return this.getInMemoryFile(uri).createOutputstream();
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        this.getInMemoryFile((URI)uri).exists = false;
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return this.getInMemoryFile((URI)uri).exists;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return Collections.emptyMap();
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
    }

    public InMemFile getInMemoryFile(URI uri) {
        InMemFile result = this.files.get(uri);
        if (result == null) {
            result = new InMemFile(uri);
            this.files.put(uri, result);
        }
        return result;
    }

    public Map<URI, InMemFile> getFiles() {
        return this.files;
    }

    public static class InMemFile {
        private final URI uri;
        private byte[] contents;
        private boolean exists;

        public OutputStream createOutputstream() {
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    contents = this.toByteArray();
                    exists = true;
                }
            };
        }

        public InputStream createInputStream() throws IOException {
            if (this.contents == null || !this.exists) {
                throw new IOException("File " + String.valueOf(this.uri) + " does not exist.");
            }
            return new ByteArrayInputStream(this.contents);
        }

        public InMemFile(URI uri) {
            this.uri = uri;
        }

        public URI getUri() {
            return this.uri;
        }

        public byte[] getContents() {
            return this.contents;
        }

        public void setContents(byte[] contents) {
            this.contents = contents;
        }

        public boolean isExists() {
            return this.exists;
        }

        public void setExists(boolean exists) {
            this.exists = exists;
        }
    }
}

