import * as net from 'net';
import type * as ts from 'typescript';
import type { ProjectInfo, Request } from './server';
export { TypeScriptProjectHost } from '@volar/typescript';
export declare const onSomePipeReadyCallbacks: (() => void)[];
export declare function getNamedPipePath(projectKind: ts.server.ProjectKind.Configured | ts.server.ProjectKind.Inferred, key: number): string;
export declare function getReadyNamedPipePaths(): {
    configured: string[];
    inferred: string[];
};
export declare function connect(namedPipePath: string, timeout?: number): Promise<net.Socket | "error" | "timeout">;
export declare function searchNamedPipeServerForFile(fileName: string): Promise<{
    socket: net.Socket;
    projectInfo: ProjectInfo;
} | undefined>;
export declare function sendRequestWorker<T>(request: Request, socket: net.Socket): Promise<T | null | undefined>;
