/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.layout;

import org.apache.commons.collections4.BidiMap;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.Property;

public final class GeneralLayoutData {
    public static final Object KEY = GeneralLayoutData.class;
    public Boolean horizontalGrab = null;
    public Boolean verticalGrab = null;
    public HorizontalAlignment horizontalAlignment = null;
    public VerticalAlignment verticalAlignment = null;
    public Integer gridX = null;
    public Integer gridY = null;
    public Integer spanX = null;
    public Integer spanY = null;

    public String toString() {
        String sx_str;
        String y_str;
        String null_str = "null";
        String x_str = this.gridX == null ? "null" : this.gridX.toString();
        String string = y_str = this.gridY == null ? "null" : this.gridY.toString();
        String string2 = this.spanX == null ? null : (sx_str = this.spanX > 1 ? this.spanX.toString() : null);
        String sy_str = this.spanY == null ? null : (this.spanY > 1 ? this.spanY.toString() : null);
        return "cell(" + x_str + (String)(sx_str == null ? "" : "+" + sx_str) + ";" + y_str + (String)(sy_str == null ? "" : "+" + sy_str) + ") grab(" + (this.horizontalGrab == null ? "null" : this.horizontalGrab.toString()) + ";" + (this.verticalGrab == null ? "null" : this.verticalGrab.toString()) + ") align(" + (this.horizontalAlignment == null ? "null" : this.horizontalAlignment.toString()) + ";" + (this.verticalAlignment == null ? "null" : this.verticalAlignment.toString()) + ")";
    }

    public void putToInfo(ObjectInfo objectInfo) {
        objectInfo.putArbitraryValue(KEY, this);
    }

    public static GeneralLayoutData getFromInfo(ObjectInfo objectInfo) {
        GeneralLayoutData generalLayoutData = (GeneralLayoutData)objectInfo.getArbitraryValue(KEY);
        GeneralLayoutData.clearForInfo(objectInfo);
        return generalLayoutData;
    }

    public static GeneralLayoutData getFromInfoEx(ObjectInfo objectInfo) {
        GeneralLayoutData generalLayoutData = GeneralLayoutData.getFromInfo(objectInfo);
        return generalLayoutData == null ? new GeneralLayoutData() : generalLayoutData;
    }

    public static void clearForInfo(ObjectInfo objectInfo) {
        objectInfo.removeArbitraryValue(KEY);
    }

    public static Object getLayoutPropertyValue(ObjectInfo layoutData, String propertyName) throws Exception {
        Object value;
        Property property = layoutData.getPropertyByTitle(propertyName);
        if (property != null && (value = property.getValue()) != Property.UNKNOWN_VALUE) {
            return value;
        }
        return null;
    }

    public static void setLayoutPropertyValue(ObjectInfo layoutData, String propertyName, Object propertyValue) throws Exception {
        Property property = layoutData.getPropertyByTitle(propertyName);
        if (property != null && propertyValue != null && propertyValue != Property.UNKNOWN_VALUE) {
            property.setValue(propertyValue);
        }
    }

    public static <K, T> T getRealValue(BidiMap<K, T> map, K generic) {
        return (T)(generic == null ? null : map.get(generic));
    }

    public static <K, T> K getGeneralValue(BidiMap<K, T> map, T real) {
        return (K)(real == null ? null : map.inverseBidiMap().get(real));
    }

    public static enum HorizontalAlignment {
        NONE,
        LEFT,
        CENTER,
        RIGHT,
        FILL;

    }

    public static enum VerticalAlignment {
        NONE,
        TOP,
        CENTER,
        BOTTOM,
        FILL;

    }
}

