/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.decoration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramListEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeNameEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.DecorationDescriptor;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.SiriusDecorationDescriptorProvider;

public abstract class AbstractSiriusDecorationDescriptorProvider
implements SiriusDecorationDescriptorProvider {
    @Override
    public void activate(IDecoratorTarget decoratorTarget, IDecorator decorator, GraphicalEditPart editPart) {
    }

    @Override
    public void deactivate(IDecorator decorator, GraphicalEditPart editPart) {
    }

    @Override
    public boolean provides(IDiagramElementEditPart editPart) {
        return false;
    }

    @Override
    public List<DecorationDescriptor> getDecorationDescriptors(IDiagramElementEditPart diagramEditPart, Session session) {
        View view = (View)diagramEditPart.getModel();
        if (view != null && (this.shouldConsiderDetachedViews() || view.eResource() != null) && this.shouldBeDecorated((EditPart)diagramEditPart)) {
            return this.createDecorationDescriptors(diagramEditPart, session);
        }
        return new ArrayList<DecorationDescriptor>();
    }

    protected abstract List<DecorationDescriptor> createDecorationDescriptors(IDiagramElementEditPart var1, Session var2);

    protected boolean shouldConsiderDetachedViews() {
        return false;
    }

    protected boolean shouldBeDecorated(EditPart editPart) {
        boolean shouldBeDecorated = true;
        if (this.isUnsafeEditPart(editPart)) {
            shouldBeDecorated = false;
        } else if (editPart instanceof AbstractDiagramNameEditPart && !(editPart instanceof DNodeListElementEditPart)) {
            shouldBeDecorated = false;
        }
        return shouldBeDecorated;
    }

    private boolean isUnsafeEditPart(EditPart editPart) {
        RootEditPart root;
        boolean unsafe = false;
        unsafe = editPart == null || editPart.getParent() == null ? true : (root = editPart.getRoot()) == null || root.getViewer() == null;
        return unsafe;
    }

    public boolean isDecorableEditPart(IDiagramElementEditPart editPart) {
        boolean result = true;
        if (editPart instanceof DNodeNameEditPart) {
            EditPart parentEditPart = editPart.getParent();
            if (!(parentEditPart instanceof DNodeListEditPart) && !(parentEditPart instanceof AbstractDiagramListEditPart)) {
                result = false;
            }
        } else if (editPart instanceof DNodeListNameEditPart) {
            result = false;
        } else if (editPart instanceof DNodeListElementEditPart) {
            Object parentModel = editPart.getParent().getModel();
            View notationView = editPart.getNotationView();
            if (parentModel instanceof View && notationView != null) {
                View parentView = (View)parentModel;
                EObject parentElement = parentView.getElement();
                result = parentElement != null && !parentElement.equals(notationView.getElement());
            }
        }
        return result;
    }
}

