/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.widgets.providers.HierarchicToFlatContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.uml.alf.BooleanLiteralExpression;
import org.eclipse.papyrus.uml.alf.Expression;
import org.eclipse.papyrus.uml.alf.LiteralExpression;
import org.eclipse.papyrus.uml.alf.NameExpression;
import org.eclipse.papyrus.uml.alf.NaturalLiteralExpression;
import org.eclipse.papyrus.uml.alf.SequenceConstructionExpression;
import org.eclipse.papyrus.uml.alf.SequenceExpressionList;
import org.eclipse.papyrus.uml.alf.StringLiteralExpression;
import org.eclipse.papyrus.uml.profile.structure.AppliedStereotypeProperty;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.utils.NameResolutionUtils;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class AppliedStereotypePropertyEditorUtil {
    private static final String VALUE_NULL = "= null";
    private static final String EQUAL = "=";
    private static final String BRAKET_END = "}";
    private static final String HOOK_END = "]";
    private static final String BRACKET_BEGIN = "{";
    private static final String HOOK_BEGIN = "[";

    public static String getLabel(AppliedStereotypeProperty appliedStereotypeProperty) {
        Property property = appliedStereotypeProperty.getStereotypeProperty();
        Stereotype stereotype = appliedStereotypeProperty.getStereotype();
        Element umlElement = appliedStereotypeProperty.getBaseElement();
        Object result = StereotypeUtil.displayPropertyValueToEdit((Stereotype)stereotype, (Property)property, (Element)umlElement, (String)"");
        result = ((String)result).replace(HOOK_BEGIN, BRACKET_BEGIN);
        if (!((String)(result = ((String)result).replace(HOOK_END, BRAKET_END))).contains(EQUAL)) {
            result = (String)result + VALUE_NULL;
        }
        if (((String)(result = ((String)result).substring(((String)result).indexOf(EQUAL)))).contains(VALUE_NULL)) {
            return result;
        }
        if ("Integer".equals(property.getType().getName())) {
            result = ((String)result).replace("\"", "");
        }
        if ("Boolean".equals(property.getType().getName())) {
            result = ((String)result).replace("\"", "");
        }
        return result;
    }

    public static Object[] getPossibleElements(AppliedStereotypeProperty appliedStereotypeProperty) {
        EStructuralFeature foundStructuralFeature = null;
        for (EStructuralFeature eStructuralFeature : appliedStereotypeProperty.getStereotypeApplication().eClass().getEAllStructuralFeatures()) {
            if (!eStructuralFeature.getName().equals(appliedStereotypeProperty.getStereotypeProperty().getName())) continue;
            foundStructuralFeature = eStructuralFeature;
        }
        UMLContentProvider umlContentProvider = new UMLContentProvider(appliedStereotypeProperty.getStereotypeApplication(), foundStructuralFeature, appliedStereotypeProperty.getStereotype());
        HierarchicToFlatContentProvider treeToFlatContentProvider = new HierarchicToFlatContentProvider((IHierarchicContentProvider)umlContentProvider);
        return treeToFlatContentProvider.getElements();
    }

    public static List<Object> resolvePrimitiveValue(Expression valueSpecification) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (valueSpecification instanceof SequenceConstructionExpression) {
            SequenceConstructionExpression sequence = (SequenceConstructionExpression)valueSpecification;
            if (sequence.getElements() instanceof SequenceExpressionList) {
                SequenceExpressionList expList = (SequenceExpressionList)sequence.getElements();
                for (Expression expression : expList.getElement()) {
                    result.addAll(AppliedStereotypePropertyEditorUtil.resolvePrimitiveValue(expression));
                }
            }
        } else if (valueSpecification instanceof LiteralExpression) {
            if (valueSpecification instanceof StringLiteralExpression) {
                result.add(((StringLiteralExpression)valueSpecification).getImage());
            } else if (valueSpecification instanceof BooleanLiteralExpression) {
                result.add(Boolean.parseBoolean(((BooleanLiteralExpression)valueSpecification).getImage()));
            } else if (valueSpecification instanceof NaturalLiteralExpression) {
                result.add(Integer.parseInt(((NaturalLiteralExpression)valueSpecification).getImage()));
            }
        }
        return result;
    }

    public static List<EnumerationLiteral> resolveEnumerationLiteralValue(Expression expression, List<NamedElement> candidates) {
        ArrayList<EnumerationLiteral> result = new ArrayList<EnumerationLiteral>();
        if (expression instanceof SequenceConstructionExpression) {
            SequenceConstructionExpression sequence = (SequenceConstructionExpression)expression;
            if (sequence.getElements() instanceof SequenceExpressionList) {
                SequenceExpressionList expList = (SequenceExpressionList)sequence.getElements();
                for (Expression exp : expList.getElement()) {
                    result.addAll(AppliedStereotypePropertyEditorUtil.resolveEnumerationLiteralValue(exp, candidates));
                }
            }
        } else if (expression instanceof NameExpression) {
            NameExpression nameExpression = (NameExpression)expression;
            String name = nameExpression.getName().getUnqualifiedName().getName();
            int i = 0;
            EnumerationLiteral literal = null;
            while (i < candidates.size() && literal == null) {
                literal = (EnumerationLiteral)candidates.get(i);
                if (!literal.getName().equals(name)) {
                    literal = null;
                }
                ++i;
            }
            if (literal != null) {
                result.add(literal);
            }
        }
        return result;
    }

    public static List<NamedElement> resolveReferenceValue(Expression expression, Element scope) {
        ArrayList<NamedElement> references = new ArrayList<NamedElement>();
        if (expression instanceof SequenceConstructionExpression) {
            SequenceConstructionExpression sequence = (SequenceConstructionExpression)expression;
            if (sequence.getElements() instanceof SequenceExpressionList) {
                SequenceExpressionList expList = (SequenceExpressionList)sequence.getElements();
                for (Expression exp : expList.getElement()) {
                    references.addAll(AppliedStereotypePropertyEditorUtil.resolveReferenceValue(exp, scope));
                }
            }
        } else if (expression instanceof NameExpression) {
            NameExpression nameExpression = (NameExpression)expression;
            String name = nameExpression.getName().getPathName();
            List potentialReferences = NameResolutionUtils.getNamedElements((String)name, (Element)scope, null);
            NamedElement reference = null;
            if (potentialReferences.size() >= 1) {
                reference = (NamedElement)potentialReferences.get(0);
                references.add(reference);
            }
        }
        return references;
    }
}

