/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.properties;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.domain.services.EMFUtils;
import org.eclipse.papyrus.uml.domain.services.properties.ILogger;

public class PropertiesUMLReferenceTypeServices {
    private static final String E_TYPE = "eType";
    private static final String DUPLICATES = "duplicates";
    private static final String KEY_ELEMENTS_SEPARATOR = ":";
    private final ILogger logger;
    private Map<String, String> redefinedReferenceTypes;

    public PropertiesUMLReferenceTypeServices(ILogger logger) {
        this.logger = logger;
    }

    public void initRedefinedTypes(EPackage uml2EPackage) {
        this.redefinedReferenceTypes = new HashMap<String, String>();
        List<EClass> classes = EMFUtils.allContainedObjectOfType((Notifier)uml2EPackage, EClass.class).filter(e -> !e.isInterface() && !e.isAbstract()).toList();
        classes.stream().forEach(c -> {
            this.registerEntry((EClass)c, (EClass)c);
            for (EClass superC : c.getEAllSuperTypes()) {
                this.registerEntry((EClass)c, superC);
            }
        });
    }

    private void registerEntry(EClass clazz, EClass annotationContainerClass) {
        List<EAnnotation> annotations = this.getRedefinedAnnotations(annotationContainerClass);
        for (EAnnotation anno : annotations) {
            String overridenType = (String)anno.getDetails().get((Object)E_TYPE);
            String key = clazz.getName() + KEY_ELEMENTS_SEPARATOR + anno.getSource();
            if (this.redefinedReferenceTypes.containsKey(key)) continue;
            this.redefinedReferenceTypes.put(key, overridenType);
        }
    }

    private List<EAnnotation> getRedefinedAnnotations(EClass clazz) {
        return clazz.getEAnnotations().stream().filter(anno -> DUPLICATES.equals(anno.getSource())).flatMap(a -> a.getEAnnotations().stream()).filter(a -> a.getDetails().get((Object)E_TYPE) != null).toList();
    }

    private Optional<String> findRedefinedReferenceType(EClass clazz, String featureName) {
        return Optional.ofNullable(this.redefinedReferenceTypes.get(clazz.getName() + KEY_ELEMENTS_SEPARATOR + featureName));
    }

    public String getFeatureTypeQualifiedName(EObject self, String featureName) {
        if (this.redefinedReferenceTypes == null) {
            throw new IllegalStateException("The 'PropertiesUMLRedefinedReferenceTypeServices::init()' method should be called before requesting reference type.");
        }
        Optional<String> optionalType = this.findRedefinedReferenceType(self.eClass(), featureName);
        if (optionalType.isEmpty()) {
            Object res = "";
            EStructuralFeature feature = self.eClass().getEStructuralFeature(featureName);
            if (feature != null) {
                EClassifier type = feature.getEType();
                if (type != null) {
                    res = type.getEPackage().getName() + "::" + type.getName();
                } else {
                    this.logger.log(MessageFormat.format("Unable to get the type of feature ''{0}'' in ''{1}''", featureName, self.eClass().getName()), ILogger.ILogLevel.ERROR);
                }
            } else {
                this.logger.log(MessageFormat.format("''{0}'' is not a feature of class ''{1}''", featureName, self.eClass().getName()), ILogger.ILogLevel.ERROR);
            }
            return res;
        }
        return optionalType.get();
    }
}

