/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.drop.IExternalSourceToRepresentationDropChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class SequenceExternalSourceToRepresentationDropChecker
implements IExternalSourceToRepresentationDropChecker {
    @Override
    public CheckStatus canDragAndDrop(EObject elementToDrop, EObject newSemanticContainer) {
        return (CheckStatus)new SequenceDropInsideRepresentationCheckerSwitch(newSemanticContainer).doSwitch(elementToDrop);
    }

    static class SequenceDropInsideRepresentationCheckerSwitch
    extends UMLSwitch<CheckStatus> {
        private final EObject target;

        SequenceDropInsideRepresentationCheckerSwitch(EObject target) {
            this.target = target;
        }

        public CheckStatus caseProperty(Property property) {
            CheckStatus result = this.target instanceof Lifeline || this.target instanceof Interaction ? CheckStatus.YES : CheckStatus.no("Property can only be drag and drop on an Interaction or a Lifeline.");
            return result;
        }

        public CheckStatus caseType(Type type) {
            CheckStatus result = this.target instanceof Lifeline || this.target instanceof Interaction ? CheckStatus.YES : CheckStatus.no("Type can only be drag and drop on an Interaction or a Lifeline.");
            return result;
        }

        public CheckStatus defaultCase(EObject object) {
            return CheckStatus.no("DnD is not authorized.");
        }
    }
}

