/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.drop.DnDStatus;
import org.eclipse.papyrus.uml.domain.services.drop.IExternalSourceToRepresentationDropBehaviorProvider;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityGroup;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.ExpansionNode;
import org.eclipse.uml2.uml.ExpansionRegion;
import org.eclipse.uml2.uml.InterruptibleActivityRegion;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ActivityExternalSourceToRepresentationDropBehaviorProvider
implements IExternalSourceToRepresentationDropBehaviorProvider {
    @Override
    public DnDStatus drop(EObject droppedElement, EObject target, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
        return (DnDStatus)new ActivityDropInsideRepresentationBehaviorProviderSwitch(target).doSwitch(droppedElement);
    }

    static class ActivityDropInsideRepresentationBehaviorProviderSwitch
    extends UMLSwitch<DnDStatus> {
        private final EObject target;

        ActivityDropInsideRepresentationBehaviorProviderSwitch(EObject target) {
            this.target = target;
        }

        public DnDStatus caseActivity(Activity activity) {
            if (this.target instanceof Activity) {
                return DnDStatus.createNothingStatus(Set.of(activity));
            }
            return (DnDStatus)super.caseActivity(activity);
        }

        public DnDStatus caseActivityEdge(ActivityEdge activityEdge) {
            return DnDStatus.createNothingStatus(Set.of(activityEdge));
        }

        public DnDStatus caseActivityNode(ActivityNode activityNode) {
            if (this.target instanceof Activity || this.target instanceof ActivityGroup) {
                return DnDStatus.createNothingStatus(Set.of(activityNode));
            }
            return (DnDStatus)super.caseActivityNode(activityNode);
        }

        public DnDStatus caseActivityParameterNode(ActivityParameterNode activityParameterNode) {
            if (this.target instanceof Activity) {
                return DnDStatus.createNothingStatus(Set.of(activityParameterNode));
            }
            return DnDStatus.createFailingStatus("ActivityParameterNode can only be drag and drop on an Activity.", Collections.emptySet());
        }

        public DnDStatus caseActivityPartition(ActivityPartition activityPartition) {
            if (this.target instanceof Activity || this.target instanceof ActivityPartition) {
                return DnDStatus.createNothingStatus(Set.of(activityPartition));
            }
            return (DnDStatus)super.caseActivityPartition(activityPartition);
        }

        public DnDStatus caseComment(Comment comment) {
            if (this.target instanceof Activity || this.target instanceof ActivityGroup) {
                return DnDStatus.createNothingStatus(Set.of(comment));
            }
            return (DnDStatus)super.caseComment(comment);
        }

        public DnDStatus caseConstraint(Constraint constraint) {
            if (this.target instanceof Activity || this.target instanceof StructuredActivityNode) {
                return DnDStatus.createNothingStatus(Set.of(constraint));
            }
            return (DnDStatus)super.caseConstraint(constraint);
        }

        public DnDStatus caseExpansionNode(ExpansionNode expansionNode) {
            if (this.target instanceof ExpansionRegion) {
                return DnDStatus.createNothingStatus(Set.of(expansionNode));
            }
            return DnDStatus.createFailingStatus("ExpansionNode can only be drag and drop on an ExpansionRegion.", Collections.emptySet());
        }

        public DnDStatus caseInterruptibleActivityRegion(InterruptibleActivityRegion interruptibleActivityRegion) {
            if (this.target instanceof Activity) {
                return DnDStatus.createNothingStatus(Set.of(interruptibleActivityRegion));
            }
            return (DnDStatus)super.caseInterruptibleActivityRegion(interruptibleActivityRegion);
        }

        public DnDStatus defaultCase(EObject object) {
            return DnDStatus.createFailingStatus("DnD is forbidden.", Collections.emptySet());
        }
    }
}

