/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.graphics.Image;

public class SelectorDialogTabReader
extends RegistryReader {
    private static final String CONSTRAINT_ATTRIBUTE = "tabConstraint";
    private static final String CONTENT_PROVIDER_ATTRIBUTE = "contentProvider";
    private static final String TAB_ICON_ATTRIBUTE = "tabIcon";
    private static final String LABEL_PROVIDER_ATTRIBUTE = "labelProvider";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String TAB_LABEL_ATTRIBUTE = "tabLabel";
    private static final String ID_ATTRIBUTE = "id";
    private static volatile SelectorDialogTabReader ourInstance = null;
    private static final String EXT_PT = "selectorDialogTab";
    private static final String TAB_DECLARATION = "tabDeclaration";
    private List<String> ids = new ArrayList<String>();
    private Map<String, String> tabNames = new HashMap<String, String>();
    private Map<String, Image> tabIcons = new HashMap<String, Image>();
    private Map<String, String> descriptions = new HashMap<String, String>();
    private Map<String, ILabelProvider> labelProviders = new HashMap<String, ILabelProvider>();
    private Map<String, ITreeContentProvider> contentProviders = new HashMap<String, ITreeContentProvider>();
    private Map<String, Constraint> constraints = new HashMap<String, Constraint>();

    public Map<String, ILabelProvider> getLabelProviders() {
        return this.labelProviders;
    }

    public Map<String, ITreeContentProvider> getContentProviders() {
        return this.contentProviders;
    }

    public Map<String, String> getDescriptions() {
        return this.descriptions;
    }

    public Map<String, String> getTabNames() {
        return this.tabNames;
    }

    public Map<String, Image> getTabIcons() {
        return this.tabIcons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final SelectorDialogTabReader getInstance() {
        if (ourInstance != null) return ourInstance;
        Class<SelectorDialogTabReader> clazz = SelectorDialogTabReader.class;
        synchronized (SelectorDialogTabReader.class) {
            if (ourInstance != null) return ourInstance;
            ourInstance = new SelectorDialogTabReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourInstance;
        }
    }

    private SelectorDialogTabReader() {
        super(Platform.getExtensionRegistry(), "org.eclipse.papyrus.infra.widgets", EXT_PT);
        this.readRegistry();
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (!TAB_DECLARATION.equals(element.getName())) {
            return false;
        }
        String id = element.getAttribute(ID_ATTRIBUTE);
        if (!SelectorDialogTabReader.checkNotEmpty(id)) {
            this.logMissingAttribute(element, ID_ATTRIBUTE);
            return false;
        }
        if (add) {
            String tabName = element.getAttribute(TAB_LABEL_ATTRIBUTE);
            if (!SelectorDialogTabReader.checkNotEmpty(tabName)) {
                this.logMissingAttribute(element, TAB_LABEL_ATTRIBUTE);
                return false;
            }
            String description = element.getAttribute(DESCRIPTION_ATTRIBUTE);
            String labelProviderName = element.getAttribute(LABEL_PROVIDER_ATTRIBUTE);
            if (!SelectorDialogTabReader.checkNotEmpty(labelProviderName)) {
                this.logMissingAttribute(element, LABEL_PROVIDER_ATTRIBUTE);
                return false;
            }
            String iconPath = element.getAttribute(TAB_ICON_ATTRIBUTE);
            Image icon = null;
            if (SelectorDialogTabReader.checkNotEmpty(iconPath)) {
                icon = Activator.getDefault().getImage(element.getContributor().getName(), iconPath);
            }
            ILabelProvider labelProvider = null;
            try {
                labelProvider = (ILabelProvider)element.createExecutableExtension(LABEL_PROVIDER_ATTRIBUTE);
            }
            catch (CoreException e) {
                this.logError(element, "Failed to instantiate label provider");
                return false;
            }
            String contentProviderName = element.getAttribute(CONTENT_PROVIDER_ATTRIBUTE);
            if (!SelectorDialogTabReader.checkNotEmpty(contentProviderName)) {
                this.logMissingAttribute(element, CONTENT_PROVIDER_ATTRIBUTE);
                return false;
            }
            ITreeContentProvider contentProvider = null;
            try {
                contentProvider = (ITreeContentProvider)element.createExecutableExtension(CONTENT_PROVIDER_ATTRIBUTE);
            }
            catch (CoreException e) {
                this.logError(element, "Failed to instantiate content provider");
                return false;
            }
            String tabConstraintName = element.getAttribute(CONSTRAINT_ATTRIBUTE);
            Constraint constraint = null;
            if (SelectorDialogTabReader.checkNotEmpty(tabConstraintName)) {
                try {
                    constraint = (Constraint)element.createExecutableExtension(CONSTRAINT_ATTRIBUTE);
                }
                catch (CoreException e) {
                    this.logError(element, "Failed to instantiate constraint");
                    return false;
                }
            }
            this.addTabContribution(id, tabName, icon, description, labelProvider, contentProvider, constraint);
        } else {
            this.removeTabContribution(id);
        }
        return true;
    }

    protected void addTabContribution(String id, String tabName, Image icon, String description, ILabelProvider labelProvider, ITreeContentProvider contentProvider, Constraint constraint) {
        this.ids.add(id);
        this.tabNames.put(id, tabName);
        if (icon != null) {
            this.tabIcons.put(id, icon);
        }
        if (description != null) {
            this.descriptions.put(id, description);
        }
        this.labelProviders.put(id, labelProvider);
        this.contentProviders.put(id, contentProvider);
        if (constraint != null) {
            this.getConstraints().put(id, constraint);
        }
    }

    protected void removeTabContribution(String id) {
        this.tabNames.remove(id);
        this.descriptions.remove(id);
        this.labelProviders.remove(id);
        this.contentProviders.remove(id);
        this.ids.remove(id);
    }

    private static boolean checkNotEmpty(String attribute) {
        return attribute != null && attribute.length() != 0;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public Map<String, Constraint> getConstraints() {
        return this.constraints;
    }
}

