/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.ui.providers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.model.ISubResourceFile;
import org.eclipse.papyrus.infra.ui.util.PapyrusImageUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class PapyrusLabelProvider
implements ILabelProvider {
    private ImageRegistry images = new ImageRegistry(JFaceResources.getResources());

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.images.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        if (element instanceof IPapyrusFile) {
            return PapyrusImageUtils.getDefaultIcon();
        }
        if (element instanceof ISubResourceFile) {
            IFile file = ((ISubResourceFile)element).getFile();
            String ext = file.getFileExtension();
            Image image = this.images.get(ext);
            if (image == null) {
                ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(file.getName());
                this.images.put(ext, desc);
            }
            return this.images.get(ext);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IPapyrusFile) {
            IPapyrusFile papyFile = (IPapyrusFile)element;
            return papyFile.getText();
        }
        if (element instanceof ISubResourceFile) {
            return ((ISubResourceFile)element).getText();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getName();
        }
        return null;
    }
}

