/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.internal.export.image;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.image.ImageExporter;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.export.image.ImageFormat;
import org.eclipse.papyrus.infra.nattable.export.streamprovider.PapyrusFileOutputStreamProvider;
import org.eclipse.papyrus.infra.nattable.style.configattribute.PapyrusExportConfigAttributes;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class PapyrusImageExporter
extends ImageExporter {
    private Boolean usePapyrusExportTableDialog = Boolean.TRUE;
    private String currentImageName = null;
    private IOutputStreamProvider outputStreamProvider = null;
    private static final String DEFAULT_IMAGE_NAME = "table_export.png";

    public PapyrusImageExporter() {
        this((IOutputStreamProvider)new PapyrusFileOutputStreamProvider(DEFAULT_IMAGE_NAME, ImageFormat.IMAGE_FILTER_NAME_LIST, ImageFormat.IMAGE_FILTER_EXTENSION_LIST));
    }

    public PapyrusImageExporter(IOutputStreamProvider outputStreamProvider) {
        super(outputStreamProvider);
        this.outputStreamProvider = outputStreamProvider;
    }

    public void exportTable(Shell shell, ProgressBar progressBar, OutputStream outputStream, ILayer layer, IConfigRegistry configRegistry) throws IOException {
        if (shell == null || layer == null || configRegistry == null) {
            throw new IllegalArgumentException("Shell, layer or configure registry must not be null");
        }
        this.usePapyrusExportTableDialog = (Boolean)configRegistry.getConfigAttribute(PapyrusExportConfigAttributes.EXPORT_IMAGE_USE_PAPYRUS_EXPORT_TABLE_DIALOG, DisplayMode.NORMAL, new String[0]);
        if (this.usePapyrusExportTableDialog.booleanValue()) {
            super.exportTable(shell, progressBar, outputStream, layer, configRegistry);
        } else {
            ImageFormat imageFormat = (ImageFormat)((Object)configRegistry.getConfigAttribute(PapyrusExportConfigAttributes.EXPORT_IMAGE_FORMAT, DisplayMode.NORMAL, new String[0]));
            this.currentImageName = (String)configRegistry.getConfigAttribute(PapyrusExportConfigAttributes.EXPORT_IMAGE_FILENAME, DisplayMode.NORMAL, new String[0]);
            String imageFormatExtension = imageFormat.getImageFilterExtension();
            if (this.currentImageName != null && imageFormatExtension != null) {
                int imageFormatIndex = this.getImageFormatIndex(imageFormatExtension);
                int width = layer.getWidth();
                int height = layer.getHeight();
                Image image = new Image((Device)shell.getDisplay(), width, height);
                GC gc = new GC((Drawable)image);
                Rectangle layerBounds = new Rectangle(0, 0, width, height);
                layer.getLayerPainter().paintLayer(layer, gc, 0, 0, layerBounds, configRegistry);
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{image.getImageData()};
                try {
                    try {
                        imageLoader.save(this.currentImageName, imageFormatIndex);
                    }
                    catch (IllegalArgumentException e) {
                        Activator.log.error((Throwable)e);
                        gc.dispose();
                        image.dispose();
                    }
                    catch (SWTException e) {
                        Activator.log.error((Throwable)e);
                        gc.dispose();
                        image.dispose();
                    }
                }
                finally {
                    gc.dispose();
                    image.dispose();
                }
            }
        }
    }

    public Object getResult() {
        if (this.usePapyrusExportTableDialog.booleanValue()) {
            return super.getResult();
        }
        return this.currentImageName != null ? new File(this.currentImageName) : null;
    }

    public IOutputStreamProvider getOutputStreamProvider() {
        return this.outputStreamProvider;
    }
}

