/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.catalog;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DirectionKind implements Enumerator
{
    IN(0, "in", "in"),
    INOUT(1, "inout", "inout"),
    OUT(2, "out", "out");

    public static final int IN_VALUE = 0;
    public static final int INOUT_VALUE = 1;
    public static final int OUT_VALUE = 2;
    private static final DirectionKind[] VALUES_ARRAY;
    public static final List<DirectionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DirectionKind[]{IN, INOUT, OUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DirectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DirectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DirectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DirectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DirectionKind get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return INOUT;
            }
            case 2: {
                return OUT;
            }
        }
        return null;
    }

    private DirectionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

