/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMInstruction;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.ASMParameter;
import org.eclipse.m2m.atl.engine.vm.ExecEnv;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclSimpleType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;

public class ASMStackFrame
extends StackFrame {
    public static ASMOclType myType = new ASMOclSimpleType("ASMStackFrame", StackFrame.myType);
    private Map localVariables = new HashMap();
    private Stack localStack;
    private int location;

    public ASMStackFrame(ExecEnv execEnv, ASMOperation operation, List args) {
        super(myType, execEnv, operation, args);
        Iterator j = args.iterator();
        this.localVariables.put("0", j.next());
        for (ASMParameter p : operation.getParameters()) {
            if (!j.hasNext()) {
                this.printStackTrace("Too few arguments");
            }
            this.localVariables.put(p.getName(), j.next());
        }
        if (j.hasNext()) {
            this.printStackTrace("Too many arguments");
        }
        this.localStack = new Stack();
        this.location = -1;
    }

    public static ASMStackFrame rootFrame(ASMExecEnv execEnv, ASMOperation operation, List args) {
        ASMStackFrame ret = new ASMStackFrame(execEnv, operation, args);
        execEnv.push(ret);
        execEnv.getDebugger().enter(ret);
        return ret;
    }

    @Override
    public ASMOclAny leaveFrame() {
        super.leaveFrame();
        ASMOclAny ret = null;
        this.getExecEnv().pop();
        if (!this.empty()) {
            ret = this.pop();
        }
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ASMOperation op = (ASMOperation)this.getOperation();
        ret.append("\tat ");
        ret.append(this.getOperation());
        ret.append("#" + this.getLocation());
        ret.append('(');
        ret.append(String.valueOf(op.getASM().getName()) + ".atl");
        String location = op.resolveLineNumber(this.getLocation());
        if (location != null && location.matches("[0-9]*:[0-9]*-[0-9]*:[0-9]*")) {
            ret.append(String.valueOf('[') + location + ']');
        }
        ret.append(")");
        ret.append("\n\t\tlocal variables = {");
        Iterator i = this.localVariables.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            ret.append(op.resolveVariableName(Integer.parseInt(key), this.getLocation()));
            ret.append("=");
            ret.append(this.localVariables.get(key));
            if (!i.hasNext()) continue;
            ret.append(", ");
        }
        ret.append("}\n\t\tlocal stack = ");
        ret.append(this.localStack);
        return ret.toString();
    }

    public void push(ASMOclAny value) {
        this.localStack.push(value);
    }

    public ASMOclAny pop() {
        return (ASMOclAny)this.localStack.pop();
    }

    public ASMOclAny peek() {
        return (ASMOclAny)this.localStack.peek();
    }

    public boolean empty() {
        return this.localStack.empty();
    }

    public void setVariable(String name, ASMOclAny value) {
        this.localVariables.put(name, value);
    }

    public ASMOclAny getVariable(String name) {
        ASMOclAny ret = (ASMOclAny)this.localVariables.get(name);
        if (ret == null) {
            ret = this.getExecEnv().getVariable(name);
        }
        return ret;
    }

    public void pushVariable(String name) {
        this.push(this.getVariable(name));
    }

    public void popVariable(String name) {
        this.setVariable(name, this.pop());
    }

    public boolean hasNextInstruction() {
        return this.location + 1 < ((ASMOperation)this.getOperation()).getInstructions().size();
    }

    public ASMInstruction nextInstruction() {
        return (ASMInstruction)((ASMOperation)this.getOperation()).getInstructions().get(++this.location);
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location;
    }

    public void step() {
        this.debugger.step(this);
    }

    public Map getLocalVariables() {
        HashMap<String, Stack> ret = new HashMap<String, Stack>(this.localVariables);
        ret.put("_stack", this.localStack);
        return ret;
    }

    public List getLocalStack() {
        return this.localStack;
    }

    public String resolveVariableName(int slot) {
        return ((ASMOperation)this.getOperation()).resolveVariableName(slot, this.location);
    }

    public String getSourceLocation() {
        return ((ASMOperation)this.getOperation()).resolveLineNumber(this.location);
    }
}

