/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.LocalVariable;
import org.eclipse.m2m.atl.emftvm.LocalVariableInstruction;
import org.eclipse.m2m.atl.emftvm.impl.InstructionImpl;

public abstract class LocalVariableInstructionImpl
extends InstructionImpl
implements LocalVariableInstruction {
    protected static final int CB_OFFSET_EDEFAULT = -1;
    protected static final int SLOT_EDEFAULT = -1;
    protected static final int LOCAL_VARIABLE_INDEX_EDEFAULT = -1;
    protected int cbOffset = -1;
    protected int localVariableIndex = -1;
    protected int slot = -1;
    protected LocalVariable localVariable;

    protected LocalVariableInstructionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return EmftvmPackage.Literals.LOCAL_VARIABLE_INSTRUCTION;
    }

    @Override
    public int getCbOffset() {
        CodeBlock lvBlock;
        LocalVariable lv;
        if (this.cbOffset == -1 && (lv = this.getLocalVariable()) != null && (lvBlock = lv.getOwningBlock()) != null) {
            CodeBlock cb = this.getOwningBlock();
            int offset = 0;
            while (cb != null && lvBlock != cb) {
                cb = cb.getNestedFor();
                ++offset;
            }
            if (cb == lvBlock) {
                this.cbOffset = offset;
            } else {
                throw new IllegalArgumentException(String.format("Referred local variable %s::%s not reachable from %s::%s", lvBlock, lv, this.getOwningBlock(), super.toString()));
            }
        }
        return this.cbOffset;
    }

    @Override
    public void setCbOffset(int newCbOffset) {
        int oldCbOffset = this.cbOffset;
        this.cbOffset = newCbOffset;
        if (newCbOffset != -1) {
            this.localVariable = null;
        }
        this.slot = -1;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldCbOffset, this.cbOffset));
        }
    }

    @Override
    public int getSlot() {
        LocalVariable lv;
        if (this.slot == -1 && (lv = this.getLocalVariable()) != null) {
            this.slot = lv.getSlot();
        }
        return this.slot;
    }

    @Override
    public int getLocalVariableIndex() {
        CodeBlock lvBlock;
        LocalVariable lv;
        if (this.localVariableIndex == -1 && (lv = this.getLocalVariable()) != null && (lvBlock = lv.getOwningBlock()) != null) {
            this.localVariableIndex = lvBlock.getLocalVariables().indexOf((Object)lv);
            assert (this.localVariableIndex > -1);
        }
        return this.localVariableIndex;
    }

    @Override
    public void setLocalVariableIndex(int newLocalVariableIndex) {
        int oldLocalVariableIndex = this.localVariableIndex;
        this.localVariableIndex = newLocalVariableIndex;
        if (newLocalVariableIndex != -1) {
            this.localVariable = null;
        }
        this.slot = -1;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldLocalVariableIndex, this.localVariableIndex));
        }
    }

    @Override
    public LocalVariable getLocalVariable() {
        CodeBlock cb;
        if (this.localVariable == null && this.cbOffset != -1 && this.localVariableIndex != -1 && (cb = this.getOwningBlock()) != null) {
            int index = cb.getCode().indexOf((Object)this);
            assert (index > -1);
            CodeBlock lvBlock = cb;
            int i = 0;
            while (i < this.cbOffset) {
                if ((lvBlock = lvBlock.getNestedFor()) == null) {
                    throw new IllegalArgumentException(String.format("Code block of referred local variable at (cbOffset = %d, index = %d) not found for %s::%s", this.cbOffset, this.localVariableIndex, cb, super.toString()));
                }
                ++i;
            }
            this.localVariable = (LocalVariable)lvBlock.getLocalVariables().get(this.localVariableIndex);
            if (this.localVariable == null) {
                throw new IllegalArgumentException(String.format("Referred local variable at (cbOffset = %d, index = %d) not found for %s::%s", this.cbOffset, this.localVariableIndex, cb, super.toString()));
            }
        }
        if (this.localVariable != null && this.localVariable.eIsProxy()) {
            InternalEObject oldLocalVariable = (InternalEObject)this.localVariable;
            this.localVariable = (LocalVariable)this.eResolveProxy(oldLocalVariable);
            if (this.localVariable != oldLocalVariable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 9, (Object)oldLocalVariable, (Object)this.localVariable));
            }
        }
        return this.localVariable;
    }

    public LocalVariable basicGetLocalVariable() {
        CodeBlock cb;
        if (this.localVariable == null && this.cbOffset != -1 && this.localVariableIndex != -1 && (cb = this.getOwningBlock()) != null) {
            int index = cb.getCode().indexOf((Object)this);
            assert (index > -1);
            CodeBlock lvBlock = cb;
            int i = 0;
            while (i < this.cbOffset) {
                if ((lvBlock = lvBlock.getNestedFor()) == null) {
                    throw new IllegalArgumentException(String.format("Code block of referred local variable at (cbOffset = %d, index = %d) not found for %s::%s", this.cbOffset, this.localVariableIndex, cb, this));
                }
                ++i;
            }
            this.localVariable = (LocalVariable)lvBlock.getLocalVariables().get(this.localVariableIndex);
            if (this.localVariable == null) {
                throw new IllegalArgumentException(String.format("Referred local variable at (cbOffset = %d, index = %d) not found for %s::%s", this.cbOffset, this.localVariableIndex, cb, this));
            }
        }
        return this.localVariable;
    }

    @Override
    public void setLocalVariable(LocalVariable newLocalVariable) {
        LocalVariable oldLocalVariable = this.localVariable;
        this.localVariable = newLocalVariable;
        if (this.localVariable != null) {
            this.cbOffset = -1;
            this.localVariableIndex = -1;
        }
        this.slot = -1;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldLocalVariable, (Object)this.localVariable));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getCbOffset();
            }
            case 7: {
                return this.getSlot();
            }
            case 8: {
                return this.getLocalVariableIndex();
            }
            case 9: {
                if (resolve) {
                    return this.getLocalVariable();
                }
                return this.basicGetLocalVariable();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setCbOffset((Integer)newValue);
                return;
            }
            case 8: {
                this.setLocalVariableIndex((Integer)newValue);
                return;
            }
            case 9: {
                this.setLocalVariable((LocalVariable)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setCbOffset(-1);
                return;
            }
            case 8: {
                this.setLocalVariableIndex(-1);
                return;
            }
            case 9: {
                this.setLocalVariable(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return this.getCbOffset() != -1;
            }
            case 7: {
                return this.getSlot() != -1;
            }
            case 8: {
                return this.getLocalVariableIndex() != -1;
            }
            case 9: {
                return this.basicGetLocalVariable() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void eNotify(Notification notification) {
        super.eNotify(notification);
        switch (notification.getFeatureID(null)) {
            case 2: {
                this.setCbOffset(-1);
                this.setLocalVariableIndex(-1);
            }
        }
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(' ');
        result.append(this.getCbOffset());
        result.append(", ");
        result.append(this.getSlot());
        result.append(" (");
        result.append(this.getLocalVariable());
        result.append(')');
        return result.toString();
    }
}

