/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;

public final class CollectRequest {
    private Artifact rootArtifact;
    private Dependency root;
    private List<Dependency> dependencies = Collections.emptyList();
    private List<Dependency> managedDependencies = Collections.emptyList();
    private List<ArtifactRepository> repositories = Collections.emptyList();

    public CollectRequest() {
    }

    public CollectRequest(Dependency root, List<ArtifactRepository> repositories) {
        this.setRoot(root);
        this.setRepositories(repositories);
    }

    public CollectRequest(Dependency root, List<Dependency> dependencies, List<ArtifactRepository> repositories) {
        this.setRoot(root);
        this.setDependencies(dependencies);
        this.setRepositories(repositories);
    }

    public CollectRequest(List<Dependency> dependencies, List<Dependency> managedDependencies, List<ArtifactRepository> repositories) {
        this.setDependencies(dependencies);
        this.setManagedDependencies(managedDependencies);
        this.setRepositories(repositories);
    }

    public Artifact getRootArtifact() {
        return this.rootArtifact;
    }

    public CollectRequest setRootArtifact(Artifact rootArtifact) {
        this.rootArtifact = rootArtifact;
        return this;
    }

    public Dependency getRoot() {
        return this.root;
    }

    public CollectRequest setRoot(Dependency root) {
        this.root = root;
        return this;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public CollectRequest setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies == null ? Collections.emptyList() : dependencies;
        return this;
    }

    public CollectRequest addDependency(Dependency dependency) {
        if (dependency != null) {
            if (this.dependencies.isEmpty()) {
                this.dependencies = new ArrayList<Dependency>();
            }
            this.dependencies.add(dependency);
        }
        return this;
    }

    public List<Dependency> getManagedDependencies() {
        return this.managedDependencies;
    }

    public CollectRequest setManagedDependencies(List<Dependency> managedDependencies) {
        this.managedDependencies = managedDependencies == null ? Collections.emptyList() : managedDependencies;
        return this;
    }

    public CollectRequest addManagedDependency(Dependency managedDependency) {
        if (managedDependency != null) {
            if (this.managedDependencies.isEmpty()) {
                this.managedDependencies = new ArrayList<Dependency>();
            }
            this.managedDependencies.add(managedDependency);
        }
        return this;
    }

    public List<ArtifactRepository> getRepositories() {
        return this.repositories;
    }

    public CollectRequest setRepositories(List<ArtifactRepository> repositories) {
        this.repositories = repositories == null ? Collections.emptyList() : repositories;
        return this;
    }

    public CollectRequest addRepository(ArtifactRepository repository) {
        if (repository != null) {
            if (this.repositories.isEmpty()) {
                this.repositories = new ArrayList<ArtifactRepository>();
            }
            this.repositories.add(repository);
        }
        return this;
    }

    public String toString() {
        return this.getRoot() + " -> " + this.getDependencies() + " < " + this.getRepositories();
    }
}

