/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IDOM;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IJavaWebServiceElement;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.util.DomSwitch;

public class DomUtil {
    public static final DomUtil INSTANCE = new DomUtil();
    private final DomSwitch<String> implSwitch = this.createImplFinderSwitch();

    public void setFeatureValue(EObject object, int featureId, Object value) {
        EStructuralFeature feature = object.eClass().getEStructuralFeature(featureId);
        object.eSet(feature, value);
    }

    public Object getFeatureValue(EObject object, int featureId) {
        EStructuralFeature feature = object.eClass().getEStructuralFeature(featureId);
        return object.eGet(feature);
    }

    public void addToCollectionFeature(EObject object, int featureId, Object value) {
        Collection oldValue = (Collection)this.getFeatureValue(object, featureId);
        oldValue.add(value);
    }

    public IWebServiceProject findProjectByName(IDOM dom, String name) {
        for (IWebServiceProject wsProject : dom.getWebServiceProjects()) {
            if (!wsProject.getName().equals(name)) continue;
            return wsProject;
        }
        return null;
    }

    public IWebService findWsByImplName(IWebServiceProject wsProject, String name) {
        for (IWebService ws : wsProject.getWebServices()) {
            if (!ws.getImplementation().equals(name)) continue;
            return ws;
        }
        return null;
    }

    public IServiceEndpointInterface findSeiByImplName(IWebServiceProject wsProject, String name) {
        for (IServiceEndpointInterface sei : wsProject.getServiceEndpointInterfaces()) {
            if (!sei.getImplementation().equals(name)) continue;
            return sei;
        }
        return null;
    }

    public IWebMethod findWebMethodByImpl(IServiceEndpointInterface sei, String impl) {
        for (IWebMethod wm : sei.getWebMethods()) {
            if (!wm.getImplementation().equals(impl)) continue;
            return wm;
        }
        return null;
    }

    public IMethod findMethod(IType seiType, IWebMethod webMethod) throws JavaModelException {
        IMethod[] iMethodArray = seiType.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (webMethod.getImplementation().equals(this.calcImplementation(method))) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public IJavaWebServiceElement findJavaWebServiceElemByImplName(IWebServiceProject wsProject, String name) {
        IWebService ws = this.findWsByImplName(wsProject, name);
        return ws == null ? this.findSeiByImplName(wsProject, name) : ws;
    }

    public String calcImplementation(IMethod method) throws JavaModelException {
        return String.valueOf(method.getElementName()) + method.getSignature();
    }

    public IWebServiceProject findWsProject(EObject eObject) {
        EObject parent = eObject;
        while (parent != null) {
            if (parent instanceof IWebServiceProject) {
                return (IWebServiceProject)parent;
            }
            parent = parent.eContainer();
        }
        return null;
    }

    public boolean isOutsideInWebService(IServiceEndpointInterface sei) {
        if (sei == null) {
            return false;
        }
        for (IWebService webService : sei.getImplementingWebServices()) {
            if (webService.getWsdlLocation() == null) continue;
            return true;
        }
        return false;
    }

    public String calcUniqueImpl(EObject eObject) {
        if (eObject.eClass().getClassifierID() == 4) {
            IWebParam wp = (IWebParam)eObject;
            return String.valueOf(((IWebMethod)wp.eContainer()).getImplementation()) + "[" + wp.getImplementation() + "]";
        }
        return this.extractImplementation(eObject);
    }

    public String extractImplementation(EObject eObject) {
        return this.implSwitch.doSwitch(eObject);
    }

    private DomSwitch<String> createImplFinderSwitch() {
        return new DomSwitch<String>(){

            @Override
            public String caseIWebService(IWebService ws) {
                return ws.getImplementation();
            }

            @Override
            public String caseIServiceEndpointInterface(IServiceEndpointInterface sei) {
                return sei.getImplementation();
            }

            @Override
            public String caseIWebMethod(IWebMethod wm) {
                return wm.getImplementation();
            }

            @Override
            public String caseIWebParam(IWebParam wp) {
                return wp.getImplementation();
            }

            @Override
            public String caseIWebServiceProject(IWebServiceProject wsProject) {
                return wsProject.getName();
            }
        };
    }
}

