/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.internal.validation.FragmentValidationTools;
import org.eclipse.jst.jsp.core.internal.validation.HTMLValidationReporter;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.wst.html.core.internal.validate.HTMLValidationAdapterFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.validate.ValidationAdapter;
import org.eclipse.wst.sse.core.internal.validate.ValidationReporter;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.validation.eclipse.Validator;
import org.w3c.dom.Element;

public class JSPContentValidator
extends JSPValidator {
    private static final String HTTP_JAVA_SUN_COM_JSP_PAGE = "http://java.sun.com/JSP/Page";
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_JSP = "xmlns:jsp";
    private IContentType fJSPFContentType = null;

    private boolean fragmentCheck(IFile file) {
        boolean shouldValidateFragments;
        boolean shouldValidate = true;
        if (this.getJSPFContentType().isAssociatedWith(file.getName()) && !(shouldValidateFragments = FragmentValidationTools.shouldValidateFragment((IResource)file))) {
            boolean isFragment = this.isFragment(file);
            shouldValidate = !isFragment;
        }
        return shouldValidate;
    }

    private IContentType getJSPFContentType() {
        if (this.fJSPFContentType == null) {
            this.fJSPFContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT);
        }
        return this.fJSPFContentType;
    }

    private HTMLValidationReporter getReporter(IReporter reporter, IFile file, IDOMModel model) {
        return new HTMLValidationReporter((IValidator)this, reporter, file, (IStructuredModel)model);
    }

    private boolean hasHTMLFeature(IDOMDocument document) {
        DocumentTypeAdapter adapter = (DocumentTypeAdapter)document.getAdapterFor(DocumentTypeAdapter.class);
        if (adapter == null) {
            return false;
        }
        return adapter.hasFeature("HTML");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFragment(IFile file) {
        boolean isFragment = false;
        InputStream is = null;
        try {
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription == null) {
                is = file.getContents();
                contentDescription = Platform.getContentTypeManager().getDescriptionFor(is, file.getName(), new QualifiedName[]{IContentDescription.CHARSET});
            }
            if (contentDescription != null) {
                String fileCtId = contentDescription.getContentType().getId();
                isFragment = fileCtId != null && ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT.equals(fileCtId);
            }
        }
        catch (IOException iOException) {
            if (is == null) return isFragment;
            try {
                is.close();
                return isFragment;
            }
            catch (Exception exception) {}
            return isFragment;
        }
        catch (CoreException coreException) {
            try {
                if (is == null) return isFragment;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                is.close();
                return isFragment;
            }
            catch (Exception exception) {}
            return isFragment;
        }
        if (is == null) return isFragment;
        try {
            is.close();
            return isFragment;
        }
        catch (Exception exception) {}
        return isFragment;
    }

    private boolean isXMLJSP(IDOMDocument document) {
        Element root = document.getDocumentElement();
        return root != null && (root.hasAttribute(XMLNS_JSP) || HTTP_JAVA_SUN_COM_JSP_PAGE.equals(root.getAttribute(XMLNS)));
    }

    private void validate(IFile file, int kind, ValidationState state, IProgressMonitor monitor, IDOMModel model, IReporter reporter) {
        HTMLValidationAdapterFactory factory;
        ValidationAdapter adapter;
        IDOMDocument document = model.getDocument();
        if (document == null) {
            return;
        }
        boolean isXMLJSP = this.isXMLJSP(document);
        boolean hasHTMLFeature = this.hasHTMLFeature(document);
        if (hasHTMLFeature && !isXMLJSP && (adapter = (ValidationAdapter)(factory = HTMLValidationAdapterFactory.getInstance()).adapt((INodeNotifier)document)) != null) {
            HTMLValidationReporter rep = this.getReporter(reporter, file, model);
            rep.clear();
            adapter.setReporter((ValidationReporter)rep);
            adapter.validate((IndexedRegion)document);
        }
        if (!hasHTMLFeature && isXMLJSP) {
            Validator xmlValidator = new Validator();
            xmlValidator.validate((IResource)file, kind, state, monitor);
        }
    }

    private void validate(IReporter reporter, IFile file, IDOMModel model) {
        if (file == null || model == null) {
            return;
        }
        IDOMDocument document = model.getDocument();
        if (document == null) {
            return;
        }
        boolean hasXMLFeature = this.isXMLJSP(document);
        boolean hasHTMLFeature = this.hasHTMLFeature(document);
        if (hasHTMLFeature && !hasXMLFeature) {
            HTMLValidationAdapterFactory factory = HTMLValidationAdapterFactory.getInstance();
            ValidationAdapter adapter = (ValidationAdapter)factory.adapt((INodeNotifier)document);
            if (adapter == null) {
                return;
            }
            HTMLValidationReporter rep = this.getReporter(reporter, file, model);
            rep.clear();
            adapter.setReporter((ValidationReporter)rep);
            adapter.validate((IndexedRegion)document);
        }
    }

    private boolean shouldValidate(IResource resource) {
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        if (!this.shouldValidate(resource)) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        if (!this.fragmentCheck((IFile)resource)) return result;
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead((IFile)resource);
                if (reporter.isCancelled() || !(model instanceof IDOMModel)) return result;
                reporter.removeAllMessages((IValidator)this, (Object)resource);
                this.validate((IFile)resource, kind, state, monitor, (IDOMModel)model, reporter);
                return result;
            }
            catch (IOException e) {
                Logger.logException(e);
                if (model == null) return result;
                model.releaseFromRead();
                return result;
            }
            catch (CoreException e) {
                Logger.logException(e);
                if (model == null) return result;
                model.releaseFromRead();
                return result;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void validateFile(IFile f, IReporter reporter) {
        IStructuredModel model = null;
        try {
            try {
                if (!this.fragmentCheck(f) || reporter.isCancelled()) return;
                model = StructuredModelManager.getModelManager().getModelForRead(f);
                if (reporter.isCancelled() || !(model instanceof IDOMModel)) return;
                reporter.removeAllMessages((IValidator)this, (Object)f);
                this.validate(reporter, f, (IDOMModel)model);
                return;
            }
            catch (IOException e) {
                Logger.logException(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (CoreException e) {
                Logger.logException(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }
}

