/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.zest.fx.parts.AbstractLabelPart;
import org.eclipse.gef.zest.fx.parts.EdgePart;
import org.eclipse.gef.zest.fx.parts.NodePart;
import org.eclipse.gef.zest.fx.policies.TransformLabelPolicy;

public class LabelOffsetSupport
extends IAdaptable.Bound.Impl<IViewer> {
    private AbstractLabelPart[] labelParts;
    private TransformLabelPolicy[] policies;
    private boolean[] wasRefresh;

    public void abort() {
        if (this.labelParts != null) {
            int i = 0;
            while (i < this.labelParts.length) {
                this.policies[i].rollback();
                this.labelParts[i].setRefreshVisual(this.wasRefresh[i]);
                ++i;
            }
            this.labelParts = null;
            this.policies = null;
            this.wasRefresh = null;
        }
    }

    public void commit() {
        if (this.labelParts != null) {
            int i = 0;
            while (i < this.labelParts.length) {
                try {
                    ((IViewer)this.getAdaptable()).getDomain().execute(this.policies[i].commit(), null);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                this.labelParts[i].setRefreshVisual(this.wasRefresh[i]);
                ++i;
            }
            this.labelParts = null;
            this.policies = null;
            this.wasRefresh = null;
        }
    }

    protected List<AbstractLabelPart> getEdgeLabelParts(EdgePart edgePart) {
        ArrayList<AbstractLabelPart> linked = new ArrayList<AbstractLabelPart>();
        linked.addAll(new ArrayList(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)edgePart, (String)"element-label"), AbstractLabelPart.class)));
        linked.addAll(new ArrayList(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)edgePart, (String)"element-external-label"), AbstractLabelPart.class)));
        linked.addAll(new ArrayList(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)edgePart, (String)"edge-source-label"), AbstractLabelPart.class)));
        linked.addAll(new ArrayList(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)edgePart, (String)"edge-target-label"), AbstractLabelPart.class)));
        return linked;
    }

    protected List<AbstractLabelPart> getLabelParts(List<? extends IVisualPart<? extends Node>> targets) {
        Set labelParts = Collections.newSetFromMap(new IdentityHashMap());
        for (IVisualPart<? extends Node> iVisualPart : targets) {
            if (iVisualPart instanceof NodePart) {
                labelParts.addAll(this.getNodeLabelParts((NodePart)iVisualPart));
                for (IVisualPart anchored : iVisualPart.getAnchoredsUnmodifiable()) {
                    if (!(anchored instanceof EdgePart)) continue;
                    labelParts.addAll(this.getEdgeLabelParts((EdgePart)anchored));
                }
                continue;
            }
            if (!(iVisualPart instanceof EdgePart)) continue;
            labelParts.addAll(this.getEdgeLabelParts((EdgePart)iVisualPart));
        }
        Iterator iterator = labelParts.iterator();
        while (iterator.hasNext()) {
            if (((AbstractLabelPart)((Object)iterator.next())).getLabelPosition() != null) continue;
            iterator.remove();
        }
        labelParts.removeAll(targets);
        return new ArrayList<AbstractLabelPart>(labelParts);
    }

    protected List<AbstractLabelPart> getNodeLabelParts(NodePart nodePart) {
        return new ArrayList<AbstractLabelPart>(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)nodePart, (String)"element-external-label"), AbstractLabelPart.class));
    }

    public void init(List<? extends IVisualPart<? extends Node>> targets) {
        List<AbstractLabelPart> labels = this.getLabelParts(targets);
        Iterator<AbstractLabelPart> it = labels.iterator();
        while (it.hasNext()) {
            if (it.next().getAdapter(TransformLabelPolicy.class) != null) continue;
            it.remove();
        }
        if (!labels.isEmpty()) {
            this.labelParts = labels.toArray(new AbstractLabelPart[0]);
            this.policies = new TransformLabelPolicy[this.labelParts.length];
            this.wasRefresh = new boolean[this.labelParts.length];
            int i = 0;
            while (i < this.labelParts.length) {
                this.policies[i] = (TransformLabelPolicy)((Object)this.labelParts[i].getAdapter(TransformLabelPolicy.class));
                this.wasRefresh[i] = this.labelParts[i].isRefreshVisual();
                this.labelParts[i].setRefreshVisual(false);
                this.policies[i].init();
                ++i;
            }
        }
    }

    public void preserveLabelOffsets() {
        if (this.labelParts != null) {
            int i = 0;
            while (i < this.labelParts.length) {
                this.policies[i].preserveLabelOffset();
                ++i;
            }
        }
    }
}

