/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.ui.contentassist;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.parsley.dsl.model.ModelPackage;
import org.eclipse.emf.parsley.dsl.typing.EmfParsleyDslTypeSystem;
import org.eclipse.emf.parsley.dsl.ui.contentassist.AbstractEmfParsleyDslProposalProvider;
import org.eclipse.emf.parsley.dsl.util.EmfParsleyDslGuiceModuleHelper;
import org.eclipse.emf.parsley.dsl.util.EmfParsleyDslModelUtil;
import org.eclipse.emf.parsley.dsl.validation.EmfParsleyDslExpectedSuperTypes;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.xtext.ui.ITypesProposalProvider;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalFactory;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.ui.contentassist.ImportOrganizingProposal;
import org.eclipse.xtext.xbase.ui.contentassist.ReplacingAppendable;

public class EmfParsleyDslProposalProvider
extends AbstractEmfParsleyDslProposalProvider {
    @Inject
    private ITypesProposalProvider typeProposalProvider;
    @Inject
    private IJvmTypeProvider.Factory typeProviderFactory;
    @Inject
    @Extension
    private EmfParsleyDslExpectedSuperTypes _emfParsleyDslExpectedSuperTypes;
    @Inject
    @Extension
    private EmfParsleyDslGuiceModuleHelper _emfParsleyDslGuiceModuleHelper;
    @Inject
    private ReplacingAppendable.Factory appendableFactory;
    @Inject
    private EmfParsleyDslTypeSystem typeSystem;

    @Override
    public void completeViewSpecification_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.showOnlySubtypesOf(model, context, acceptor, this._emfParsleyDslExpectedSuperTypes.getExpectedSupertype(ModelPackage.Literals.VIEW_SPECIFICATION));
    }

    @Override
    public void completeFeatureAssociatedExpression_ParameterType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.showSubtypesOfEObjectForEmfFeatureAccess(model, context, acceptor);
    }

    @Override
    public void completeFeatureSpecification_ParameterType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.showSubtypesOfEObjectForEmfFeatureAccess(model, context, acceptor);
    }

    @Override
    public void completeControlFactorySpecification_ParameterType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.showSubtypesOfEObjectForEmfFeatureAccess(model, context, acceptor);
    }

    @Override
    public void completeExtendsClause_SuperType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.showOnlySubtypesOf(model, context, acceptor, this._emfParsleyDslExpectedSuperTypes.getExpectedSupertype(model.eContainer()));
    }

    protected void showSubtypesOfEObjectForEmfFeatureAccess(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.showOnlySubtypesOf(model, context, acceptor, this._emfParsleyDslExpectedSuperTypes.getExpectedSupertype(ModelPackage.Literals.FEATURE_ASSOCIATED_EXPRESSION));
    }

    protected void showOnlySubtypesOf(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor, Class<?> superType) {
        if (superType == null) {
            return;
        }
        IJvmTypeProvider jvmTypeProvider = this.typeProviderFactory.createTypeProvider(model.eResource().getResourceSet());
        JvmType interfaceToImplement = jvmTypeProvider.findTypeByName(superType.getName());
        this.typeProposalProvider.createSubTypeProposals(interfaceToImplement, (ICompletionProposalFactory)this, context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, acceptor);
    }

    @Override
    public void completeBinding_TypeDecl(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createStandardJavaTypesProposals(context, acceptor);
        Procedures.Procedure2 _function = (appendable, op) -> {
            appendable.append(this.toLightweightTypeReference(op.getReturnType(), model));
            appendable.append((CharSequence)" ");
            appendable.append((CharSequence)op.getSimpleName().substring("value".length()));
        };
        this.createBindingProposals(model, this._emfParsleyDslGuiceModuleHelper.getAllGuiceValueBindingsMethodsInSuperclass(EmfParsleyDslModelUtil.containingModule((EObject)model)), context, acceptor, (Procedures.Procedure2<? super ReplacingAppendable, ? super JvmOperation>)_function);
    }

    @Override
    public void completeBinding_TypeToBind(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Functions.Function1 _function = op -> this.extractWildcardUpperBound((JvmOperation)op);
        this.completeTypeOrProvideBinding(model, this._emfParsleyDslGuiceModuleHelper.getAllGuiceTypeBindingsMethodsInSuperclass(EmfParsleyDslModelUtil.containingModule((EObject)model)), (Functions.Function1<? super JvmOperation, ? extends JvmTypeReference>)_function, assignment, context, acceptor);
    }

    @Override
    public void completeBinding_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Functions.Function1 _function = op -> {
            JvmTypeReference _xblockexpression = null;
            JvmTypeReference _extractWildcardUpperBound = this.extractWildcardUpperBound((JvmOperation)op);
            JvmParameterizedTypeReference providerType = (JvmParameterizedTypeReference)_extractWildcardUpperBound;
            _xblockexpression = (JvmTypeReference)IterableExtensions.head((Iterable)providerType.getArguments());
            return _xblockexpression;
        };
        this.completeTypeOrProvideBinding(model, this._emfParsleyDslGuiceModuleHelper.getAllGuiceProviderBindingsMethodsInSuperclass(EmfParsleyDslModelUtil.containingModule((EObject)model)), (Functions.Function1<? super JvmOperation, ? extends JvmTypeReference>)_function, assignment, context, acceptor);
    }

    private JvmTypeReference extractWildcardUpperBound(JvmOperation op) {
        JvmTypeReference _xblockexpression = null;
        JvmTypeReference _returnType = op.getReturnType();
        JvmParameterizedTypeReference returnType = (JvmParameterizedTypeReference)_returnType;
        JvmTypeReference _head = (JvmTypeReference)IterableExtensions.head((Iterable)returnType.getArguments());
        JvmWildcardTypeReference argument = (JvmWildcardTypeReference)_head;
        _xblockexpression = ((JvmTypeConstraint)IterableExtensions.head((Iterable)argument.getConstraints())).getTypeReference();
        return _xblockexpression;
    }

    private void completeTypeOrProvideBinding(EObject model, Iterable<JvmOperation> superClassValueBindings, Functions.Function1<? super JvmOperation, ? extends JvmTypeReference> typeExtractor, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createStandardJavaTypesProposals(context, acceptor);
        Procedures.Procedure2 _function = (appendable, op) -> {
            JvmTypeReference typeReference = (JvmTypeReference)typeExtractor.apply(op);
            appendable.append(this.toLightweightTypeReference(typeReference, model));
        };
        this.createBindingProposals(model, superClassValueBindings, context, acceptor, (Procedures.Procedure2<? super ReplacingAppendable, ? super JvmOperation>)_function);
    }

    private void createStandardJavaTypesProposals(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, true, (IValueConverter)this.getQualifiedNameValueConverter(), this.createVisibilityFilter(context), acceptor);
    }

    private void createBindingProposals(EObject model, Iterable<JvmOperation> superClassValueBindings, ContentAssistContext context, ICompletionProposalAcceptor acceptor, Procedures.Procedure2<? super ReplacingAppendable, ? super JvmOperation> proposalTextStrategy) {
        for (JvmOperation op : superClassValueBindings) {
            this.createProposals(model, op, context, acceptor, proposalTextStrategy);
        }
    }

    private LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef, EObject model) {
        return this.typeSystem.toLightweightTypeReference(typeRef, model);
    }

    private void createProposals(EObject model, final JvmOperation op, final ContentAssistContext context, ICompletionProposalAcceptor acceptor, Procedures.Procedure2<? super ReplacingAppendable, ? super JvmOperation> proposalTextStrategy) {
        IXtextDocument document = context.getDocument();
        Resource _eResource = model.eResource();
        XtextResource resource = (XtextResource)_eResource;
        int offset = context.getReplaceRegion().getOffset();
        ReplacingAppendable appendable = (ReplacingAppendable)this.appendableFactory.create(document, resource, offset, context.getReplaceRegion().getLength());
        proposalTextStrategy.apply((Object)appendable, (Object)op);
        Image image = this.getImage((EObject)op);
        LightweightTypeReferenceFactory typeConverter = this.getTypeConverter(context.getResource());
        StyledString displayString = this.getStyledDisplayString((JvmFeature)op, false, 0, op.getQualifiedName(), op.getSimpleName(), typeConverter);
        ImportOrganizingProposal completionProposal = this.createCompletionProposal(appendable, context.getReplaceRegion(), displayString, image);
        completionProposal.setPriority(1500);
        PrefixMatcher _function = new PrefixMatcher(){

            public boolean isCandidateMatchingPrefix(String name, String prefix) {
                boolean _xblockexpression = false;
                PrefixMatcher delegate = context.getMatcher();
                _xblockexpression = delegate.isCandidateMatchingPrefix(op.getSimpleName(), prefix);
                return _xblockexpression;
            }
        };
        completionProposal.setMatcher(_function);
        completionProposal.setAdditionalProposalInfo((Object)op);
        completionProposal.setHover(this.getHover());
        acceptor.accept((ICompletionProposal)completionProposal);
    }

    private ImportOrganizingProposal createCompletionProposal(ReplacingAppendable appendable, Region replaceRegion, StyledString displayString, Image image) {
        int _offset = replaceRegion.getOffset();
        int _length = replaceRegion.getLength();
        int _offset_1 = replaceRegion.getOffset();
        return new ImportOrganizingProposal(appendable, _offset, _length, _offset_1, image, displayString);
    }
}

