/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.syncing;

import java.util.List;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.server.TransactionCommitContext;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public final class ReplicatorCommitContext
extends TransactionCommitContext {
    private final CDOCommitInfo commitInfo;

    public ReplicatorCommitContext(InternalTransaction transaction, CDOCommitInfo commitInfo) {
        super(transaction);
        this.commitInfo = commitInfo;
        this.setCommitComment(commitInfo.getComment());
        InternalCDOPackageUnit[] newPackageUnits = ReplicatorCommitContext.getNewPackageUnits(commitInfo, this.getPackageRegistry());
        this.setNewPackageUnits(newPackageUnits);
        InternalCDORevision[] newObjects = ReplicatorCommitContext.getNewObjects(commitInfo);
        this.setNewObjects(newObjects);
        InternalCDORevisionDelta[] dirtyObjectDeltas = ReplicatorCommitContext.getDirtyObjectDeltas(commitInfo);
        this.setDirtyObjectDeltas(dirtyObjectDeltas);
        CDOID[] detachedObjects = ReplicatorCommitContext.getDetachedObjects(commitInfo);
        this.setDetachedObjects(detachedObjects);
    }

    @Override
    public String getUserID() {
        return this.commitInfo.getUserID();
    }

    @Override
    protected long[] createTimeStamp(OMMonitor monitor) {
        InternalRepository repository = this.getTransaction().getSession().getRepository();
        long commitTimeStamp = this.commitInfo.getTimeStamp();
        if (commitTimeStamp == 0L) {
            commitTimeStamp = repository.getTimeStamp();
        }
        return repository.forceCommitTimeStamp(this.commitInfo.getTimeStamp(), monitor);
    }

    @Override
    protected void adjustForCommit() {
    }

    @Override
    public void applyIDMappings(OMMonitor monitor) {
        monitor.begin();
        try {
            this.notifyBeforeCommitting(monitor);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected void lockObjects() throws InterruptedException {
    }

    @Override
    protected void checkXRefs() {
    }

    @Override
    protected void checkContainmentCycles() {
    }

    private static InternalCDOPackageUnit[] getNewPackageUnits(CDOCommitInfo commitInfo, InternalCDOPackageRegistry packageRegistry) {
        List list = commitInfo.getNewPackageUnits();
        InternalCDOPackageUnit[] result = new InternalCDOPackageUnit[list.size()];
        int i = 0;
        for (CDOPackageUnit packageUnit : list) {
            result[i] = (InternalCDOPackageUnit)packageUnit;
            packageRegistry.putPackageUnit(result[i]);
            ++i;
        }
        return result;
    }

    private static InternalCDORevision[] getNewObjects(CDOCommitInfo commitInfo) {
        List list = commitInfo.getNewObjects();
        InternalCDORevision[] result = new InternalCDORevision[list.size()];
        int i = 0;
        for (CDOIDAndVersion revision : list) {
            result[i++] = (InternalCDORevision)revision;
        }
        return result;
    }

    private static InternalCDORevisionDelta[] getDirtyObjectDeltas(CDOCommitInfo commitInfo) {
        List list = commitInfo.getChangedObjects();
        InternalCDORevisionDelta[] result = new InternalCDORevisionDelta[list.size()];
        int i = 0;
        for (CDORevisionKey delta : list) {
            result[i++] = (InternalCDORevisionDelta)delta;
        }
        return result;
    }

    private static CDOID[] getDetachedObjects(CDOCommitInfo commitInfo) {
        List list = commitInfo.getDetachedObjects();
        CDOID[] result = new CDOID[list.size()];
        int i = 0;
        for (CDOIDAndVersion key : list) {
            result[i++] = key.getID();
        }
        return result;
    }
}

