/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.internal.server.LDAPUserAuthenticator;
import org.eclipse.emf.cdo.server.IRepositoryProtector;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.spi.server.AbstractOperationAuthorizer;
import org.eclipse.net4j.util.factory.ProductCreationException;

public abstract class LDAPOperationAuthorizer
extends AbstractOperationAuthorizer<ISession> {
    private final Set<String> dns;

    public LDAPOperationAuthorizer(String operationID, Set<String> dns) {
        super(operationID);
        this.dns = dns;
    }

    public final Set<String> getDNs() {
        return this.dns;
    }

    @Override
    protected String authorizeOperation(ISession session, Map<String, Object> parameters) {
        IRepositoryProtector protector = session.getManager().getRepository().getProtector();
        if (protector == null) {
            return "No repository protector";
        }
        String userID = session.getUserID();
        if (userID == null) {
            return "No user ID";
        }
        LDAPUserAuthenticator.LDAPUserInfo userInfo = (LDAPUserAuthenticator.LDAPUserInfo)protector.getUserInfo(userID);
        if (userInfo == null) {
            return "User " + userID + " is not authenticated";
        }
        if (this.authorizeOperation(userInfo, this.dns)) {
            return null;
        }
        return "User " + userID + " is not authorized";
    }

    protected abstract boolean authorizeOperation(LDAPUserAuthenticator.LDAPUserInfo var1, Set<String> var2);

    public static abstract class Factory
    extends AbstractOperationAuthorizer.Factory<ISession> {
        public Factory(String type) {
            super(type);
        }

        protected LDAPOperationAuthorizer create(String operationID, String description) throws ProductCreationException {
            HashSet<String> dns = new HashSet<String>();
            if (description != null) {
                String[] stringArray = description.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String dn = stringArray[n2];
                    if ((dn = dn.trim()).length() != 0) {
                        dns.add(dn);
                    }
                    ++n2;
                }
            }
            return this.create(operationID, dns);
        }

        protected abstract LDAPOperationAuthorizer create(String var1, Set<String> var2) throws ProductCreationException;
    }

    public static final class RequireGroup
    extends LDAPOperationAuthorizer {
        public RequireGroup(String operationID, Set<String> dns) {
            super(operationID, dns);
        }

        @Override
        protected boolean authorizeOperation(LDAPUserAuthenticator.LDAPUserInfo userInfo, Set<String> dns) {
            for (LDAPUserAuthenticator.LDAPDN dn : userInfo.groupDNs()) {
                if (!dns.contains(dn)) continue;
                return true;
            }
            return false;
        }

        public static final class Factory
        extends org.eclipse.emf.cdo.internal.server.LDAPOperationAuthorizer$Factory {
            public static final String TYPE = "ldapRequireGroup";

            public Factory() {
                super(TYPE);
            }

            @Override
            protected RequireUser create(String operationID, Set<String> dns) throws ProductCreationException {
                return new RequireUser(operationID, dns);
            }
        }
    }

    public static final class RequireUser
    extends LDAPOperationAuthorizer {
        public RequireUser(String operationID, Set<String> dns) {
            super(operationID, dns);
        }

        @Override
        protected boolean authorizeOperation(LDAPUserAuthenticator.LDAPUserInfo userInfo, Set<String> dns) {
            LDAPUserAuthenticator.LDAPDN dn = userInfo.userDN();
            return dns.contains(dn);
        }

        public static final class Factory
        extends org.eclipse.emf.cdo.internal.server.LDAPOperationAuthorizer$Factory {
            public static final String TYPE = "ldapRequireUser";

            public Factory() {
                super(TYPE);
            }

            @Override
            protected RequireUser create(String operationID, Set<String> dns) throws ProductCreationException {
                return new RequireUser(operationID, dns);
            }
        }
    }
}

