/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.ui.actions;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.internal.CompareEditorSelectionProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.CDODeltaNotification;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.cdo.internal.ui.CDOAuthorCache;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.reviews.Comment;
import org.eclipse.emf.cdo.lm.reviews.DeliveryReview;
import org.eclipse.emf.cdo.lm.reviews.ModelReference;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.ReviewsFactory;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.Topic;
import org.eclipse.emf.cdo.lm.reviews.TopicContainer;
import org.eclipse.emf.cdo.lm.reviews.TopicStatus;
import org.eclipse.emf.cdo.lm.reviews.provider.ReviewsEditPlugin;
import org.eclipse.emf.cdo.lm.reviews.ui.actions.AbstractReviewAction;
import org.eclipse.emf.cdo.lm.reviews.ui.bundle.OM;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.CDOTopicProvider;
import org.eclipse.emf.cdo.ui.DefaultTopicProvider;
import org.eclipse.emf.cdo.ui.compare.CDOCompareEditorUtil;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.Navigatable;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.ui.ColorStyler;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.chat.ChatComposite;
import org.eclipse.net4j.util.ui.chat.ChatMessage;
import org.eclipse.net4j.util.ui.chat.ChatRenderer;
import org.eclipse.net4j.util.ui.widgets.EntryControlAdvisor;
import org.eclipse.net4j.util.ui.widgets.EntryField;
import org.eclipse.net4j.util.ui.widgets.SashComposite;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class OpenReviewAction
extends AbstractReviewAction {
    private static final String COMPARE_EDITOR_ID = "org.eclipse.compare.CompareEditor";
    private static final String KEY_REVIEW = "cdo.review";
    private static final String KEY_REVIEW_EDITOR_HANDLER = "cdo.review.editor.handler";
    private final Topic initialTopic;

    public OpenReviewAction(IWorkbenchPage page, Topic initialTopic) {
        this(page, initialTopic.getReview(), initialTopic);
    }

    public OpenReviewAction(IWorkbenchPage page, Review review, Topic initialTopic) {
        super(page, "Open" + INTERACTIVE, "Open the review", OM.getImageDescriptor("icons/Open.gif"), "Open the review.", null, review);
        this.initialTopic = initialTopic;
    }

    @Override
    protected void preRun(Review review, ISystemDescriptor systemDescriptor) {
    }

    protected boolean isDialogNeeded() {
        return false;
    }

    @Override
    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent, Review review, ISystemDescriptor systemDescriptor) {
    }

    @Override
    protected void doRun(Review review, ISystemDescriptor systemDescriptor, IProgressMonitor monitor) throws Exception {
        IEditorPart editor = this.findReviewEditor(review);
        if (editor != null) {
            IWorkbenchPage page = editor.getSite().getPage();
            UIUtil.asyncExec(() -> {
                page.activate((IWorkbenchPart)editor);
                CDOCompareEditorUtil.Input input = (CDOCompareEditorUtil.Input)editor.getEditorInput();
                ReviewEditorHandler handler = (ReviewEditorHandler)((Object)((Object)input.properties().get((Object)KEY_REVIEW_EDITOR_HANDLER)));
                handler.selectFirstDiffElement(this.initialTopic);
            });
            return;
        }
        if (review instanceof DeliveryReview) {
            DeliveryReview deliveryReview = (DeliveryReview)review;
            String moduleName = deliveryReview.getModule().getName();
            systemDescriptor.withModuleSession(moduleName, moduleSession -> {
                CDOBranchRef branchRef = deliveryReview.getBranch();
                CDOBranch branch = branchRef.resolve(moduleSession.getBranchManager());
                CDOBranchPoint basePoint = branch.getPoint(branch.getBase().getTimeStamp());
                CDOBranchPoint headPoint = branch.getHead();
                CDOView leftView = moduleSession.openView(headPoint);
                CDOView rightView = moduleSession.openView(basePoint);
                CDOView[] originView = new CDOView[1];
                CDOCompareEditorUtil.addDisposeRunnables((Runnable[])new Runnable[]{() -> {
                    LifecycleUtil.deactivateSilent((Object)leftView);
                    LifecycleUtil.deactivateSilent((Object)rightView);
                }});
                CDOCompareEditorUtil.setInputConsumer((Consumer)((Object)new ReviewEditorHandler(deliveryReview, this.initialTopic, systemDescriptor)));
                CDOCompareEditorUtil.openEditor((CDOView)leftView, (CDOView)rightView, (CDOView[])originView, (boolean)true);
            });
        }
    }

    private IEditorPart findReviewEditor(Review review) {
        IEditorReference[] iEditorReferenceArray = this.getPage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOCompareEditorUtil.Input input;
            Object property;
            IEditorInput editorInput;
            IEditorPart editor;
            IEditorReference reference = iEditorReferenceArray[n2];
            String id = reference.getId();
            if (COMPARE_EDITOR_ID.equals(id) && (editor = reference.getEditor(false)) != null && (editorInput = editor.getEditorInput()) instanceof CDOCompareEditorUtil.Input && (property = (input = (CDOCompareEditorUtil.Input)editorInput).properties().get((Object)KEY_REVIEW)) == review) {
                return editor;
            }
            ++n2;
        }
        return null;
    }

    private static final class ReviewEditorHandler
    extends CDOCompareEditorUtil.InputHolder
    implements IAdaptable {
        private static final String IMAGE_FOLDER = "icons/editor/";
        private static final String TOPIC_IMAGE = "icons/editor/Topic.png";
        private static final Field NAVIGATABLE_FIELD;
        private static final Field SELECTION_LISTENERS_FIELD;
        private static final String UNRESOLVE_ACTION = "unresolve";
        private static final String UNRESOLVE_LABEL = "Needs resolution";
        private static final StyledString.Styler UNRESOLVED_STYLER;
        private static final String RESOLVE_ACTION = "resolve";
        private static final String RESOLVE_LABEL = "Resolve";
        private static final StyledString.Styler RESOLVED_STYLER;
        private static final String CHAT_RENDERER_TYPE;
        private static final String CHAT_RENDERER_DESCRIPTION;
        private static final String ENTRY_CONTROL_ADVISOR_TYPE;
        private static final String ENTRY_CONTROL_ADVISOR_DESCRIPTION;
        private final DefaultTopicProvider remoteTopicProvider = new DefaultTopicProvider();
        private final CDOTopicProvider.Topic remoteReviewTopic;
        private final DeliveryReview review;
        private final EContentAdapter reviewContentAdapter = new ReviewContentAdapter();
        private final ISystemDescriptor systemDescriptor;
        private final Image topicImage = OM.getImage("icons/editor/Topic.png");
        private final Image topicImageUnresolved = OM.getOverlayImage("icons/editor/Topic.png", "icons/editor/Unresolved.png", 18, 2);
        private final Image topicImageResolved = OM.getOverlayImage("icons/editor/Topic.png", "icons/editor/Resolved.png", 14, 2);
        private Topic firstTopic;
        private Topic currentTopic;
        private Object lastDiffElement;
        private ChatRenderer renderer;
        private Label topicIcon;
        private EntryField topicEntryField;
        private Link topicActionLine;
        private TopicStatus topicStatus;
        private ChatComposite chatComposite;
        private final CDOAuthorCache authorCache;

        static {
            UNRESOLVED_STYLER = new ColorStyler(new Color((Device)UIUtil.getDisplay(), 220, 40, 40));
            RESOLVED_STYLER = new ColorStyler(new Color((Device)UIUtil.getDisplay(), 20, 180, 20));
            CHAT_RENDERER_TYPE = OMPlatform.INSTANCE.getProperty("CHAT_RENDERER_TYPE", "mylyn");
            CHAT_RENDERER_DESCRIPTION = OMPlatform.INSTANCE.getProperty("CHAT_RENDERER_DESCRIPTION", "Markdown");
            ENTRY_CONTROL_ADVISOR_TYPE = OMPlatform.INSTANCE.getProperty("ENTRY_CONTROL_ADVISOR_TYPE", "mylyn");
            ENTRY_CONTROL_ADVISOR_DESCRIPTION = OMPlatform.INSTANCE.getProperty("ENTRY_CONTROL_ADVISOR_DESCRIPTION", "Markdown");
            Field navigableField = null;
            try {
                navigableField = ReflectUtil.getField(EMFCompareStructureMergeViewer.class, (String)"navigatable");
            }
            catch (Throwable ex) {
                OM.LOG.error(ex);
            }
            NAVIGATABLE_FIELD = navigableField;
            Field selectionListenersField = null;
            try {
                selectionListenersField = ReflectUtil.getField(CompareEditorSelectionProvider.class, (String)"fSelectionChangedListeners");
            }
            catch (Throwable ex) {
                OM.LOG.error(ex);
            }
            SELECTION_LISTENERS_FIELD = selectionListenersField;
        }

        public ReviewEditorHandler(DeliveryReview review, Topic firstTopic, ISystemDescriptor systemDescriptor) {
            this.review = review;
            this.systemDescriptor = systemDescriptor;
            this.firstTopic = firstTopic;
            review.cdoPrefetch(-1);
            this.authorCache = this.initializeAuthorCache(review);
            this.remoteReviewTopic = ReviewEditorHandler.createRemoteTopic((Review)review);
        }

        public void activate(CDOCompareEditorUtil.Input input) {
            input.setTitle(this.review.getTypeAndName());
            input.setSaveHandler(this::handleSave);
            IRegistry properties = input.properties();
            properties.put((Object)OpenReviewAction.KEY_REVIEW, (Object)this.review);
            properties.put((Object)OpenReviewAction.KEY_REVIEW_EDITOR_HANDLER, (Object)this);
            input.setEditionSelectionDialog(true);
            input.addPropertyChangeListener(event -> {
                Object diffElement;
                if (CompareEditorInput.PROP_SELECTED_EDITION.equals(event.getProperty()) && (diffElement = event.getNewValue()) != this.lastDiffElement) {
                    if (!this.handleDiffElementSelection(this.lastDiffElement, diffElement)) {
                        TreeViewer treeViewer = input.getTreeViewer();
                        treeViewer.setSelection((ISelection)new StructuredSelection(this.lastDiffElement));
                        return;
                    }
                    this.lastDiffElement = diffElement;
                }
            });
            this.review.eAdapters().add((Object)this.reviewContentAdapter);
        }

        public Exception deactivate() {
            this.review.eAdapters().remove((Object)this.reviewContentAdapter);
            return null;
        }

        public <T> T getAdapter(Class<T> type) {
            if (type == CDOTopicProvider.class) {
                return type.cast(this.remoteTopicProvider);
            }
            return null;
        }

        public Control createContents(Composite parent, final Function<Composite, Control> defaultContentsCreator) {
            return new SashComposite(parent, 0, 100, 50, false, true, false){

                protected Control createControl1(Composite parent) {
                    try {
                        Control control = (Control)defaultContentsCreator.apply(parent);
                        return control;
                    }
                    finally {
                        this.customizeDiffViewer();
                    }
                }

                protected Control createControl2(Composite parent) {
                    Display display = parent.getDisplay();
                    Color entryBackgroundColor = new Color((Device)display, 241, 241, 241);
                    this.addDisposeListener(e -> entryBackgroundColor.dispose());
                    renderer = (ChatRenderer)IPluginContainer.INSTANCE.getElementOrNull("org.eclipse.net4j.util.ui.chatRenderers", CHAT_RENDERER_TYPE, CHAT_RENDERER_DESCRIPTION);
                    EntryControlAdvisor entryControlAdvisor = (EntryControlAdvisor)IPluginContainer.INSTANCE.getElementOrNull("org.eclipse.net4j.util.ui.entryControlAdvisors", ENTRY_CONTROL_ADVISOR_TYPE, ENTRY_CONTROL_ADVISOR_DESCRIPTION);
                    Composite topicContainer = new Composite(parent, 0);
                    topicContainer.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(10, 10).spacing(LayoutConstants.getSpacing().x, 2).numColumns(2).create());
                    topicContainer.setBackground(display.getSystemColor(1));
                    topicIcon = new Label(topicContainer, 0);
                    topicIcon.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 128).create());
                    topicIcon.setImage(topicImage);
                    topicEntryField = this.createTopicEntryField(topicContainer, entryBackgroundColor, entryControlAdvisor);
                    topicEntryField.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(4, 128).create());
                    Label spacer = new Label(topicContainer, 0);
                    spacer.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 128).create());
                    topicActionLine = new Link(topicContainer, 0);
                    topicActionLine.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).create());
                    topicActionLine.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleTopicAction(e.text)));
                    chatComposite = this.createChatComposite(topicContainer, entryBackgroundColor, entryControlAdvisor);
                    chatComposite.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, true).create());
                    this.refreshTopicUI();
                    return topicContainer;
                }
            };
        }

        public void editorOpened(IEditorPart editor) {
            try {
                ListenerList listeners;
                TreeViewer treeViewer = this.getInput().getTreeViewer();
                IEditorSite site = editor.getEditorSite();
                ISelectionProvider oldProvider = site.getSelectionProvider();
                ListenerList listenerList = listeners = oldProvider == null ? null : (ListenerList)ReflectUtil.getValue((Field)SELECTION_LISTENERS_FIELD, (Object)oldProvider);
                if (listeners != null) {
                    for (ISelectionChangedListener listener : listeners) {
                        treeViewer.addSelectionChangedListener(listener);
                    }
                }
                site.setSelectionProvider((ISelectionProvider)treeViewer);
            }
            catch (Throwable ex) {
                OM.LOG.warn(ex);
            }
        }

        public void selectFirstDiffElement(Topic firstTopic) {
            this.firstTopic = firstTopic;
            EMFCompareStructureMergeViewer viewerWrapper = (EMFCompareStructureMergeViewer)this.getInput().getViewerWrapper();
            Navigatable navigatable = viewerWrapper.getNavigatable();
            navigatable.selectChange(3);
        }

        private void updateDiffElementLabel(Object diffElement) {
            if (diffElement != null) {
                this.getInput().getTreeViewer().update(diffElement, null);
            }
        }

        private boolean handleDiffElementSelection(Object oldDiffElement, Object newDiffElement) {
            ModelReference modelReference;
            boolean cancel = false;
            if (oldDiffElement != null && this.topicNeedsSave()) {
                int result = MessageDialog.open((int)6, (Shell)this.topicEntryField.getShell(), (String)"Topic Change", (String)"Do you want to save the changes to the current topic?", (int)0x10000000, (String[])new String[]{"Save", "Don't Save", "Cancel"});
                if (result == 2 || result == -1) {
                    return false;
                }
                if (result == 0) {
                    this.handleSave((IProgressMonitor)new NullProgressMonitor());
                } else {
                    cancel = true;
                }
            }
            if ((modelReference = ReviewEditorHandler.createModelReference(newDiffElement)) != null) {
                this.selectTopic(modelReference);
            }
            if (cancel) {
                this.updateDiffElementLabel(oldDiffElement);
            }
            return true;
        }

        private void handleTopicAction(String action) {
            TopicStatus oldStatus;
            TopicStatus newStatus = oldStatus = this.topicStatus;
            if (UNRESOLVE_ACTION.equals(action)) {
                newStatus = TopicStatus.UNRESOLVED;
            } else if (RESOLVE_ACTION.equals(action)) {
                newStatus = TopicStatus.RESOLVED;
            }
            if (newStatus != oldStatus) {
                this.topicStatus = newStatus;
                Object diffElement = this.getDiffElement(this.currentTopic);
                this.updateDiffElementLabel(diffElement);
                this.refreshTopicUI();
                this.updateDirtyness();
            }
        }

        private void handleTopicDirtyChanged(boolean dirty) {
            this.updateDirtyness();
        }

        private void handleSave(IProgressMonitor monitor) {
            if (this.currentTopic != null) {
                try {
                    if (this.currentTopic.cdoState() == CDOState.TRANSIENT) {
                        this.systemDescriptor.modify((ModelElement)this.review, r -> {
                            this.currentTopic.setText(this.topicEntryField.getEntry());
                            this.currentTopic.setStatus(this.topicStatus == null ? TopicStatus.NONE : this.topicStatus);
                            r.getTopics().add((Object)this.currentTopic);
                            return true;
                        }, monitor);
                        EList topics = this.review.getTopics();
                        this.currentTopic = (Topic)topics.get(topics.size() - 1);
                    } else {
                        this.systemDescriptor.modify((ModelElement)this.currentTopic, t -> {
                            t.setText(this.topicEntryField.getEntry());
                            if (this.topicStatus != null) {
                                t.setStatus(this.topicStatus);
                            }
                            return true;
                        }, monitor);
                    }
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
            this.topicEntryField.resetDirty();
            this.topicEntryField.setPreviewMode(!this.topicEntryField.isEmpty());
            this.topicStatus = null;
            this.updateDirtyness();
            this.setChatCompositeVisible(true);
        }

        private void updateDirtyness() {
            boolean dirty = this.isCurrentTopicDirty();
            this.getInput().setDirty(dirty);
            this.topicEntryField.setExtraButtonVisible(0, dirty);
        }

        private boolean isCurrentTopicDirty() {
            if (this.currentTopic == null) {
                return false;
            }
            return this.topicEntryField.isDirty() || this.topicStatus != null;
        }

        private Object getDiffElement(Topic topic) {
            ModelReference modelReference;
            Object[] result = new Object[1];
            if (topic != null && (modelReference = topic.getModelReference()) != null) {
                this.getInput().forEachDiffElement(diffElement -> {
                    if (modelReference.equals((Object)ReviewEditorHandler.createModelReference(diffElement))) {
                        objectArray[0] = diffElement;
                        return true;
                    }
                    return false;
                });
            }
            return result[0];
        }

        private EntryField createTopicEntryField(Composite parent, Color entryBackgroundColor, EntryControlAdvisor entryControlAdvisor) {
            EntryControlAdvisor.ControlConfig controlConfig = new EntryControlAdvisor.ControlConfig();
            controlConfig.setOkDetector(null);
            EntryField.FieldConfig fieldConfig = new EntryField.FieldConfig();
            fieldConfig.setEntryBackground(entryBackgroundColor);
            fieldConfig.setEntryControlAdvisor(entryControlAdvisor);
            fieldConfig.setEntryControlConfig(controlConfig);
            fieldConfig.setEmptyHint("Create a review topic");
            fieldConfig.setPreviewProvider((UnaryOperator)this.renderer);
            fieldConfig.setInitialPreviewMode(true);
            fieldConfig.setDirtyHandler(entryField -> this.handleTopicDirtyChanged(entryField.isDirty()));
            fieldConfig.setExtraButtonAdvisors(new EntryField.ButtonAdvisor[]{new EntryField.ButtonAdvisor(){

                public String getToolTipText() {
                    return "Save changes";
                }

                public Image getHoverImage() {
                    return SharedIcons.getImage((String)"etool16/save.gif");
                }

                public void run() {
                    this.getInput().getEditor().doSave((IProgressMonitor)new NullProgressMonitor());
                }
            }});
            EntryField entryField2 = new EntryField(parent, 0, fieldConfig);
            entryField2.setExtraButtonVisible(0, false);
            return entryField2;
        }

        private void selectTopic(ModelReference modelReference) {
            Topic topic = this.review.getTopic(modelReference);
            this.setChatCompositeVisible(topic != null);
            if (topic == null) {
                topic = ReviewsFactory.eINSTANCE.createTopic();
                topic.setModelReference(modelReference);
            }
            if (topic != this.currentTopic) {
                this.currentTopic = topic;
                this.topicStatus = null;
                String entry = topic.getText();
                this.topicEntryField.setEntry(entry);
                boolean previewMode = !this.topicEntryField.isEmpty();
                this.topicEntryField.setPreviewMode(previewMode);
                this.refreshTopicUI();
                this.chatComposite.refreshMessageBrowser();
                if (this.currentTopic == null || this.currentTopic.cdoState() == CDOState.TRANSIENT) {
                    this.remoteTopicProvider.setTopics(new CDOTopicProvider.Topic[]{this.remoteReviewTopic});
                } else {
                    this.remoteTopicProvider.setTopics(new CDOTopicProvider.Topic[]{this.remoteReviewTopic, ReviewEditorHandler.createRemoteTopic(this.currentTopic)});
                }
            }
        }

        private Topic getTopic(Object diffElement) {
            ModelReference modelReference = ReviewEditorHandler.createModelReference(diffElement);
            if (modelReference != null) {
                if (this.currentTopic != null && modelReference.equals((Object)this.currentTopic.getModelReference())) {
                    return this.currentTopic;
                }
                return this.review.getTopic(modelReference);
            }
            return null;
        }

        private void refreshTopicUI() {
            TopicStatus status = this.topicStatus;
            if (status == null && this.currentTopic != null) {
                status = this.currentTopic.getStatus();
            }
            switch (Objects.requireNonNullElse(status, TopicStatus.NONE)) {
                case NONE: {
                    this.topicIcon.setImage(this.topicImage);
                    this.topicActionLine.setText(ReviewEditorHandler.createTopicActionText(UNRESOLVE_ACTION, UNRESOLVE_LABEL));
                    break;
                }
                case UNRESOLVED: {
                    this.topicIcon.setImage(this.topicImageUnresolved);
                    this.topicActionLine.setText(ReviewEditorHandler.createTopicActionText(RESOLVE_ACTION, RESOLVE_LABEL));
                    break;
                }
                case RESOLVED: {
                    this.topicIcon.setImage(this.topicImageResolved);
                    this.topicActionLine.setText(ReviewEditorHandler.createTopicActionText(UNRESOLVE_ACTION, UNRESOLVE_LABEL));
                }
            }
        }

        private boolean topicNeedsSave() {
            return this.currentTopic != null && (this.topicStatus != null || this.topicEntryField.isDirty());
        }

        private ChatComposite createChatComposite(Composite parent, Color entryBackgroundColor, EntryControlAdvisor entryControlAdvisor) {
            ChatComposite.Config config = new ChatComposite.Config();
            config.setOwnUserID(this.review.cdoView().getSession().getUserID());
            config.setMessageProvider(this::computeMessages);
            config.setChatRenderer(this.renderer);
            config.setEntryBackgroundColor(entryBackgroundColor);
            config.setEntryControlAdvisor(entryControlAdvisor);
            config.setSendHandler(this::sendMessage);
            return new ChatComposite(parent, 0, config);
        }

        private void setChatCompositeVisible(boolean visible) {
            GridData gridData = (GridData)this.chatComposite.getLayoutData();
            if (gridData.exclude == visible) {
                this.chatComposite.setVisible(visible);
                gridData.exclude = !visible;
                this.chatComposite.getParent().requestLayout();
            }
        }

        private ChatMessage[] computeMessages() {
            ArrayList messages = new ArrayList();
            this.review.cdoView().syncExec(() -> this.addMessages(messages, (TopicContainer)(this.currentTopic == null ? this.review : this.currentTopic)));
            return messages.toArray(new ChatMessage[messages.size()]);
        }

        private void sendMessage(String markup) {
            Comment comment = ReviewsFactory.eINSTANCE.createComment();
            comment.setText(markup);
            DeliveryReview container = this.currentTopic == null ? this.review : this.currentTopic;
            try {
                this.systemDescriptor.modify((ModelElement)container, c -> {
                    c.getComments().add((Object)comment);
                    return true;
                }, null);
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }

        private void customizeDiffViewer() {
            EMFCompareStructureMergeViewer viewerWrapper = (EMFCompareStructureMergeViewer)this.getInput().getViewerWrapper();
            DelegatingStyledCellLabelProvider.IStyledLabelProvider delegate = viewerWrapper.getLabelProvider().getStyledStringProvider();
            viewerWrapper.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider(delegate){

                protected StyledString getStyledText(Object element) {
                    StyledString styledText = super.getStyledText(element);
                    Topic topic = this.getTopic(element);
                    if (topic != null) {
                        TopicStatus status;
                        TopicStatus topicStatus = status = topic == currentTopic && topicStatus != null ? topicStatus : topic.getStatus();
                        if (status == TopicStatus.UNRESOLVED) {
                            styledText.append("  ").append("[Unresolved]", UNRESOLVED_STYLER);
                        } else if (status == TopicStatus.RESOLVED) {
                            styledText.append("  ").append("[Resolved]", RESOLVED_STYLER);
                        }
                    }
                    return styledText;
                }
            });
            if (NAVIGATABLE_FIELD != null) {
                final EMFCompareStructureMergeViewerContentProvider contentProvider = viewerWrapper.getContentProvider();
                WrappableTreeViewer treeViewer = viewerWrapper.getNavigatable().getViewer();
                Navigatable navigatable = new Navigatable(treeViewer, contentProvider){

                    public boolean hasChange(int flag) {
                        if (flag == 3) {
                            return true;
                        }
                        return super.hasChange(flag);
                    }

                    public boolean selectChange(int flag) {
                        if (flag == 3 && firstTopic != null) {
                            contentProvider.runWhenReady(this.uiSyncCallbackType, new Runnable(){

                                @Override
                                public void run() {
                                    Object newSelection = this.getDiffElement(firstTopic);
                                    if (newSelection != null) {
                                        this.fireOpen(newSelection);
                                    }
                                }
                            });
                            return false;
                        }
                        return super.selectChange(flag);
                    }
                };
                ReflectUtil.setValue((Field)NAVIGATABLE_FIELD, (Object)viewerWrapper, (Object)navigatable);
                ((CTabFolder)viewerWrapper.getControl()).setData("org.eclipse.compare.internal.Navigator", (Object)navigatable);
            }
        }

        private CDOAuthorCache initializeAuthorCache(DeliveryReview review) {
            CDOAuthorCache cache = CDOAuthorCache.of((CDOSession)review.cdoView().getSession());
            Set<String> userIDs = this.collectUserIDs(review);
            cache.getAuthors(userIDs);
            return cache;
        }

        private Set<String> collectUserIDs(DeliveryReview review) {
            HashSet<String> userIDs = new HashSet<String>();
            Consumer<String> collector = userID -> {
                if (!StringUtil.isEmpty((String)userID)) {
                    userIDs.add((String)userID);
                }
            };
            collector.accept(review.getAuthor());
            review.getReviewers().forEach(collector);
            this.collectUserIDs((TopicContainer)review, collector);
            return userIDs;
        }

        private void collectUserIDs(TopicContainer container, Consumer<String> collector) {
            for (Comment comment : container.getComments()) {
                collector.accept(comment.getAuthor());
            }
            for (Topic topic : container.getTopics()) {
                collector.accept(topic.getAuthor());
                this.collectUserIDs((TopicContainer)topic, collector);
            }
        }

        private void addMessages(List<ChatMessage> messages, TopicContainer container) {
            for (final Comment comment : container.getComments()) {
                messages.add(new ChatMessage(){

                    public int getID() {
                        return comment.getId();
                    }

                    public ChatMessage.Author getAuthor() {
                        return authorCache.getAuthor(comment.getAuthor());
                    }

                    public long getCreationTime() {
                        return comment.cdoRevision().getTimeStamp();
                    }

                    public long getEditTime() {
                        return this.getCreationTime();
                    }

                    public String getContent() {
                        return comment.getText();
                    }

                    public ChatMessage getReplyTo() {
                        return null;
                    }
                });
            }
        }

        private static String createTopicActionText(String action, String label) {
            return "<a href=\"" + action + "\">" + label + "</a>";
        }

        private static ModelReference createModelReference(Object diffElement) {
            return ModelReference.Extractor.Registry.INSTANCE.extractModelReference(diffElement);
        }

        private static CDOTopicProvider.Topic createRemoteTopic(Review review) {
            String text;
            String imageKey;
            int reviewID = review.getId();
            if (review instanceof DeliveryReview) {
                imageKey = "DeliveryReview";
                text = "Delivery review " + reviewID;
            } else {
                imageKey = "DropReview";
                text = "Drop review " + reviewID;
            }
            String id = "org.eclipse.emf.cdo.lm.review/" + reviewID;
            Image image = ExtendedImageRegistry.INSTANCE.getImage(ReviewsEditPlugin.INSTANCE.getImage("full/obj16/" + imageKey));
            return new CDOTopicProvider.Topic(review.cdoView().getSession(), id, image, text, text);
        }

        private static CDOTopicProvider.Topic createRemoteTopic(Topic topic) {
            int topicID = topic.getId();
            String id = "org.eclipse.emf.cdo.lm.review.topic/" + topicID;
            Image image = ExtendedImageRegistry.INSTANCE.getImage(ReviewsEditPlugin.INSTANCE.getImage("full/obj16/Topic"));
            String text = "Review topic " + topicID;
            return new CDOTopicProvider.Topic(topic.cdoView().getSession(), id, image, text, text);
        }

        private final class ReviewContentAdapter
        extends EContentAdapter {
            public void notifyChanged(Notification notification) {
                UIRefresh refresh;
                super.notifyChanged(notification);
                if (!notification.isTouch() && notification instanceof CDODeltaNotification && (refresh = new UIRefresh(notification)).isNeeded()) {
                    UIUtil.asyncExec((Runnable)refresh);
                }
            }

            private final class UIRefresh
            implements Runnable {
                private boolean diffTreeUpdate;
                private Object diffElementToUpdate;
                private boolean topicUIUpdate;
                private String newTopicEntry;
                private boolean chatUpdate;

                public UIRefresh(Notification notification) {
                    EObject notifier = (EObject)notification.getNotifier();
                    EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
                    if (feature == ReviewsPackage.Literals.TOPIC_CONTAINER__TOPICS) {
                        int eventType = notification.getEventType();
                        if (eventType == 3) {
                            Topic newTopic = (Topic)notification.getNewValue();
                            this.diffElementToUpdate = ReviewEditorHandler.this.getDiffElement(newTopic);
                            if (!ReviewEditorHandler.this.topicNeedsSave() && Objects.equals(((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.currentTopic.getModelReference(), newTopic.getModelReference())) {
                                ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.currentTopic = newTopic;
                                ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.topicStatus = null;
                                this.topicUIUpdate = true;
                                this.newTopicEntry = newTopic.getText();
                                this.chatUpdate = true;
                            }
                        } else if (eventType == 4) {
                            this.diffTreeUpdate = true;
                            Topic oldTopic = (Topic)notification.getOldValue();
                            if (oldTopic == ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.firstTopic) {
                                ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.firstTopic = null;
                            }
                            if (oldTopic == ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.currentTopic) {
                                ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.currentTopic = ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.firstTopic;
                                ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.topicStatus = null;
                                this.topicUIUpdate = true;
                                this.newTopicEntry = "";
                                this.chatUpdate = true;
                            }
                        }
                    } else if (feature == ReviewsPackage.Literals.TOPIC__STATUS) {
                        this.diffElementToUpdate = ReviewEditorHandler.this.getDiffElement((Topic)notifier);
                        if (notifier == ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.currentTopic) {
                            this.topicUIUpdate = true;
                        }
                    } else if (feature == ReviewsPackage.Literals.AUTHORABLE__TEXT) {
                        if (notifier == ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.currentTopic && !((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.topicEntryField.isDirty()) {
                            this.newTopicEntry = notification.getNewStringValue();
                        }
                    } else if (feature == ReviewsPackage.Literals.TOPIC_CONTAINER__COMMENTS) {
                        this.checkChatUpdate((TopicContainer)notifier);
                    } else if (notifier instanceof Comment) {
                        TopicContainer container = ((Comment)notifier).getContainer();
                        this.checkChatUpdate(container);
                    }
                }

                public boolean isNeeded() {
                    return this.diffTreeUpdate || this.diffElementToUpdate != null || this.topicUIUpdate || this.newTopicEntry != null || this.chatUpdate;
                }

                @Override
                public void run() {
                    if (this.diffTreeUpdate) {
                        ReviewEditorHandler.this.getInput().getTreeViewer().refresh(true);
                    } else {
                        ReviewEditorHandler.this.updateDiffElementLabel(this.diffElementToUpdate);
                    }
                    if (this.topicUIUpdate) {
                        ReviewEditorHandler.this.refreshTopicUI();
                    }
                    if (this.newTopicEntry != null) {
                        ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.topicEntryField.setEntry(this.newTopicEntry);
                        ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.topicEntryField.setPreviewMode(true);
                    }
                    if (this.chatUpdate) {
                        ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.chatComposite.refreshMessageBrowser();
                    }
                }

                private void checkChatUpdate(TopicContainer container) {
                    if (((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.currentTopic == null) {
                        if (container == ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.review) {
                            this.chatUpdate = true;
                        }
                    } else if (container == ((ReviewContentAdapter)ReviewContentAdapter.this).ReviewEditorHandler.this.currentTopic) {
                        this.chatUpdate = true;
                    }
                }
            }
        }
    }
}

