/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IRenameChange;
import org.eclipse.dltk.internal.core.builder.AbstractBuildChange;
import org.eclipse.dltk.internal.core.builder.Messages;
import org.eclipse.dltk.internal.core.builder.RenameChange;
import org.eclipse.dltk.utils.TextUtils;

public class IncrementalProjectChange
extends AbstractBuildChange
implements IResourceDeltaVisitor {
    private final IResourceDelta delta;
    private final List<IPath>[] deletes = new List[9];
    private final List<IFile>[] resources = new List[16];
    private final List<ISourceModule>[] modules = new List[4];
    private boolean loaded = false;
    private ChangeSet projectAdditions = null;
    private ChangeSet projectChanges = null;
    private List<IPath> projectDeletes = null;
    private RenameChangeSet projectRenames = null;

    public IncrementalProjectChange(IResourceDelta delta, IProject project, IProgressMonitor monitor) {
        super(project, monitor);
        this.delta = delta;
    }

    @Override
    public IResourceDelta getResourceDelta() {
        return this.delta;
    }

    @Override
    public List<IPath> getDeletes(int options) throws CoreException {
        IncrementalProjectChange.validateFlags(options, 8);
        this.loadData();
        if (this.deletes[options] == null) {
            ArrayList<Object> paths = new ArrayList<Object>();
            if (this.projectDeletes != null) {
                paths.addAll(this.projectDeletes);
            }
            if (IncrementalProjectChange.wantRenames(options) && this.projectRenames != null) {
                paths.addAll(this.projectRenames.values());
            }
            this.deletes[options] = IncrementalProjectChange.unmodifiableList(paths);
        }
        return this.deletes[options];
    }

    @Override
    public List<IRenameChange> getRenames() throws CoreException {
        this.loadData();
        if (this.projectRenames != null) {
            return this.projectRenames.getRenames();
        }
        return Collections.emptyList();
    }

    @Override
    public List<IFile> getResources(int options) throws CoreException {
        if (((options = IncrementalProjectChange.validateFlags(options, 15)) & 0xB) == 10) {
            throw new IllegalArgumentException();
        }
        this.loadData();
        if (this.resources[options] == null) {
            ArrayList<IFile> files = new ArrayList<IFile>();
            if (IncrementalProjectChange.checkFlag(options, 1)) {
                if (this.projectAdditions != null) {
                    files.addAll(this.projectAdditions.getResources(IncrementalProjectChange.checkFlag(options, 4)));
                }
                if (IncrementalProjectChange.wantRenames(options) && this.projectRenames != null) {
                    files.addAll(this.projectRenames.getResources(IncrementalProjectChange.checkFlag(options, 4)));
                }
            }
            if (IncrementalProjectChange.checkFlag(options, 2) && this.projectChanges != null) {
                files.addAll(this.projectChanges.getResources(IncrementalProjectChange.checkFlag(options, 4)));
            }
            this.resources[options] = IncrementalProjectChange.unmodifiableList(files);
        }
        return this.resources[options];
    }

    @Override
    public List<ISourceModule> getSourceModules(int options) throws CoreException {
        options = IncrementalProjectChange.validateFlags(options, 3);
        this.loadData();
        if (this.modules[options] == null) {
            ArrayList<ISourceModule> m = new ArrayList<ISourceModule>();
            if (IncrementalProjectChange.checkFlag(options, 1)) {
                if (this.projectAdditions != null) {
                    m.addAll(this.projectAdditions.getSourceModules());
                }
                if (this.projectRenames != null) {
                    m.addAll(this.projectRenames.getSourceModules());
                }
            }
            if (IncrementalProjectChange.checkFlag(options, 2) && this.projectChanges != null) {
                m.addAll(this.projectChanges.getSourceModules());
            }
            this.modules[options] = IncrementalProjectChange.unmodifiableList(m);
        }
        return this.modules[options];
    }

    protected final void loadData() throws CoreException {
        if (!this.loaded) {
            this.loaded = true;
            this.delta.accept((IResourceDeltaVisitor)this);
        }
    }

    protected void resetDerivedProjectChanges() {
        if (this.projectAdditions != null) {
            this.projectAdditions.resetDerivedContent();
        }
        if (this.projectChanges != null) {
            this.projectChanges.resetDerivedContent();
        }
        if (this.projectRenames != null) {
            this.projectRenames.resetDerivedContent();
        }
        Arrays.fill(this.deletes, null);
        Arrays.fill(this.resources, null);
        Arrays.fill(this.modules, null);
    }

    protected boolean addChangedResource(IFile file) throws CoreException {
        Assert.isLegal((boolean)this.project.equals((Object)file.getProject()));
        this.loadData();
        if (this.projectAdditions != null && this.projectAdditions.containsKey(file)) {
            return false;
        }
        if (this.projectChanges == null) {
            this.projectChanges = new ChangeSet();
        }
        if (!this.projectChanges.containsKey(file)) {
            this.projectChanges.add(file);
            this.resetDerivedProjectChanges();
            return true;
        }
        return false;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        this.checkCanceled();
        IResource resource = delta.getResource();
        if (resource.getType() == 2) {
            this.monitor.subTask(Messages.ScriptBuilder_scanningProjectFolder + resource.getProjectRelativePath().toString());
        }
        if (resource.getType() == 1) {
            switch (delta.getKind()) {
                case 1: {
                    if ((delta.getFlags() & 0x1000) != 0) {
                        if (this.projectRenames == null) {
                            this.projectRenames = new RenameChangeSet();
                        }
                        this.projectRenames.put((IFile)resource, delta.getMovedFromPath().removeFirstSegments(1));
                        break;
                    }
                    if (this.projectAdditions == null) {
                        this.projectAdditions = new ChangeSet();
                    }
                    this.projectAdditions.add((IFile)resource);
                    break;
                }
                case 4: {
                    if ((delta.getFlags() & 0x100100) == 0) break;
                    if (this.projectChanges == null) {
                        this.projectChanges = new ChangeSet();
                    }
                    this.projectChanges.add((IFile)resource);
                    break;
                }
                case 2: {
                    if ((delta.getFlags() & 0x2000) != 0) break;
                    if (this.projectDeletes == null) {
                        this.projectDeletes = new ArrayList<IPath>();
                    }
                    this.projectDeletes.add(delta.getProjectRelativePath());
                }
            }
            return false;
        }
        return true;
    }

    public String toString() {
        try {
            this.loadData();
        }
        catch (CoreException e) {
            return e.toString();
        }
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        if (this.projectAdditions != null) {
            lines.add((CallSite)((Object)("additions=" + this.projectAdditions.toString())));
        }
        if (this.projectChanges != null) {
            lines.add((CallSite)((Object)("changes=" + this.projectChanges.toString())));
        }
        if (this.projectDeletes != null) {
            lines.add((CallSite)((Object)("deletes=" + String.valueOf(this.projectDeletes))));
        }
        return TextUtils.join(lines, "\n");
    }

    protected Set<IPath> getAddedPaths() throws CoreException {
        this.loadData();
        HashSet<IPath> paths = new HashSet<IPath>();
        if (this.projectAdditions != null) {
            for (IFile file : this.projectAdditions.getAll()) {
                paths.add(file.getFullPath());
            }
        }
        if (this.projectRenames != null) {
            for (IRenameChange rename : this.projectRenames.getRenames()) {
                paths.add(rename.getTarget().getFullPath());
            }
        }
        return paths;
    }

    protected Collection<IPath> getDeletedPaths() throws CoreException {
        IPath projectPath;
        this.loadData();
        HashSet<IPath> paths = new HashSet<IPath>();
        if (this.projectDeletes != null) {
            projectPath = this.project.getFullPath();
            for (IPath path : this.projectDeletes) {
                paths.add(projectPath.append(path));
            }
        }
        if (this.projectRenames != null) {
            projectPath = this.project.getFullPath();
            for (IRenameChange rename : this.projectRenames.getRenames()) {
                paths.add(projectPath.append(rename.getSource()));
            }
        }
        return paths;
    }

    protected Set<IPath> getChangedPaths() throws CoreException {
        IPath projectPath;
        this.loadData();
        HashSet<IPath> paths = new HashSet<IPath>();
        if (this.projectAdditions != null) {
            for (IFile file : this.projectAdditions.getAll()) {
                paths.add(file.getFullPath());
            }
        }
        if (this.projectChanges != null) {
            for (IFile file : this.projectChanges.getAll()) {
                paths.add(file.getFullPath());
            }
        }
        if (this.projectDeletes != null) {
            projectPath = this.project.getFullPath();
            for (IPath path : this.projectDeletes) {
                paths.add(projectPath.append(path));
            }
        }
        if (this.projectRenames != null) {
            projectPath = this.project.getFullPath();
            for (IRenameChange rename : this.projectRenames.getRenames()) {
                paths.add(projectPath.append(rename.getSource()));
                paths.add(rename.getTarget().getFullPath());
            }
        }
        return paths;
    }

    abstract class AbstractChangeSet<T>
    extends HashMap<IFile, T> {
        List<ISourceModule> modules = null;
        Set<IFile> realResources = null;

        AbstractChangeSet() {
        }

        public Collection<? extends IFile> getAll() {
            return this.keySet();
        }

        void resetDerivedContent() {
            this.modules = null;
            this.realResources = null;
        }

        List<ISourceModule> getSourceModules() {
            if (this.modules == null) {
                this.detectSourceModules();
            }
            return this.modules;
        }

        Collection<IFile> getResources() {
            if (this.realResources == null) {
                this.detectSourceModules();
            }
            return this.realResources;
        }

        Collection<? extends IFile> getResources(boolean all) {
            return all ? this.getAll() : this.getResources();
        }

        private final void detectSourceModules() {
            ArrayList<ISourceModule> m = new ArrayList<ISourceModule>();
            HashSet<IFile> rr = new HashSet<IFile>();
            IncrementalProjectChange.this.locateSourceModules(this.keySet(), m, rr);
            this.modules = IncrementalProjectChange.unmodifiableList(m);
            this.realResources = IncrementalProjectChange.unmodifiableSet(rr);
        }
    }

    class ChangeSet
    extends AbstractChangeSet<Object> {
        ChangeSet() {
        }

        void add(IFile file) {
            this.put(file, Boolean.TRUE);
        }

        @Override
        public String toString() {
            return this.keySet().toString();
        }
    }

    class RenameChangeSet
    extends AbstractChangeSet<IPath> {
        List<IRenameChange> renames = null;

        RenameChangeSet() {
        }

        @Override
        void resetDerivedContent() {
            super.resetDerivedContent();
            this.renames = null;
        }

        List<IRenameChange> getRenames() {
            if (this.renames == null) {
                ArrayList<RenameChange> r = new ArrayList<RenameChange>();
                for (Map.Entry entry : this.entrySet()) {
                    r.add(new RenameChange((IPath)entry.getValue(), (IFile)entry.getKey()));
                }
                this.renames = IncrementalProjectChange.unmodifiableList(r);
            }
            return this.renames;
        }
    }
}

