/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.util.List;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class CustomBuildSettingsDecorator
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IFile || element instanceof IFolder) {
            ICConfigurationDescription cfgDescription;
            IResource rc = (IResource)element;
            ICProjectDescriptionManager projectDescriptionManager = CoreModel.getDefault().getProjectDescriptionManager();
            ICProjectDescription prjDescription = projectDescriptionManager.getProjectDescription(rc.getProject(), 8);
            if (prjDescription != null && (cfgDescription = prjDescription.getDefaultSettingConfiguration()) != null && CustomBuildSettingsDecorator.isCustomizedResource(cfgDescription, rc)) {
                decoration.addOverlay(CPluginImages.DESC_OVR_SETTING);
            }
        }
    }

    private static boolean isCustomizedResource(ICConfigurationDescription cfgDescription, IResource rc) {
        ICResourceDescription rcDescription;
        if (ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityEnabled((IProject)rc.getProject()) && cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
            IContainer parent = rc.getParent();
            List languages = LanguageSettingsManager.getLanguages((IResource)rc, (ICConfigurationDescription)cfgDescription);
            for (ILanguageSettingsProvider provider : ((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders()) {
                for (String languageId : languages) {
                    List listDefault;
                    List list = provider.getSettingEntries(cfgDescription, rc, languageId);
                    if (list == null || list == (listDefault = provider.getSettingEntries(cfgDescription, (IResource)parent, languageId))) continue;
                    return true;
                }
            }
        }
        return (rcDescription = cfgDescription.getResourceDescription(rc.getProjectRelativePath(), true)) != null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

