/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.jar.asmjdkbridge;

import java.io.IOException;
import java.io.InputStream;
import java.lang.classfile.Annotation;
import java.lang.classfile.AnnotationElement;
import java.lang.classfile.AnnotationValue;
import java.lang.classfile.AttributeMapper;
import java.lang.classfile.AttributedElement;
import java.lang.classfile.Attributes;
import java.lang.classfile.ClassElement;
import java.lang.classfile.ClassFile;
import java.lang.classfile.ClassModel;
import java.lang.classfile.CodeElement;
import java.lang.classfile.FieldModel;
import java.lang.classfile.Instruction;
import java.lang.classfile.MethodModel;
import java.lang.classfile.Opcode;
import java.lang.classfile.TypeAnnotation;
import java.lang.classfile.TypeKind;
import java.lang.classfile.attribute.CompilationIDAttribute;
import java.lang.classfile.attribute.ModuleHashesAttribute;
import java.lang.classfile.attribute.ModuleResolutionAttribute;
import java.lang.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import java.lang.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import java.lang.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import java.lang.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import java.lang.classfile.attribute.SourceIDAttribute;
import java.lang.classfile.attribute.StackMapFrameInfo;
import java.lang.classfile.attribute.UnknownAttribute;
import java.lang.classfile.constantpool.ClassEntry;
import java.lang.classfile.constantpool.Utf8Entry;
import java.lang.classfile.instruction.ArrayLoadInstruction;
import java.lang.classfile.instruction.ArrayStoreInstruction;
import java.lang.classfile.instruction.BranchInstruction;
import java.lang.classfile.instruction.CharacterRange;
import java.lang.classfile.instruction.ConstantInstruction;
import java.lang.classfile.instruction.ConvertInstruction;
import java.lang.classfile.instruction.DiscontinuedInstruction;
import java.lang.classfile.instruction.ExceptionCatch;
import java.lang.classfile.instruction.FieldInstruction;
import java.lang.classfile.instruction.IncrementInstruction;
import java.lang.classfile.instruction.InvokeDynamicInstruction;
import java.lang.classfile.instruction.InvokeInstruction;
import java.lang.classfile.instruction.LabelTarget;
import java.lang.classfile.instruction.LineNumber;
import java.lang.classfile.instruction.LoadInstruction;
import java.lang.classfile.instruction.LocalVariable;
import java.lang.classfile.instruction.LocalVariableType;
import java.lang.classfile.instruction.LookupSwitchInstruction;
import java.lang.classfile.instruction.MonitorInstruction;
import java.lang.classfile.instruction.NewMultiArrayInstruction;
import java.lang.classfile.instruction.NewObjectInstruction;
import java.lang.classfile.instruction.NewPrimitiveArrayInstruction;
import java.lang.classfile.instruction.NewReferenceArrayInstruction;
import java.lang.classfile.instruction.NopInstruction;
import java.lang.classfile.instruction.OperatorInstruction;
import java.lang.classfile.instruction.ReturnInstruction;
import java.lang.classfile.instruction.StackInstruction;
import java.lang.classfile.instruction.StoreInstruction;
import java.lang.classfile.instruction.SwitchCase;
import java.lang.classfile.instruction.TableSwitchInstruction;
import java.lang.classfile.instruction.ThrowInstruction;
import java.lang.classfile.instruction.TypeCheckInstruction;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.AccessFlag;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.Attribute;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.ConstantDynamic;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.ModuleVisitor;
import net.bytebuddy.jar.asm.RecordComponentVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.jar.asm.TypePath;
import net.bytebuddy.jar.asm.TypeReference;
import net.bytebuddy.jar.asmjdkbridge.AsmAttribute;
import net.bytebuddy.jar.asmjdkbridge.AsmWrappedAttribute;
import net.bytebuddy.jar.asmjdkbridge.JdkClassWriter;

public class JdkClassReader {
    private static final int SAME_LOCALS_1_STACK_ITEM_EXTENDED = 247;
    private static final int SAME_EXTENDED = 251;
    private final ClassModel classModel;
    private final AttributeFunction attributes;

    public JdkClassReader(byte[] classFile, Attribute ... attributePrototypes) {
        this.attributes = new AttributeFunction(attributePrototypes);
        this.classModel = ClassFile.of((ClassFile.Option[])new ClassFile.Option[]{ClassFile.AttributeMapperOption.of((Function)this.attributes)}).parse(classFile);
    }

    public JdkClassReader(InputStream inputStream, Attribute ... attributePrototypes) throws IOException {
        this(inputStream.readAllBytes(), attributePrototypes);
    }

    public JdkClassReader(String className, Attribute ... attributePrototypes) throws IOException {
        this.attributes = new AttributeFunction(attributePrototypes);
        ClassFile classFile = ClassFile.of((ClassFile.Option[])new ClassFile.Option[]{ClassFile.AttributeMapperOption.of((Function)this.attributes)});
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream(className.replace('.', '/') + ".class");){
            this.classModel = classFile.parse(inputStream.readAllBytes());
        }
    }

    ClassModel getClassModel() {
        return this.classModel;
    }

    public void accept(ClassVisitor classVisitor, int flags) {
        HashMap labels = new HashMap();
        classVisitor.visit(this.classModel.minorVersion() << 16 | this.classModel.majorVersion(), this.classModel.flags().flagsMask() | (this.classModel.findAttribute(Attributes.deprecated()).isPresent() ? 131072 : 0) | (this.classModel.findAttribute(Attributes.synthetic()).isPresent() ? 4096 : 0) | (this.classModel.findAttribute(Attributes.record()).isPresent() ? 65536 : 0), this.classModel.thisClass().asInternalName(), this.classModel.findAttribute(Attributes.signature()).map(signature -> signature.signature().stringValue()).orElse(null), this.classModel.superclass().map(ClassEntry::asInternalName).orElse(null), (String[])this.classModel.interfaces().stream().map(ClassEntry::asInternalName).toArray(String[]::new));
        if ((flags & 2) == 0) {
            String sourceFile = this.classModel.findAttribute(Attributes.sourceFile()).map(attribute -> attribute.sourceFile().stringValue()).orElse(null);
            String debug = this.classModel.findAttribute(Attributes.sourceDebugExtension()).map(attribute -> new String(attribute.contents(), StandardCharsets.UTF_8)).orElse(null);
            if (sourceFile != null || debug != null) {
                classVisitor.visitSource(sourceFile, debug);
            }
        }
        this.classModel.findAttribute(Attributes.module()).ifPresent(module -> {
            JdkClassWriter.WritingModuleVisitor writingModuleVisitor;
            String moduleVersion;
            int moduleFlags;
            String moduleName = module.moduleName().name().stringValue();
            ModuleVisitor moduleVisitor = classVisitor.visitModule(moduleName, moduleFlags = module.moduleFlagsMask(), moduleVersion = (String)module.moduleVersion().map(Utf8Entry::stringValue).orElse(null));
            if (moduleVisitor instanceof JdkClassWriter.WritingModuleVisitor && (writingModuleVisitor = (JdkClassWriter.WritingModuleVisitor)moduleVisitor).has(this.classModel, moduleName, moduleFlags, moduleVersion)) {
                this.classModel.findAttribute(Attributes.moduleMainClass()).ifPresent(writingModuleVisitor::add);
                this.classModel.findAttribute(Attributes.modulePackages()).ifPresent(writingModuleVisitor::add);
                writingModuleVisitor.add((ClassElement)module);
            } else if (moduleVisitor != null) {
                this.classModel.findAttribute(Attributes.moduleMainClass()).map(moduleMainClass -> moduleMainClass.mainClass().asInternalName()).ifPresent(moduleVisitor::visitMainClass);
                this.classModel.findAttribute(Attributes.modulePackages()).stream().flatMap(modulePackagesAttribute -> modulePackagesAttribute.packages().stream()).map(packageName -> packageName.name().stringValue()).forEach(moduleVisitor::visitPackage);
                module.requires().forEach(moduleRequire -> moduleVisitor.visitRequire(moduleRequire.requires().name().stringValue(), moduleRequire.requiresFlagsMask(), moduleRequire.requiresVersion().map(Utf8Entry::stringValue).orElse(null)));
                module.exports().forEach(moduleExport -> moduleVisitor.visitExport(moduleExport.exportedPackage().name().stringValue(), moduleExport.exportsFlagsMask(), moduleExport.exportsTo().isEmpty() ? null : (String[])moduleExport.exportsTo().stream().map(to -> to.name().stringValue()).toArray(String[]::new)));
                module.opens().forEach(moduleOpen -> moduleVisitor.visitOpen(moduleOpen.openedPackage().name().stringValue(), moduleOpen.opensFlagsMask(), moduleOpen.opensTo().isEmpty() ? null : (String[])moduleOpen.opensTo().stream().map(to -> to.name().stringValue()).toArray(String[]::new)));
                module.uses().forEach(moduleUses -> moduleVisitor.visitUse(moduleUses.asInternalName()));
                module.provides().forEach(provideInfo -> moduleVisitor.visitProvide(provideInfo.provides().asInternalName(), (String[])provideInfo.providesWith().stream().map(ClassEntry::asInternalName).toArray(String[]::new)));
                moduleVisitor.visitEnd();
            }
        });
        this.classModel.findAttribute(Attributes.nestHost()).ifPresent(nestHost -> classVisitor.visitNestHost(nestHost.nestHost().asInternalName()));
        this.classModel.findAttribute(Attributes.enclosingMethod()).ifPresent(enclosingMethod -> classVisitor.visitOuterClass(enclosingMethod.enclosingClass().asInternalName(), enclosingMethod.enclosingMethod().map(value -> value.name().stringValue()).orElse(null), enclosingMethod.enclosingMethod().map(value -> value.type().stringValue()).orElse(null)));
        this.acceptAnnotations((AttributedElement)this.classModel, classVisitor::visitAnnotation, classVisitor::visitTypeAnnotation);
        this.classModel.findAttribute(Attributes.sourceId()).ifPresent(sourceIDAttribute -> classVisitor.visitAttribute(new AsmWrappedAttribute.AsmSourceIdAttribute((SourceIDAttribute)sourceIDAttribute)));
        this.classModel.findAttribute(Attributes.compilationId()).ifPresent(sourceIDAttribute -> classVisitor.visitAttribute(new AsmWrappedAttribute.AsmCompilationIdAttribute((CompilationIDAttribute)sourceIDAttribute)));
        this.classModel.findAttribute(Attributes.moduleResolution()).ifPresent(moduleResolutionAttribute -> classVisitor.visitAttribute(new AsmWrappedAttribute.AsmModuleResolutionAttribute((ModuleResolutionAttribute)moduleResolutionAttribute)));
        this.classModel.findAttribute(Attributes.moduleHashes()).ifPresent(moduleResolutionAttribute -> classVisitor.visitAttribute(new AsmWrappedAttribute.AsmModuleHashesAttribute((ModuleHashesAttribute)moduleResolutionAttribute)));
        this.acceptAttributes((AttributedElement)this.classModel, false, classVisitor::visitAttribute);
        this.classModel.findAttribute(Attributes.nestMembers()).stream().flatMap(nestMembers -> nestMembers.nestMembers().stream()).forEach(nestMember -> classVisitor.visitNestMember(nestMember.asInternalName()));
        this.classModel.findAttribute(Attributes.permittedSubclasses()).stream().flatMap(permittedSubclasses -> permittedSubclasses.permittedSubclasses().stream()).forEach(nestMember -> classVisitor.visitPermittedSubclass(nestMember.asInternalName()));
        this.classModel.findAttribute(Attributes.innerClasses()).stream().flatMap(innerClasses -> innerClasses.classes().stream()).forEach(innerClass -> classVisitor.visitInnerClass(innerClass.innerClass().asInternalName(), innerClass.outerClass().map(ClassEntry::asInternalName).orElse(null), innerClass.innerName().map(Utf8Entry::stringValue).orElse(null), innerClass.flagsMask()));
        this.classModel.findAttribute(Attributes.record()).stream().flatMap(record -> record.components().stream()).forEach(recordComponent -> {
            RecordComponentVisitor recordComponentVisitor = classVisitor.visitRecordComponent(recordComponent.name().stringValue(), recordComponent.descriptor().stringValue(), recordComponent.findAttribute(Attributes.signature()).map(signature -> signature.signature().stringValue()).orElse(null));
            if (recordComponentVisitor != null) {
                this.acceptAnnotations((AttributedElement)recordComponent, recordComponentVisitor::visitAnnotation, recordComponentVisitor::visitTypeAnnotation);
                this.acceptAttributes((AttributedElement)recordComponent, false, recordComponentVisitor::visitAttribute);
                recordComponentVisitor.visitEnd();
            }
        });
        for (FieldModel fieldModel : this.classModel.fields()) {
            JdkClassWriter.WritingFieldVisitor writingFieldVisitor;
            Object fieldConstant;
            String fieldSignature;
            String fieldType;
            String fieldName;
            int fieldFlags = fieldModel.flags().flagsMask() | (fieldModel.findAttribute(Attributes.deprecated()).isPresent() ? 131072 : 0) | (fieldModel.findAttribute(Attributes.synthetic()).isPresent() ? 4096 : 0);
            FieldVisitor fieldVisitor = classVisitor.visitField(fieldFlags, fieldName = fieldModel.fieldName().stringValue(), fieldType = fieldModel.fieldType().stringValue(), fieldSignature = (String)fieldModel.findAttribute(Attributes.signature()).map(signature -> signature.signature().stringValue()).orElse(null), fieldConstant = fieldModel.findAttribute(Attributes.constantValue()).map(constantValue -> JdkClassReader.toAsmConstant(constantValue.constant().constantValue())).orElse(null));
            if (fieldVisitor instanceof JdkClassWriter.WritingFieldVisitor && (writingFieldVisitor = (JdkClassWriter.WritingFieldVisitor)fieldVisitor).has(this.classModel, fieldFlags, fieldName, fieldType, fieldSignature, fieldConstant)) {
                writingFieldVisitor.add(fieldModel);
                continue;
            }
            if (fieldVisitor == null) continue;
            this.acceptAnnotations((AttributedElement)fieldModel, fieldVisitor::visitAnnotation, fieldVisitor::visitTypeAnnotation);
            this.acceptAttributes((AttributedElement)fieldModel, false, fieldVisitor::visitAttribute);
            fieldVisitor.visitEnd();
        }
        for (MethodModel methodModel : this.classModel.methods()) {
            JdkClassWriter.WritingMethodVisitor writingMethodVisitor;
            String[] methodExceptions;
            String methodSignature;
            String methodType;
            String methodName;
            int methodFlags = methodModel.flags().flagsMask() | (methodModel.findAttribute(Attributes.deprecated()).isPresent() ? 131072 : 0) | (methodModel.findAttribute(Attributes.synthetic()).isPresent() ? 4096 : 0);
            MethodVisitor methodVisitor = classVisitor.visitMethod(methodFlags, methodName = methodModel.methodName().stringValue(), methodType = methodModel.methodType().stringValue(), methodSignature = (String)methodModel.findAttribute(Attributes.signature()).map(signature -> signature.signature().stringValue()).orElse(null), methodExceptions = (String[])methodModel.findAttribute(Attributes.exceptions()).map(exceptions -> (String[])exceptions.exceptions().stream().map(ClassEntry::asInternalName).toArray(String[]::new)).orElse(null));
            if (methodVisitor instanceof JdkClassWriter.WritingMethodVisitor && (writingMethodVisitor = (JdkClassWriter.WritingMethodVisitor)methodVisitor).has(this.classModel, methodFlags, methodName, methodType, methodSignature, methodExceptions)) {
                writingMethodVisitor.add(methodModel);
                continue;
            }
            if (methodVisitor == null) continue;
            if ((flags & 2) == 0) {
                methodModel.findAttribute(Attributes.methodParameters()).stream().flatMap(methodParameters -> methodParameters.parameters().stream()).forEach(methodParameter -> methodVisitor.visitParameter(methodParameter.name().map(Utf8Entry::stringValue).orElse(null), methodParameter.flagsMask()));
            }
            methodModel.findAttribute(Attributes.annotationDefault()).ifPresent(annotationDefault -> {
                AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotationDefault();
                if (annotationVisitor != null) {
                    this.appendAnnotationValue(annotationVisitor, null, annotationDefault.defaultValue());
                    annotationVisitor.visitEnd();
                }
            });
            this.acceptAnnotations((AttributedElement)methodModel, methodVisitor::visitAnnotation, methodVisitor::visitTypeAnnotation);
            this.acceptParameterAnnotations(methodModel, methodVisitor, true);
            this.acceptParameterAnnotations(methodModel, methodVisitor, false);
            this.acceptAttributes((AttributedElement)methodModel, false, methodVisitor::visitAttribute);
            methodModel.findAttribute(Attributes.code()).filter(codeAttribute -> (flags & 1) == 0).ifPresent(code -> {
                int localVariablesSize = Type.getMethodType(methodModel.methodType().stringValue()).getArgumentTypes().length + (methodModel.flags().has(AccessFlag.STATIC) ? 0 : 1);
                Map frames = (flags & 4) == 0 ? code.findAttribute(Attributes.stackMapTable()).map(stackMapTable -> stackMapTable.entries().stream().collect(Collectors.toMap(StackMapFrameInfo::target, Function.identity()))).orElse(Collections.emptyMap()) : Map.of();
                LinkedHashMap<MergedLocalVariableKey, MergedLocalVariableValue> localVariables = new LinkedHashMap<MergedLocalVariableKey, MergedLocalVariableValue>();
                IdentityHashMap<Label, List<Map.Entry<TypeAnnotation, Boolean>>> offsetTypeAnnotations = new IdentityHashMap<Label, List<Map.Entry<TypeAnnotation, Boolean>>>();
                ArrayList<Map.Entry<TypeAnnotation, Boolean>> localVariableAnnotations = new ArrayList<Map.Entry<TypeAnnotation, Boolean>>();
                ArrayList<CharacterRange> characterRanges = new ArrayList<CharacterRange>();
                methodVisitor.visitCode();
                Label currentPositionLabel = null;
                PushbackIterator<CodeElement> it = new PushbackIterator<CodeElement>(code.iterator());
                while (it.hasNext()) {
                    CodeElement selector0$temp;
                    CodeElement element = (CodeElement)it.next();
                    Objects.requireNonNull(element);
                    int index$1 = 0;
                    block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MonitorInstruction.class, TypeCheckInstruction.class, LoadInstruction.class, OperatorInstruction.class, ReturnInstruction.class, InvokeInstruction.class, IncrementInstruction.class, FieldInstruction.class, InvokeDynamicInstruction.class, BranchInstruction.class, StoreInstruction.class, NewReferenceArrayInstruction.class, LookupSwitchInstruction.class, TableSwitchInstruction.class, ArrayStoreInstruction.class, ArrayLoadInstruction.class, ConstantInstruction.class, StackInstruction.class, NopInstruction.class, ThrowInstruction.class, NewObjectInstruction.class, ConvertInstruction.class, NewMultiArrayInstruction.class, NewPrimitiveArrayInstruction.class, LocalVariableType.class, ExceptionCatch.class, LocalVariable.class, LineNumber.class, LabelTarget.class, CharacterRange.class, RuntimeVisibleTypeAnnotationsAttribute.class, RuntimeInvisibleTypeAnnotationsAttribute.class, DiscontinuedInstruction.JsrInstruction.class, DiscontinuedInstruction.RetInstruction.class}, (CodeElement)selector0$temp, index$1)) {
                        case 0: {
                            MonitorInstruction value2 = (MonitorInstruction)selector0$temp;
                            methodVisitor.visitInsn(value2.opcode().bytecode());
                            break;
                        }
                        case 1: {
                            TypeCheckInstruction value3 = (TypeCheckInstruction)selector0$temp;
                            methodVisitor.visitTypeInsn(value3.opcode().bytecode(), value3.type().asInternalName());
                            break;
                        }
                        case 2: {
                            LoadInstruction value4 = (LoadInstruction)selector0$temp;
                            methodVisitor.visitVarInsn(switch (value4.typeKind()) {
                                case TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.CHAR, TypeKind.SHORT, TypeKind.INT -> 21;
                                case TypeKind.LONG -> 22;
                                case TypeKind.FLOAT -> 23;
                                case TypeKind.DOUBLE -> 24;
                                case TypeKind.REFERENCE -> 25;
                                default -> throw new IllegalStateException("Unexpected type: " + String.valueOf(value4.typeKind()));
                            }, value4.slot());
                            break;
                        }
                        case 3: {
                            OperatorInstruction value5 = (OperatorInstruction)selector0$temp;
                            methodVisitor.visitInsn(value5.opcode().bytecode());
                            break;
                        }
                        case 4: {
                            ReturnInstruction value6 = (ReturnInstruction)selector0$temp;
                            methodVisitor.visitInsn(value6.opcode().bytecode());
                            break;
                        }
                        case 5: {
                            InvokeInstruction value7 = (InvokeInstruction)selector0$temp;
                            methodVisitor.visitMethodInsn(value7.opcode().bytecode(), value7.owner().asInternalName(), value7.name().stringValue(), value7.type().stringValue(), value7.isInterface());
                            break;
                        }
                        case 6: {
                            IncrementInstruction value8 = (IncrementInstruction)selector0$temp;
                            methodVisitor.visitIincInsn(value8.slot(), value8.constant());
                            break;
                        }
                        case 7: {
                            FieldInstruction value9 = (FieldInstruction)selector0$temp;
                            methodVisitor.visitFieldInsn(value9.opcode().bytecode(), value9.owner().asInternalName(), value9.name().stringValue(), value9.type().stringValue());
                            break;
                        }
                        case 8: {
                            InvokeDynamicInstruction value10 = (InvokeDynamicInstruction)selector0$temp;
                            methodVisitor.visitInvokeDynamicInsn(value10.name().stringValue(), value10.type().stringValue(), (Handle)JdkClassReader.toAsmConstant(value10.bootstrapMethod()), value10.bootstrapArgs().stream().map(JdkClassReader::toAsmConstant).toArray());
                            break;
                        }
                        case 9: {
                            BranchInstruction value11 = (BranchInstruction)selector0$temp;
                            methodVisitor.visitJumpInsn(value11.opcode() == Opcode.GOTO_W ? 167 : value11.opcode().bytecode(), labels.computeIfAbsent(value11.target(), label -> new Label()));
                            break;
                        }
                        case 10: {
                            StoreInstruction value12 = (StoreInstruction)selector0$temp;
                            methodVisitor.visitVarInsn(switch (value12.typeKind()) {
                                case TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.CHAR, TypeKind.SHORT, TypeKind.INT -> 54;
                                case TypeKind.LONG -> 55;
                                case TypeKind.FLOAT -> 56;
                                case TypeKind.DOUBLE -> 57;
                                case TypeKind.REFERENCE -> 58;
                                default -> throw new IllegalStateException("Unexpected type: " + String.valueOf(value12.typeKind()));
                            }, value12.slot());
                            break;
                        }
                        case 11: {
                            NewReferenceArrayInstruction value13 = (NewReferenceArrayInstruction)selector0$temp;
                            methodVisitor.visitTypeInsn(value13.opcode().bytecode(), value13.componentType().asInternalName());
                            break;
                        }
                        case 12: {
                            LookupSwitchInstruction value14 = (LookupSwitchInstruction)selector0$temp;
                            methodVisitor.visitLookupSwitchInsn(labels.computeIfAbsent(value14.defaultTarget(), label -> new Label()), value14.cases().stream().mapToInt(SwitchCase::caseValue).toArray(), (Label[])value14.cases().stream().map(aCase -> labels.computeIfAbsent(aCase.target(), label -> new Label())).toArray(Label[]::new));
                            break;
                        }
                        case 13: {
                            TableSwitchInstruction value15 = (TableSwitchInstruction)selector0$temp;
                            Map cases = value15.cases().stream().collect(Collectors.toMap(SwitchCase::caseValue, Function.identity()));
                            Label dflt = labels.computeIfAbsent(value15.defaultTarget(), label -> new Label());
                            methodVisitor.visitTableSwitchInsn(value15.lowValue(), value15.highValue(), dflt, (Label[])IntStream.rangeClosed(value15.lowValue(), value15.highValue()).mapToObj(index -> {
                                SwitchCase switchCase = (SwitchCase)cases.get(index);
                                return switchCase == null ? dflt : labels.computeIfAbsent(switchCase.target(), label -> new Label());
                            }).toArray(Label[]::new));
                            break;
                        }
                        case 14: {
                            ArrayStoreInstruction value16 = (ArrayStoreInstruction)selector0$temp;
                            methodVisitor.visitInsn(value16.opcode().bytecode());
                            break;
                        }
                        case 15: {
                            ArrayLoadInstruction value17 = (ArrayLoadInstruction)selector0$temp;
                            methodVisitor.visitInsn(value17.opcode().bytecode());
                            break;
                        }
                        case 16: {
                            ConstantInstruction value18 = (ConstantInstruction)selector0$temp;
                            switch (value18.opcode()) {
                                case LDC: 
                                case LDC_W: 
                                case LDC2_W: {
                                    methodVisitor.visitLdcInsn(JdkClassReader.toAsmConstant(value18.constantValue()));
                                    break block0;
                                }
                                case BIPUSH: 
                                case SIPUSH: {
                                    methodVisitor.visitIntInsn(value18.opcode().bytecode(), (Integer)value18.constantValue());
                                    break block0;
                                }
                            }
                            methodVisitor.visitInsn(value18.opcode().bytecode());
                            break;
                        }
                        case 17: {
                            StackInstruction value19 = (StackInstruction)selector0$temp;
                            methodVisitor.visitInsn(value19.opcode().bytecode());
                            break;
                        }
                        case 18: {
                            NopInstruction value20 = (NopInstruction)selector0$temp;
                            methodVisitor.visitInsn(value20.opcode().bytecode());
                            break;
                        }
                        case 19: {
                            ThrowInstruction value21 = (ThrowInstruction)selector0$temp;
                            methodVisitor.visitInsn(value21.opcode().bytecode());
                            break;
                        }
                        case 20: {
                            NewObjectInstruction value22 = (NewObjectInstruction)selector0$temp;
                            methodVisitor.visitTypeInsn(value22.opcode().bytecode(), value22.className().asInternalName());
                            break;
                        }
                        case 21: {
                            ConvertInstruction value23 = (ConvertInstruction)selector0$temp;
                            methodVisitor.visitInsn(value23.opcode().bytecode());
                            break;
                        }
                        case 22: {
                            NewMultiArrayInstruction value24 = (NewMultiArrayInstruction)selector0$temp;
                            methodVisitor.visitMultiANewArrayInsn(value24.arrayType().asInternalName(), value24.dimensions());
                            break;
                        }
                        case 23: {
                            NewPrimitiveArrayInstruction value25 = (NewPrimitiveArrayInstruction)selector0$temp;
                            methodVisitor.visitIntInsn(value25.opcode().bytecode(), value25.typeKind().newarrayCode());
                            break;
                        }
                        case 24: {
                            LocalVariableType value26 = (LocalVariableType)selector0$temp;
                            localVariables.compute(new MergedLocalVariableKey(labels.computeIfAbsent(value26.startScope(), label -> new Label()), labels.computeIfAbsent(value26.endScope(), label -> new Label()), value26.name().stringValue(), value26.slot()), (mergedLocalVariableKey, values) -> new MergedLocalVariableValue(values == null ? null : values.descriptor, value26.signature().stringValue()));
                            break;
                        }
                        case 25: {
                            ExceptionCatch value27 = (ExceptionCatch)selector0$temp;
                            methodVisitor.visitTryCatchBlock(labels.computeIfAbsent(value27.tryStart(), label -> new Label()), labels.computeIfAbsent(value27.tryEnd(), label -> new Label()), labels.computeIfAbsent(value27.handler(), label -> new Label()), value27.catchType().map(ClassEntry::asInternalName).orElse(null));
                            break;
                        }
                        case 26: {
                            LocalVariable value28 = (LocalVariable)selector0$temp;
                            localVariables.compute(new MergedLocalVariableKey(labels.computeIfAbsent(value28.startScope(), label -> new Label()), labels.computeIfAbsent(value28.endScope(), label -> new Label()), value28.name().stringValue(), value28.slot()), (mergedLocalVariableKey, values) -> new MergedLocalVariableValue(value28.typeSymbol().descriptorString(), values == null ? null : values.signature));
                            break;
                        }
                        case 27: {
                            LineNumber value29 = (LineNumber)selector0$temp;
                            if ((flags & 2) != 0) break;
                            if (currentPositionLabel == null) {
                                currentPositionLabel = new Label();
                                methodVisitor.visitLabel(currentPositionLabel);
                            }
                            methodVisitor.visitLineNumber(value29.line(), currentPositionLabel);
                            break;
                        }
                        case 28: {
                            LabelTarget value30 = (LabelTarget)selector0$temp;
                            currentPositionLabel = labels.computeIfAbsent(value30.label(), label -> new Label());
                            methodVisitor.visitLabel(currentPositionLabel);
                            StackMapFrameInfo frame = (StackMapFrameInfo)frames.get(value30.label());
                            if (frame == null) break;
                            if ((flags & 2) == 0 && it.hasNext()) {
                                CodeElement next = (CodeElement)it.next();
                                if (next instanceof LineNumber) {
                                    LineNumber line = (LineNumber)next;
                                    methodVisitor.visitLineNumber(line.line(), currentPositionLabel);
                                } else {
                                    it.push(next);
                                }
                            }
                            if ((flags & 8) != 0) {
                                methodVisitor.visitFrame(-1, frame.locals().size(), frame.locals().isEmpty() ? null : frame.locals().stream().map(verificationTypeInfo -> JdkClassReader.toAsmFrameValue(verificationTypeInfo, labels)).toArray(), frame.stack().size(), frame.stack().isEmpty() ? null : frame.stack().stream().map(verificationTypeInfo -> JdkClassReader.toAsmFrameValue(verificationTypeInfo, labels)).toArray());
                                break;
                            }
                            if (frame.frameType() < 64) {
                                methodVisitor.visitFrame(3, 0, null, 0, null);
                                break;
                            }
                            if (frame.frameType() < 128) {
                                methodVisitor.visitFrame(4, 0, null, 1, new Object[]{JdkClassReader.toAsmFrameValue((StackMapFrameInfo.VerificationTypeInfo)frame.stack().getFirst(), labels)});
                                break;
                            }
                            if (frame.frameType() < 247) {
                                throw new IllegalArgumentException("Invalid stackmap frame type: " + frame.frameType());
                            }
                            if (frame.frameType() == 247) {
                                methodVisitor.visitFrame(4, 0, null, 1, new Object[]{JdkClassReader.toAsmFrameValue((StackMapFrameInfo.VerificationTypeInfo)frame.stack().getFirst(), labels)});
                                break;
                            }
                            if (frame.frameType() < 251) {
                                methodVisitor.visitFrame(2, localVariablesSize - frame.locals().size(), null, 0, null);
                                localVariablesSize = frame.locals().size();
                                break;
                            }
                            if (frame.frameType() == 251) {
                                methodVisitor.visitFrame(3, 0, null, 0, null);
                                break;
                            }
                            if (frame.frameType() < 255) {
                                int appended = frame.locals().size() - localVariablesSize;
                                methodVisitor.visitFrame(1, appended, frame.locals().stream().skip(localVariablesSize).map(verificationTypeInfo -> JdkClassReader.toAsmFrameValue(verificationTypeInfo, labels)).toArray(), 0, null);
                                localVariablesSize = frame.locals().size();
                                break;
                            }
                            methodVisitor.visitFrame(0, frame.locals().size(), frame.locals().stream().map(verificationTypeInfo -> JdkClassReader.toAsmFrameValue(verificationTypeInfo, labels)).toArray(), frame.stack().size(), frame.stack().stream().map(verificationTypeInfo -> JdkClassReader.toAsmFrameValue(verificationTypeInfo, labels)).toArray());
                            localVariablesSize = frame.locals().size();
                            break;
                        }
                        case 29: {
                            CharacterRange characterRange = (CharacterRange)selector0$temp;
                            characterRanges.add(characterRange);
                            break;
                        }
                        case 30: {
                            RuntimeVisibleTypeAnnotationsAttribute value31 = (RuntimeVisibleTypeAnnotationsAttribute)selector0$temp;
                            this.appendCodeAnnotations(value31.annotations(), true, methodVisitor, labels, localVariableAnnotations, offsetTypeAnnotations);
                            break;
                        }
                        case 31: {
                            RuntimeInvisibleTypeAnnotationsAttribute value32 = (RuntimeInvisibleTypeAnnotationsAttribute)selector0$temp;
                            this.appendCodeAnnotations(value32.annotations(), false, methodVisitor, labels, localVariableAnnotations, offsetTypeAnnotations);
                            break;
                        }
                        case 32: {
                            DiscontinuedInstruction.JsrInstruction value33 = (DiscontinuedInstruction.JsrInstruction)selector0$temp;
                            methodVisitor.visitJumpInsn((value33.opcode() == Opcode.JSR_W ? Opcode.JSR : value33.opcode()).bytecode(), labels.computeIfAbsent(value33.target(), label -> new Label()));
                            break;
                        }
                        case 33: {
                            DiscontinuedInstruction.RetInstruction value34 = (DiscontinuedInstruction.RetInstruction)selector0$temp;
                            methodVisitor.visitVarInsn((value34.opcode() == Opcode.RET_W ? Opcode.RET : value34.opcode()).bytecode(), value34.slot());
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unknown value: " + String.valueOf(element));
                        }
                    }
                    if (!(element instanceof Instruction)) continue;
                    offsetTypeAnnotations.getOrDefault(currentPositionLabel, Collections.emptyList()).forEach(entry -> this.appendAnnotationValues(methodVisitor.visitInsnAnnotation(TypeReference.newTypeReference(((TypeAnnotation)entry.getKey()).targetInfo().targetType().targetTypeValue()).getValue(), JdkClassReader.toTypePath(((TypeAnnotation)entry.getKey()).targetPath()), ((TypeAnnotation)entry.getKey()).annotation().className().stringValue(), (Boolean)entry.getValue()), ((TypeAnnotation)entry.getKey()).annotation().elements()));
                    currentPositionLabel = null;
                }
                if ((flags & 2) == 0) {
                    localVariables.forEach((key, value) -> methodVisitor.visitLocalVariable(key.name(), value.descriptor(), value.signature(), key.start(), key.end(), key.slot()));
                }
                localVariableAnnotations.forEach(entry -> {
                    TypeAnnotation.LocalVarTarget target = (TypeAnnotation.LocalVarTarget)((TypeAnnotation)entry.getKey()).targetInfo();
                    this.appendAnnotationValues(methodVisitor.visitLocalVariableAnnotation(TypeReference.newTypeReference(((TypeAnnotation)entry.getKey()).targetInfo().targetType().targetTypeValue()).getValue(), JdkClassReader.toTypePath(((TypeAnnotation)entry.getKey()).targetPath()), (Label[])target.table().stream().map(localVarTargetInfo -> (Label)labels.get(localVarTargetInfo.startLabel())).toArray(Label[]::new), (Label[])target.table().stream().map(localVarTargetInfo -> (Label)labels.get(localVarTargetInfo.endLabel())).toArray(Label[]::new), target.table().stream().mapToInt(TypeAnnotation.LocalVarTargetInfo::index).toArray(), ((TypeAnnotation)entry.getKey()).annotation().className().stringValue(), (Boolean)entry.getValue()), ((TypeAnnotation)entry.getKey()).annotation().elements());
                });
                code.findAttribute(Attributes.characterRangeTable()).ifPresent(characterRangeTableAttribute -> methodVisitor.visitAttribute(AsmWrappedAttribute.AsmCharacterRangeTableAttribute.of(characterRanges, code)));
                this.acceptAttributes((AttributedElement)code, true, methodVisitor::visitAttribute);
                methodVisitor.visitMaxs(code.maxStack(), code.maxLocals());
            });
            methodVisitor.visitEnd();
        }
        classVisitor.visitEnd();
    }

    private void acceptAnnotations(AttributedElement element, AnnotationVisitorSource annotationVisitorSource, TypeAnnotationVisitorSource typeAnnotationVisitorSource) {
        element.findAttribute(Attributes.runtimeVisibleAnnotations()).stream().flatMap(annotations -> annotations.annotations().stream()).forEach(annotation -> this.appendAnnotationValues(annotationVisitorSource.visitAnnotation(annotation.className().stringValue(), true), annotation.elements()));
        element.findAttribute(Attributes.runtimeInvisibleAnnotations()).stream().flatMap(annotations -> annotations.annotations().stream()).forEach(annotation -> this.appendAnnotationValues(annotationVisitorSource.visitAnnotation(annotation.className().stringValue(), false), annotation.elements()));
        element.findAttribute(Attributes.runtimeVisibleTypeAnnotations()).stream().flatMap(annotations -> annotations.annotations().stream()).forEach(annotation -> this.appendAnnotationValues(typeAnnotationVisitorSource.visitTypeAnnotation(JdkClassReader.toTypeReference(annotation.targetInfo()).getValue(), JdkClassReader.toTypePath(annotation.targetPath()), annotation.annotation().className().stringValue(), true), annotation.annotation().elements()));
        element.findAttribute(Attributes.runtimeInvisibleTypeAnnotations()).stream().flatMap(annotations -> annotations.annotations().stream()).forEach(annotation -> this.appendAnnotationValues(typeAnnotationVisitorSource.visitTypeAnnotation(JdkClassReader.toTypeReference(annotation.targetInfo()).getValue(), JdkClassReader.toTypePath(annotation.targetPath()), annotation.annotation().className().stringValue(), false), annotation.annotation().elements()));
    }

    private void acceptParameterAnnotations(MethodModel methodModel, MethodVisitor methodVisitor, boolean visible) {
        int count = methodModel.findAttribute(Attributes.methodParameters()).map(parameters -> (int)parameters.parameters().stream().filter(parameter -> !parameter.has(AccessFlag.SYNTHETIC) && !parameter.has(AccessFlag.MANDATED)).count()).orElseGet(() -> methodModel.methodTypeSymbol().parameterCount());
        Optional<List> target = visible ? methodModel.findAttribute(Attributes.runtimeVisibleParameterAnnotations()).map(RuntimeVisibleParameterAnnotationsAttribute::parameterAnnotations) : methodModel.findAttribute(Attributes.runtimeInvisibleParameterAnnotations()).map(RuntimeInvisibleParameterAnnotationsAttribute::parameterAnnotations);
        target.ifPresent(annotations -> {
            methodVisitor.visitAnnotableParameterCount(count, visible);
            for (int index = 0; index < annotations.size(); ++index) {
                for (Annotation annotation : (List)annotations.get(index)) {
                    this.appendAnnotationValues(methodVisitor.visitParameterAnnotation(index, annotation.className().stringValue(), visible), annotation.elements());
                }
            }
        });
    }

    private void acceptAttributes(AttributedElement element, boolean code, Consumer<Attribute> consumer) {
        this.attributes.mappers.forEach((string, value) -> element.findAttributes(value.attributeMapper()).forEach(attribute -> consumer.accept(attribute.attribute)));
        element.attributes().stream().filter(attribute -> attribute instanceof UnknownAttribute).forEach(attribute -> consumer.accept(new AsmWrappedAttribute.AsmUnknownAttribute((UnknownAttribute)attribute, code)));
    }

    private void appendAnnotationValues(AnnotationVisitor annotationVisitor, List<AnnotationElement> elements) {
        if (annotationVisitor != null) {
            elements.forEach(element -> this.appendAnnotationValue(annotationVisitor, element.name().stringValue(), element.value()));
            annotationVisitor.visitEnd();
        }
    }

    private void appendAnnotationValue(AnnotationVisitor annotationVisitor, String name, AnnotationValue annotationValue) {
        JdkClassWriter.WritingAnnotationVisitor writingAnnotationVisitor;
        if (annotationVisitor instanceof JdkClassWriter.WritingAnnotationVisitor && (writingAnnotationVisitor = (JdkClassWriter.WritingAnnotationVisitor)annotationVisitor).has(this.classModel)) {
            writingAnnotationVisitor.add(name, annotationValue);
            return;
        }
        AnnotationValue annotationValue2 = annotationValue;
        Objects.requireNonNull(annotationValue2);
        AnnotationValue annotationValue3 = annotationValue2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnnotationValue.OfBoolean.class, AnnotationValue.OfByte.class, AnnotationValue.OfShort.class, AnnotationValue.OfChar.class, AnnotationValue.OfInt.class, AnnotationValue.OfLong.class, AnnotationValue.OfFloat.class, AnnotationValue.OfDouble.class, AnnotationValue.OfString.class, AnnotationValue.OfClass.class, AnnotationValue.OfAnnotation.class, AnnotationValue.OfEnum.class, AnnotationValue.OfArray.class}, (AnnotationValue)annotationValue3, n)) {
            case 0: {
                AnnotationValue.OfBoolean value = (AnnotationValue.OfBoolean)annotationValue3;
                annotationVisitor.visit(name, value.booleanValue());
                break;
            }
            case 1: {
                AnnotationValue.OfByte value = (AnnotationValue.OfByte)annotationValue3;
                annotationVisitor.visit(name, value.byteValue());
                break;
            }
            case 2: {
                AnnotationValue.OfShort value = (AnnotationValue.OfShort)annotationValue3;
                annotationVisitor.visit(name, value.shortValue());
                break;
            }
            case 3: {
                AnnotationValue.OfChar value = (AnnotationValue.OfChar)annotationValue3;
                annotationVisitor.visit(name, Character.valueOf(value.charValue()));
                break;
            }
            case 4: {
                AnnotationValue.OfInt value = (AnnotationValue.OfInt)annotationValue3;
                annotationVisitor.visit(name, value.intValue());
                break;
            }
            case 5: {
                AnnotationValue.OfLong value = (AnnotationValue.OfLong)annotationValue3;
                annotationVisitor.visit(name, value.longValue());
                break;
            }
            case 6: {
                AnnotationValue.OfFloat value = (AnnotationValue.OfFloat)annotationValue3;
                annotationVisitor.visit(name, Float.valueOf(value.floatValue()));
                break;
            }
            case 7: {
                AnnotationValue.OfDouble value = (AnnotationValue.OfDouble)annotationValue3;
                annotationVisitor.visit(name, value.doubleValue());
                break;
            }
            case 8: {
                AnnotationValue.OfString value = (AnnotationValue.OfString)annotationValue3;
                annotationVisitor.visit(name, JdkClassReader.toAsmConstant((ConstantDesc)((Object)value.stringValue())));
                break;
            }
            case 9: {
                AnnotationValue.OfClass value = (AnnotationValue.OfClass)annotationValue3;
                annotationVisitor.visit(name, Type.getType(value.className().stringValue()));
                break;
            }
            case 10: {
                AnnotationValue.OfAnnotation value = (AnnotationValue.OfAnnotation)annotationValue3;
                this.appendAnnotationValues(annotationVisitor.visitAnnotation(name, value.annotation().className().stringValue()), value.annotation().elements());
                break;
            }
            case 11: {
                AnnotationValue.OfEnum value = (AnnotationValue.OfEnum)annotationValue3;
                annotationVisitor.visitEnum(name, value.className().stringValue(), value.constantName().stringValue());
                break;
            }
            case 12: {
                AnnotationVisitor nested;
                AnnotationValue.OfArray value = (AnnotationValue.OfArray)annotationValue3;
                Set tags = value.values().stream().map(AnnotationValue::tag).collect(Collectors.toSet());
                if (tags.size() == 1) {
                    switch ((Integer)tags.iterator().next()) {
                        case 90: {
                            boolean[] array = new boolean[value.values().size()];
                            for (int index = 0; index < value.values().size(); ++index) {
                                array[index] = ((AnnotationValue.OfBoolean)value.values().get(index)).booleanValue();
                            }
                            annotationVisitor.visit(name, array);
                            return;
                        }
                        case 66: {
                            byte[] array = new byte[value.values().size()];
                            for (int index = 0; index < value.values().size(); ++index) {
                                array[index] = ((AnnotationValue.OfByte)value.values().get(index)).byteValue();
                            }
                            annotationVisitor.visit(name, array);
                            return;
                        }
                        case 83: {
                            short[] array = new short[value.values().size()];
                            for (int index = 0; index < value.values().size(); ++index) {
                                array[index] = ((AnnotationValue.OfShort)value.values().get(index)).shortValue();
                            }
                            annotationVisitor.visit(name, array);
                            return;
                        }
                        case 67: {
                            char[] array = new char[value.values().size()];
                            for (int index = 0; index < value.values().size(); ++index) {
                                array[index] = ((AnnotationValue.OfChar)value.values().get(index)).charValue();
                            }
                            annotationVisitor.visit(name, array);
                            return;
                        }
                        case 73: {
                            int[] array = new int[value.values().size()];
                            for (int index = 0; index < value.values().size(); ++index) {
                                array[index] = ((AnnotationValue.OfInt)value.values().get(index)).intValue();
                            }
                            annotationVisitor.visit(name, array);
                            return;
                        }
                        case 74: {
                            long[] array = new long[value.values().size()];
                            for (int index = 0; index < value.values().size(); ++index) {
                                array[index] = ((AnnotationValue.OfLong)value.values().get(index)).longValue();
                            }
                            annotationVisitor.visit(name, array);
                            return;
                        }
                        case 70: {
                            float[] array = new float[value.values().size()];
                            for (int index = 0; index < value.values().size(); ++index) {
                                array[index] = ((AnnotationValue.OfFloat)value.values().get(index)).floatValue();
                            }
                            annotationVisitor.visit(name, array);
                            return;
                        }
                        case 68: {
                            double[] array = new double[value.values().size()];
                            for (int index = 0; index < value.values().size(); ++index) {
                                array[index] = ((AnnotationValue.OfDouble)value.values().get(index)).doubleValue();
                            }
                            annotationVisitor.visit(name, array);
                            return;
                        }
                    }
                }
                if ((nested = annotationVisitor.visitArray(name)) == null) break;
                value.values().forEach(entry -> this.appendAnnotationValue(nested, null, (AnnotationValue)entry));
                nested.visitEnd();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown annotation value: " + String.valueOf(annotationValue));
            }
        }
    }

    private void appendCodeAnnotations(List<TypeAnnotation> typeAnnotations, boolean visible, MethodVisitor methodVisitor, Map<java.lang.classfile.Label, Label> labels, List<Map.Entry<TypeAnnotation, Boolean>> localVariableAnnotations, Map<Label, List<Map.Entry<TypeAnnotation, Boolean>>> offsetTypeAnnotations) {
        typeAnnotations.forEach(typeAnnotation -> {
            TypeAnnotation.TargetInfo targetInfo = typeAnnotation.targetInfo();
            Objects.requireNonNull(targetInfo);
            TypeAnnotation.TargetInfo selector0$temp = targetInfo;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeAnnotation.LocalVarTarget.class, TypeAnnotation.OffsetTarget.class, TypeAnnotation.CatchTarget.class}, (TypeAnnotation.TargetInfo)selector0$temp, index$1)) {
                case 0: {
                    TypeAnnotation.LocalVarTarget ignored = (TypeAnnotation.LocalVarTarget)selector0$temp;
                    localVariableAnnotations.add(Map.entry(typeAnnotation, visible));
                    break;
                }
                case 1: {
                    TypeAnnotation.OffsetTarget value = (TypeAnnotation.OffsetTarget)selector0$temp;
                    offsetTypeAnnotations.merge(labels.computeIfAbsent(value.target(), label -> new Label()), Collections.singletonList(Map.entry(typeAnnotation, visible)), (left, right) -> Stream.of(left.stream(), right.stream()).flatMap(Function.identity()).collect(Collectors.toList()));
                    break;
                }
                case 2: {
                    TypeAnnotation.CatchTarget value = (TypeAnnotation.CatchTarget)selector0$temp;
                    this.appendAnnotationValues(methodVisitor.visitTryCatchAnnotation(TypeReference.newTypeReference(value.targetType().targetTypeValue()).getValue(), JdkClassReader.toTypePath(typeAnnotation.targetPath()), typeAnnotation.annotation().className().stringValue(), visible), typeAnnotation.annotation().elements());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected target: " + String.valueOf(typeAnnotation.targetInfo()));
                }
            }
        });
    }

    static Object toAsmConstant(ConstantDesc constant) {
        ConstantDesc constantDesc = constant;
        Objects.requireNonNull(constantDesc);
        ConstantDesc constantDesc2 = constantDesc;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class, Long.class, Float.class, Double.class, ClassDesc.class, MethodTypeDesc.class, DirectMethodHandleDesc.class, MethodHandleDesc.class, DynamicConstantDesc.class}, (ConstantDesc)constantDesc2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                String value = (String)((Object)constantDesc2);
                yield value;
            }
            case 1 -> {
                Integer value = (Integer)constantDesc2;
                yield value;
            }
            case 2 -> {
                Long value = (Long)constantDesc2;
                yield value;
            }
            case 3 -> {
                Float value = (Float)constantDesc2;
                yield value;
            }
            case 4 -> {
                Double value = (Double)constantDesc2;
                yield value;
            }
            case 5 -> {
                ClassDesc value = (ClassDesc)constantDesc2;
                yield Type.getType(value.descriptorString());
            }
            case 6 -> {
                MethodTypeDesc value = (MethodTypeDesc)constantDesc2;
                yield Type.getMethodType(value.descriptorString());
            }
            case 7 -> {
                DirectMethodHandleDesc value = (DirectMethodHandleDesc)constantDesc2;
                yield new Handle(value.refKind(), JdkClassReader.toInternalName(value.owner()), value.methodName(), value.lookupDescriptor(), value.isOwnerInterface());
            }
            case 8 -> {
                MethodHandleDesc value = (MethodHandleDesc)constantDesc2;
                throw new UnsupportedOperationException("Cannot map non-direct method handle to ASM constant: " + String.valueOf(value));
            }
            case 9 -> {
                DynamicConstantDesc value = (DynamicConstantDesc)constantDesc2;
                yield new ConstantDynamic(value.constantName(), value.constantType().descriptorString(), (Handle)JdkClassReader.toAsmConstant(value.bootstrapMethod()), value.bootstrapArgsList().stream().map(JdkClassReader::toAsmConstant).toArray());
            }
        };
    }

    private static String toInternalName(ClassDesc constant) {
        if (!constant.isClassOrInterface()) {
            throw new IllegalArgumentException("Not a class or interface: " + String.valueOf(constant));
        }
        String descriptor = constant.descriptorString();
        return descriptor.substring(1, descriptor.length() - 1);
    }

    private static TypeReference toTypeReference(TypeAnnotation.TargetInfo targetInfo) {
        TypeAnnotation.TargetInfo targetInfo2 = targetInfo;
        Objects.requireNonNull(targetInfo2);
        TypeAnnotation.TargetInfo targetInfo3 = targetInfo2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeAnnotation.SupertypeTarget.class, TypeAnnotation.TypeParameterTarget.class, TypeAnnotation.TypeParameterBoundTarget.class, TypeAnnotation.ThrowsTarget.class, TypeAnnotation.FormalParameterTarget.class, TypeAnnotation.EmptyTarget.class}, (TypeAnnotation.TargetInfo)targetInfo3, n)) {
            case 0 -> {
                TypeAnnotation.SupertypeTarget value = (TypeAnnotation.SupertypeTarget)targetInfo3;
                yield TypeReference.newSuperTypeReference(value.supertypeIndex());
            }
            case 1 -> {
                TypeAnnotation.TypeParameterTarget value = (TypeAnnotation.TypeParameterTarget)targetInfo3;
                yield TypeReference.newTypeParameterReference(value.targetType().targetTypeValue(), value.typeParameterIndex());
            }
            case 2 -> {
                TypeAnnotation.TypeParameterBoundTarget value = (TypeAnnotation.TypeParameterBoundTarget)targetInfo3;
                yield TypeReference.newTypeParameterBoundReference(value.targetType().targetTypeValue(), value.typeParameterIndex(), value.boundIndex());
            }
            case 3 -> {
                TypeAnnotation.ThrowsTarget value = (TypeAnnotation.ThrowsTarget)targetInfo3;
                yield TypeReference.newExceptionReference(value.throwsTargetIndex());
            }
            case 4 -> {
                TypeAnnotation.FormalParameterTarget value = (TypeAnnotation.FormalParameterTarget)targetInfo3;
                yield TypeReference.newFormalParameterReference(value.formalParameterIndex());
            }
            case 5 -> {
                TypeAnnotation.EmptyTarget value = (TypeAnnotation.EmptyTarget)targetInfo3;
                yield TypeReference.newTypeReference(value.targetType().targetTypeValue());
            }
            default -> throw new UnsupportedOperationException("Unexpected target: " + String.valueOf(targetInfo));
        };
    }

    private static TypePath toTypePath(List<TypeAnnotation.TypePathComponent> components) {
        if (components.isEmpty()) {
            return null;
        }
        return TypePath.fromString(components.stream().map(component -> switch (component.typePathKind()) {
            default -> throw new MatchException(null, null);
            case TypeAnnotation.TypePathComponent.Kind.ARRAY -> "[";
            case TypeAnnotation.TypePathComponent.Kind.INNER_TYPE -> ".";
            case TypeAnnotation.TypePathComponent.Kind.WILDCARD -> "*";
            case TypeAnnotation.TypePathComponent.Kind.TYPE_ARGUMENT -> component.typeArgumentIndex() + ";";
        }).collect(Collectors.joining()));
    }

    private static Object toAsmFrameValue(StackMapFrameInfo.VerificationTypeInfo verificationTypeInfo, Map<java.lang.classfile.Label, Label> labels) {
        StackMapFrameInfo.VerificationTypeInfo verificationTypeInfo2 = verificationTypeInfo;
        Objects.requireNonNull(verificationTypeInfo2);
        StackMapFrameInfo.VerificationTypeInfo verificationTypeInfo3 = verificationTypeInfo2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StackMapFrameInfo.SimpleVerificationTypeInfo.class, StackMapFrameInfo.ObjectVerificationTypeInfo.class, StackMapFrameInfo.UninitializedVerificationTypeInfo.class}, (StackMapFrameInfo.VerificationTypeInfo)verificationTypeInfo3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                StackMapFrameInfo.SimpleVerificationTypeInfo value = (StackMapFrameInfo.SimpleVerificationTypeInfo)verificationTypeInfo3;
                yield value.tag();
            }
            case 1 -> {
                StackMapFrameInfo.ObjectVerificationTypeInfo value = (StackMapFrameInfo.ObjectVerificationTypeInfo)verificationTypeInfo3;
                yield value.className().asInternalName();
            }
            case 2 -> {
                StackMapFrameInfo.UninitializedVerificationTypeInfo value = (StackMapFrameInfo.UninitializedVerificationTypeInfo)verificationTypeInfo3;
                yield labels.computeIfAbsent(value.newTarget(), ignored -> new Label());
            }
        };
    }

    private static class AttributeFunction
    implements Function<Utf8Entry, AttributeMapper<?>> {
        private final Map<String, AsmAttribute> mappers;

        private AttributeFunction(Attribute[] attributePrototypes) {
            this.mappers = Stream.of(attributePrototypes).collect(Collectors.toMap(prototype -> prototype.type, AsmAttribute::of));
        }

        @Override
        public AttributeMapper<?> apply(Utf8Entry entry) {
            AsmAttribute attribute = this.mappers.get(entry.stringValue());
            return attribute == null ? null : attribute.attributeMapper();
        }
    }

    @FunctionalInterface
    private static interface AnnotationVisitorSource {
        public AnnotationVisitor visitAnnotation(String var1, boolean var2);
    }

    @FunctionalInterface
    private static interface TypeAnnotationVisitorSource {
        public AnnotationVisitor visitTypeAnnotation(int var1, TypePath var2, String var3, boolean var4);
    }

    private static class PushbackIterator<T>
    implements Iterator<T> {
        private final Iterator<T> it;
        private T value;

        private PushbackIterator(Iterator<T> it) {
            this.it = it;
        }

        private void push(T value) {
            if (this.value != null) {
                throw new IllegalStateException();
            }
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.value != null || this.it.hasNext();
        }

        @Override
        public T next() {
            if (this.value == null) {
                return this.it.next();
            }
            T next = this.value;
            this.value = null;
            return next;
        }
    }

    private record MergedLocalVariableKey(Label start, Label end, String name, int slot) {
    }

    private record MergedLocalVariableValue(String descriptor, String signature) {
    }
}

