/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.FigureVisitor;
import org.eclipse.wb.internal.draw2d.ICustomTooltipProvider;

public class Figure
extends org.eclipse.draw2d.Figure {
    private String m_toolTipText;
    private ICustomTooltipProvider m_customTooltipProvider;

    public <T> Iterator<T> getListeners(Class<T> listenerClass) {
        return super.getListeners(listenerClass);
    }

    public final void accept(FigureVisitor visitor, boolean forward) {
        if (visitor.visit(this)) {
            List children = this.getChildren();
            int size = children.size();
            if (forward) {
                int i = 0;
                while (i < size) {
                    Figure childFigure = (Figure)((Object)children.get(i));
                    childFigure.accept(visitor, forward);
                    ++i;
                }
            } else {
                int i = size - 1;
                while (i >= 0) {
                    Figure childFigure = (Figure)((Object)children.get(i));
                    childFigure.accept(visitor, forward);
                    --i;
                }
            }
            visitor.endVisit(this);
        }
    }

    public FigureCanvas getFigureCanvas() {
        return ((Figure)this.getParent()).getFigureCanvas();
    }

    public final void paint(Graphics graphics) {
        if (this.getBackgroundColor() != null) {
            graphics.setBackgroundColor(this.getBackgroundColor());
        }
        if (this.getForegroundColor() != null) {
            graphics.setForegroundColor(this.getForegroundColor());
        }
        if (this.getFont() != null) {
            graphics.setFont(this.getFont());
        }
        graphics.pushState();
        try {
            this.paintFigure(graphics);
            this.paintChildren(graphics);
            this.paintBorder(graphics);
        }
        finally {
            graphics.popState();
        }
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque()) {
            Rectangle bounds = this.getBounds();
            graphics.fillRectangle(0, 0, bounds.width, bounds.height);
        }
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        this.paintClientArea(graphics);
        graphics.restoreState();
    }

    protected void paintChildren(Graphics graphics) {
        List children = this.getChildren();
        if (children.isEmpty()) {
            return;
        }
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        graphics.pushState();
        for (IFigure childFigure : children) {
            if (!childFigure.isVisible() || !childFigure.intersects(graphics.getClip(new Rectangle()))) continue;
            Rectangle childBounds = childFigure.getBounds();
            graphics.clipRect(childBounds);
            graphics.translate(childBounds.x, childBounds.y);
            childFigure.paint(graphics);
            graphics.restoreState();
        }
        graphics.popState();
        graphics.restoreState();
    }

    protected void paintClientArea(Graphics graphics) {
    }

    public String getToolTipText() {
        return this.m_toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this.m_toolTipText = toolTipText;
    }

    public ICustomTooltipProvider getCustomTooltipProvider() {
        return this.m_customTooltipProvider;
    }

    public void setCustomTooltipProvider(ICustomTooltipProvider provider) {
        this.m_customTooltipProvider = provider;
    }

    protected boolean useLocalCoordinates() {
        return true;
    }
}

