/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.selection;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.internal.draw2d.SemiTransparentFigure;

public class TopResizeFigure
extends SemiTransparentFigure {
    private String m_sizeText;

    public TopResizeFigure() {
        super(64);
        this.setBackgroundColor(ColorConstants.lightGreen);
        this.setForegroundColor(ColorConstants.darkGray);
        this.setBorder(new LineBorder(ColorConstants.darkBlue, 1));
    }

    public void setSizeText(String sizeText) {
        this.m_sizeText = sizeText;
    }

    @Override
    protected void paintClientArea(Graphics graphics) {
        super.paintClientArea(graphics);
        if (!StringUtils.isEmpty((CharSequence)this.m_sizeText)) {
            Rectangle area = this.getClientArea();
            Font oldFont = graphics.getFont();
            Font newFont = FontDescriptor.createFrom((Font)oldFont).setHeight(16).setStyle(0).createFont(null);
            graphics.setFont(newFont);
            Dimension textExtent = TextUtilities.INSTANCE.getTextExtents(this.m_sizeText, graphics.getFont());
            int x = area.x + (area.width - textExtent.width) / 2;
            int y = area.y + (area.height - textExtent.height) / 2;
            graphics.drawString(this.m_sizeText, x, y);
            graphics.setFont(oldFont);
            newFont.dispose();
        }
    }
}

