/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.tcf.te.ui.views.internal.RestoreDone;
import org.eclipse.tcf.te.ui.views.internal.RestoreJob;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.IMementoAware;

public class ViewExpandingState
implements IMementoAware {
    private CommonViewer viewer;

    public ViewExpandingState(CommonViewer viewer) {
        this.viewer = viewer;
    }

    public void restoreState(IMemento memento) {
        RestoreJob job = new RestoreJob(memento);
        job.addJobChangeListener((IJobChangeListener)new RestoreDone((TreeViewer)this.viewer));
        job.schedule();
    }

    public void saveState(IMemento memento) {
        TreePath[] paths;
        int n;
        Object[] elements = this.viewer.getVisibleExpandedElements();
        HashMap<Object, UUID> savedElements = new HashMap<Object, UUID>();
        if (elements != null && elements.length > 0) {
            IMemento memExpand = memento.createChild("expanded-elements");
            Object[] objectArray = elements;
            n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                UUID uuid;
                Object element = objectArray[n2];
                if (element instanceof IAdaptable && (uuid = this.saveElement(memExpand, (IAdaptable)element)) != null) {
                    savedElements.put(element, uuid);
                }
                ++n2;
            }
        }
        if ((paths = this.viewer.getExpandedTreePaths()) != null && paths.length > 0) {
            IMemento memExpand = memento.createChild("expanded-paths");
            TreePath[] treePathArray = paths;
            int n3 = paths.length;
            n = 0;
            while (n < n3) {
                TreePath path = treePathArray[n];
                if (this.isPathVisible(path, savedElements)) {
                    this.savePath(memExpand, path, savedElements);
                }
                ++n;
            }
        }
    }

    private boolean isPathVisible(TreePath path, Map<Object, UUID> visibleElements) {
        int count = path.getSegmentCount();
        int i = 0;
        while (i < count) {
            Object element = path.getSegment(i);
            if (visibleElements.get(element) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void savePath(IMemento memExpand, TreePath path, Map<Object, UUID> savedElements) {
        IMemento pathElement = memExpand.createChild("path");
        int count = path.getSegmentCount();
        int i = 0;
        while (i < count) {
            Object element = path.getSegment(i);
            UUID uuid = savedElements.get(element);
            pathElement.createChild("element", uuid.toString());
            ++i;
        }
    }

    private UUID saveElement(IMemento memExpand, IAdaptable element) {
        IPersistableElement persistable = (IPersistableElement)element.getAdapter(IPersistableElement.class);
        if (persistable == null) {
            persistable = (IPersistableElement)Platform.getAdapterManager().getAdapter((Object)element, IPersistableElement.class);
        }
        if (persistable != null) {
            UUID uuid = UUID.randomUUID();
            String factoryId = persistable.getFactoryId();
            IMemento memElement = memExpand.createChild("element", uuid.toString());
            memElement.putString("factoryId", factoryId);
            persistable.saveState(memElement);
            return uuid;
        }
        return null;
    }
}

